/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.readers;

import com.google.common.base.Preconditions;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.apache.pinot.segment.spi.index.reader.RangeIndexReader;
import org.apache.pinot.segment.spi.memory.PinotDataBuffer;
import org.apache.pinot.spi.data.FieldSpec;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangeIndexReaderImpl
implements RangeIndexReader<ImmutableRoaringBitmap> {
    public static final Logger LOGGER = LoggerFactory.getLogger(RangeIndexReaderImpl.class);
    private final PinotDataBuffer _dataBuffer;
    private final FieldSpec.DataType _valueType;
    private final int _numRanges;
    final long _bitmapIndexOffset;
    private final Number[] _rangeStartArray;
    private final Number _lastRangeEnd;

    public RangeIndexReaderImpl(PinotDataBuffer dataBuffer) {
        this._dataBuffer = dataBuffer;
        long offset = 0L;
        int version = dataBuffer.getInt(offset);
        assert (version == 1) : "invalid version";
        int valueTypeBytesLength = dataBuffer.getInt(offset += 4L);
        byte[] valueTypeBytes = new byte[valueTypeBytesLength];
        dataBuffer.copyTo(offset += 4L, valueTypeBytes);
        this._valueType = FieldSpec.DataType.valueOf((String)new String(valueTypeBytes));
        this._numRanges = dataBuffer.getInt(offset += (long)valueTypeBytesLength);
        long rangeArrayStartOffset = offset += 4L;
        this._rangeStartArray = new Number[this._numRanges];
        long lastOffset = dataBuffer.getLong(offset + (long)(this._numRanges + 1) * (long)this._valueType.size() + (long)this._numRanges * 8L);
        this._bitmapIndexOffset = offset + (long)(this._numRanges + 1) * (long)this._valueType.size();
        Preconditions.checkState((lastOffset == dataBuffer.size() ? 1 : 0) != 0, (Object)("The last offset should be equal to buffer size! Current lastOffset: " + lastOffset + ", buffer size: " + dataBuffer.size()));
        switch (this._valueType) {
            case INT: {
                for (int i = 0; i < this._numRanges; ++i) {
                    this._rangeStartArray[i] = dataBuffer.getInt(rangeArrayStartOffset + (long)i * 4L);
                }
                this._lastRangeEnd = dataBuffer.getInt(rangeArrayStartOffset + (long)this._numRanges * 4L);
                break;
            }
            case LONG: {
                for (int i = 0; i < this._numRanges; ++i) {
                    this._rangeStartArray[i] = dataBuffer.getLong(rangeArrayStartOffset + (long)i * 8L);
                }
                this._lastRangeEnd = dataBuffer.getLong(rangeArrayStartOffset + (long)this._numRanges * 8L);
                break;
            }
            case FLOAT: {
                for (int i = 0; i < this._numRanges; ++i) {
                    this._rangeStartArray[i] = Float.valueOf(dataBuffer.getFloat(rangeArrayStartOffset + (long)i * 4L));
                }
                this._lastRangeEnd = Float.valueOf(dataBuffer.getFloat(rangeArrayStartOffset + (long)this._numRanges * 4L));
                break;
            }
            case DOUBLE: {
                for (int i = 0; i < this._numRanges; ++i) {
                    this._rangeStartArray[i] = dataBuffer.getDouble(rangeArrayStartOffset + (long)i * 8L);
                }
                this._lastRangeEnd = dataBuffer.getDouble(rangeArrayStartOffset + (long)this._numRanges * 8L);
                break;
            }
            default: {
                throw new RuntimeException("Range Index Unsupported for dataType:" + this._valueType);
            }
        }
    }

    public boolean isExact() {
        return false;
    }

    public int getNumMatchingDocs(int min, int max) {
        ImmutableRoaringBitmap matching = this.getMatchingDocIds(min, max);
        return matching == null ? 0 : matching.getCardinality();
    }

    public int getNumMatchingDocs(long min, long max) {
        ImmutableRoaringBitmap matching = this.getMatchingDocIds(min, max);
        return matching == null ? 0 : matching.getCardinality();
    }

    public int getNumMatchingDocs(float min, float max) {
        ImmutableRoaringBitmap matching = this.getMatchingDocIds(min, max);
        return matching == null ? 0 : matching.getCardinality();
    }

    public int getNumMatchingDocs(double min, double max) {
        ImmutableRoaringBitmap matching = this.getMatchingDocIds(min, max);
        return matching == null ? 0 : matching.getCardinality();
    }

    @Nullable
    public ImmutableRoaringBitmap getMatchingDocIds(long min, long max) {
        return this.getMatchesInRange(this.findRangeId(min), this.findRangeId(max));
    }

    @Nullable
    public ImmutableRoaringBitmap getMatchingDocIds(int min, int max) {
        return this.getMatchesInRange(this.findRangeId(min), this.findRangeId(max));
    }

    @Nullable
    public ImmutableRoaringBitmap getMatchingDocIds(double min, double max) {
        return this.getMatchesInRange(this.findRangeId(min), this.findRangeId(max));
    }

    @Nullable
    public ImmutableRoaringBitmap getMatchingDocIds(float min, float max) {
        return this.getMatchesInRange(this.findRangeId(min), this.findRangeId(max));
    }

    @Nullable
    public ImmutableRoaringBitmap getPartiallyMatchingDocIds(long min, long max) {
        return this.getPartialMatchesInRange(this.findRangeId(min), this.findRangeId(max));
    }

    @Nullable
    public ImmutableRoaringBitmap getPartiallyMatchingDocIds(int min, int max) {
        return this.getPartialMatchesInRange(this.findRangeId(min), this.findRangeId(max));
    }

    @Nullable
    public ImmutableRoaringBitmap getPartiallyMatchingDocIds(double min, double max) {
        return this.getPartialMatchesInRange(this.findRangeId(min), this.findRangeId(max));
    }

    @Nullable
    public ImmutableRoaringBitmap getPartiallyMatchingDocIds(float min, float max) {
        return this.getPartialMatchesInRange(this.findRangeId(min), this.findRangeId(max));
    }

    private ImmutableRoaringBitmap getDocIds(int rangeId) {
        long currentOffset = this.getOffset(rangeId);
        long nextOffset = this.getOffset(rangeId + 1);
        int bufferLength = (int)(nextOffset - currentOffset);
        ByteBuffer bb = this._dataBuffer.toDirectByteBuffer(currentOffset, bufferLength);
        return new ImmutableRoaringBitmap(bb);
    }

    private long getOffset(int rangeId) {
        return this._dataBuffer.getLong(this._bitmapIndexOffset + (long)rangeId * 8L);
    }

    private int findRangeId(int value) {
        for (int i = 0; i < this._rangeStartArray.length; ++i) {
            if (value >= this._rangeStartArray[i].intValue()) continue;
            return i - 1;
        }
        return value <= this._lastRangeEnd.intValue() ? this._rangeStartArray.length - 1 : this._rangeStartArray.length;
    }

    private int findRangeId(long value) {
        for (int i = 0; i < this._rangeStartArray.length; ++i) {
            if (value >= this._rangeStartArray[i].longValue()) continue;
            return i - 1;
        }
        return value <= this._lastRangeEnd.longValue() ? this._rangeStartArray.length - 1 : this._rangeStartArray.length;
    }

    private int findRangeId(float value) {
        for (int i = 0; i < this._rangeStartArray.length; ++i) {
            if (!(value < this._rangeStartArray[i].floatValue())) continue;
            return i - 1;
        }
        return value <= this._lastRangeEnd.floatValue() ? this._rangeStartArray.length - 1 : this._rangeStartArray.length;
    }

    private int findRangeId(double value) {
        for (int i = 0; i < this._rangeStartArray.length; ++i) {
            if (!(value < this._rangeStartArray[i].doubleValue())) continue;
            return i - 1;
        }
        return value <= this._lastRangeEnd.doubleValue() ? this._rangeStartArray.length - 1 : this._rangeStartArray.length;
    }

    public void close() {
    }

    private ImmutableRoaringBitmap getMatchesInRange(int firstRangeId, int lastRangeId) {
        MutableRoaringBitmap matching = firstRangeId + 1 < lastRangeId ? new MutableRoaringBitmap() : null;
        for (int rangeId = firstRangeId + 1; rangeId < lastRangeId; ++rangeId) {
            matching.or(this.getDocIds(rangeId));
        }
        return matching;
    }

    private ImmutableRoaringBitmap getPartialMatchesInRange(int firstRangeId, int lastRangeId) {
        if (this.isOutOfRange(firstRangeId)) {
            return this.isOutOfRange(lastRangeId) ? null : this.getDocIds(lastRangeId);
        }
        if (this.isOutOfRange(lastRangeId)) {
            return this.getDocIds(firstRangeId);
        }
        return ImmutableRoaringBitmap.or((ImmutableRoaringBitmap)this.getDocIds(firstRangeId), (ImmutableRoaringBitmap)this.getDocIds(lastRangeId));
    }

    private boolean isOutOfRange(int rangeId) {
        return rangeId < 0 || rangeId >= this._rangeStartArray.length;
    }
}

