/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator.impl.fwd;

import java.io.File;
import java.io.IOException;
import org.apache.pinot.segment.local.io.util.PinotDataBitSet;
import org.apache.pinot.segment.local.io.writer.impl.FixedBitSVForwardIndexWriter;
import org.apache.pinot.segment.spi.index.creator.ForwardIndexCreator;
import org.apache.pinot.spi.data.FieldSpec;

public class SingleValueUnsortedForwardIndexCreator
implements ForwardIndexCreator {
    private final FixedBitSVForwardIndexWriter _writer;

    public SingleValueUnsortedForwardIndexCreator(File outputDir, String column, int cardinality, int numDocs) throws Exception {
        File indexFile = new File(outputDir, column + ".sv.unsorted.fwd");
        this._writer = new FixedBitSVForwardIndexWriter(indexFile, numDocs, PinotDataBitSet.getNumBitsPerValue(cardinality - 1));
    }

    public boolean isDictionaryEncoded() {
        return true;
    }

    public boolean isSingleValue() {
        return true;
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.INT;
    }

    public void putDictId(int dictId) {
        this._writer.putDictId(dictId);
    }

    public void close() throws IOException {
        this._writer.close();
    }
}

