/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.indexsegment.mutable;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.segment.local.io.writer.impl.MmapMemoryManager;
import org.apache.pinot.segment.local.realtime.impl.dictionary.MutableDictionaryFactory;
import org.apache.pinot.segment.local.realtime.impl.forward.FixedByteMVMutableForwardIndex;
import org.apache.pinot.segment.local.realtime.impl.forward.FixedByteSVMutableForwardIndex;
import org.apache.pinot.segment.local.segment.index.column.IntermediateIndexContainer;
import org.apache.pinot.segment.local.segment.index.column.NumValuesInfo;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentColumnReader;
import org.apache.pinot.segment.local.segment.readers.PinotSegmentRecordReader;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.MutableSegment;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.creator.SegmentGeneratorConfig;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.segment.spi.index.mutable.MutableDictionary;
import org.apache.pinot.segment.spi.index.mutable.MutableForwardIndex;
import org.apache.pinot.segment.spi.index.mutable.ThreadSafeMutableRoaringBitmap;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2;
import org.apache.pinot.segment.spi.memory.PinotDataBufferMemoryManager;
import org.apache.pinot.segment.spi.partition.PartitionFunction;
import org.apache.pinot.segment.spi.partition.PartitionFunctionFactory;
import org.apache.pinot.spi.config.table.SegmentPartitionConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.stream.RowMetadata;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IntermediateSegment
implements MutableSegment {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntermediateSegment.class);
    private static final int MAX_MULTI_VALUES_PER_ROW = 1000;
    private static final int DEFAULT_CAPACITY = 100000;
    private static final int DEFAULT_EST_AVG_COL_SIZE = 32;
    private static final int DEFAULT_EST_CARDINALITY = 5000;
    private static final int DEFAULT_AVG_MULTI_VALUE_COUNT = 2;
    private final SegmentGeneratorConfig _segmentGeneratorConfig;
    private final Schema _schema;
    private final TableConfig _tableConfig;
    private final String _segmentName;
    private final SegmentMetadata _segmentMetadata;
    private final Map<String, IntermediateIndexContainer> _indexContainerMap = new HashMap<String, IntermediateIndexContainer>();
    private final PinotDataBufferMemoryManager _memoryManager;
    private final File _mmapDir;
    private final int _capacity = 100000;
    private volatile int _numDocsIndexed = 0;

    public IntermediateSegment(SegmentGeneratorConfig segmentGeneratorConfig) {
        this._segmentGeneratorConfig = segmentGeneratorConfig;
        this._schema = segmentGeneratorConfig.getSchema();
        this._tableConfig = segmentGeneratorConfig.getTableConfig();
        this._segmentName = this._segmentGeneratorConfig.getTableName() + System.currentTimeMillis();
        this._segmentMetadata = new SegmentMetadataImpl(TableNameBuilder.extractRawTableName((String)this._tableConfig.getTableName()), this._segmentName, this._schema, System.currentTimeMillis()){

            public int getTotalDocs() {
                return IntermediateSegment.this._numDocsIndexed;
            }
        };
        Collection allFieldSpecs = this._schema.getAllFieldSpecs();
        ArrayList<FieldSpec> physicalFieldSpecs = new ArrayList<FieldSpec>(allFieldSpecs.size());
        for (FieldSpec fieldSpec : allFieldSpecs) {
            if (fieldSpec.isVirtualColumn()) continue;
            physicalFieldSpecs.add(fieldSpec);
        }
        String outputDir = segmentGeneratorConfig.getOutDir();
        this._mmapDir = new File(outputDir, this._segmentName + "_mmap_" + UUID.randomUUID());
        this._mmapDir.mkdir();
        LOGGER.info("Mmap file dir: " + this._mmapDir);
        this._memoryManager = new MmapMemoryManager(this._mmapDir.toString(), this._segmentName, null);
        for (FieldSpec fieldSpec : physicalFieldSpecs) {
            Object forwardIndex;
            String allocationContext;
            FieldSpec.DataType storedType;
            boolean isFixedWidthColumn;
            String column = fieldSpec.getName();
            SegmentPartitionConfig segmentPartitionConfig = segmentGeneratorConfig.getSegmentPartitionConfig();
            PartitionFunction partitionFunction = null;
            HashSet<Integer> partitions = null;
            if (segmentPartitionConfig != null && segmentPartitionConfig.getColumnPartitionMap().containsKey(column)) {
                partitionFunction = PartitionFunctionFactory.getPartitionFunction((String)segmentPartitionConfig.getFunctionName(column), (int)segmentPartitionConfig.getNumPartitions(column), (Map)segmentPartitionConfig.getFunctionConfig(column));
                partitions = new HashSet<Integer>();
                partitions.add(segmentGeneratorConfig.getSequenceId());
            }
            int dictionaryColumnSize = (isFixedWidthColumn = (storedType = fieldSpec.getDataType().getStoredType()).isFixedWidth()) ? storedType.size() : 32;
            int estimatedCardinality = 5500;
            String dictionaryAllocationContext = this.buildAllocationContext(this._segmentName, column, ".dict");
            MutableDictionary dictionary = MutableDictionaryFactory.getMutableDictionary(storedType, true, this._memoryManager, dictionaryColumnSize, Math.min(estimatedCardinality, 100000), dictionaryAllocationContext);
            if (fieldSpec.isSingleValueField()) {
                allocationContext = this.buildAllocationContext(this._segmentName, column, ".sv.unsorted.fwd");
                forwardIndex = new FixedByteSVMutableForwardIndex(true, FieldSpec.DataType.INT, 100000, this._memoryManager, allocationContext);
            } else {
                allocationContext = this.buildAllocationContext(this._segmentName, column, ".mv.fwd");
                forwardIndex = new FixedByteMVMutableForwardIndex(1000, 2, 100000, 4, this._memoryManager, allocationContext, true, FieldSpec.DataType.INT);
            }
            this._indexContainerMap.put(column, new IntermediateIndexContainer(fieldSpec, partitionFunction, (Set<Integer>)partitions, new NumValuesInfo(), (MutableForwardIndex)forwardIndex, dictionary));
        }
    }

    public boolean index(GenericRow row, @Nullable RowMetadata rowMetadata) throws IOException {
        this.updateDictionary(row);
        this.addNewRow(row);
        ++this._numDocsIndexed;
        return true;
    }

    public int getNumDocsIndexed() {
        return this._numDocsIndexed;
    }

    public String getSegmentName() {
        return this._segmentName;
    }

    public SegmentMetadata getSegmentMetadata() {
        return this._segmentMetadata;
    }

    public Set<String> getColumnNames() {
        return this._schema.getColumnNames();
    }

    public Set<String> getPhysicalColumnNames() {
        return this._schema.getPhysicalColumnNames();
    }

    public DataSource getDataSource(String columnName) {
        return this._indexContainerMap.get(columnName).toDataSource(this._numDocsIndexed);
    }

    public List<StarTreeV2> getStarTrees() {
        return null;
    }

    @Nullable
    public ThreadSafeMutableRoaringBitmap getValidDocIds() {
        return null;
    }

    public GenericRow getRecord(int docId, GenericRow reuse) {
        GenericRow genericRow;
        PinotSegmentRecordReader recordReader = new PinotSegmentRecordReader();
        try {
            recordReader.init((IndexSegment)this);
            recordReader.getRecord(docId, reuse);
            genericRow = reuse;
        }
        catch (Throwable throwable) {
            try {
                try {
                    recordReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Caught exception while reading record for docId: " + docId, e);
            }
        }
        recordReader.close();
        return genericRow;
    }

    public Object getValue(int docId, String column) {
        Object object;
        PinotSegmentColumnReader columnReader = new PinotSegmentColumnReader((IndexSegment)this, column);
        try {
            object = columnReader.getValue(docId);
        }
        catch (Throwable throwable) {
            try {
                try {
                    columnReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("Caught exception while reading value for docId: %d, column: %s", docId, column), e);
            }
        }
        columnReader.close();
        return object;
    }

    public void destroy() {
        String segmentName = this.getSegmentName();
        LOGGER.info("Trying to destroy segment : {}", (Object)segmentName);
        for (Map.Entry<String, IntermediateIndexContainer> entry : this._indexContainerMap.entrySet()) {
            try {
                entry.getValue().close();
            }
            catch (IOException e) {
                LOGGER.error("Failed to close indexes for column: {}. Continuing with error.", (Object)entry.getKey(), (Object)e);
            }
        }
        FileUtils.deleteQuietly((File)this._mmapDir);
    }

    private void updateDictionary(GenericRow row) {
        for (Map.Entry<String, IntermediateIndexContainer> entry : this._indexContainerMap.entrySet()) {
            String column = entry.getKey();
            IntermediateIndexContainer indexContainer = entry.getValue();
            Object value = row.getValue(column);
            MutableDictionary dictionary = indexContainer.getDictionary();
            if (dictionary == null) continue;
            if (indexContainer.getFieldSpec().isSingleValueField()) {
                indexContainer.setDictId(dictionary.index(value));
            } else {
                indexContainer.setDictIds(dictionary.index((Object[])value));
            }
            indexContainer.setMinValue(dictionary.getMinVal());
            indexContainer.setMaxValue(dictionary.getMaxVal());
        }
    }

    private void addNewRow(GenericRow row) throws IOException {
        int docId = this._numDocsIndexed;
        for (Map.Entry<String, IntermediateIndexContainer> entry : this._indexContainerMap.entrySet()) {
            String column = entry.getKey();
            IntermediateIndexContainer indexContainer = entry.getValue();
            Object value = row.getValue(column);
            FieldSpec fieldSpec = indexContainer.getFieldSpec();
            if (fieldSpec.isSingleValueField()) {
                indexContainer.getNumValuesInfo().updateSVEntry();
                MutableForwardIndex forwardIndex = indexContainer.getForwardIndex();
                int dictId = indexContainer.getDictId();
                if (dictId >= 0) {
                    forwardIndex.setDictId(docId, dictId);
                    continue;
                }
                FieldSpec.DataType dataType = fieldSpec.getDataType();
                switch (dataType.getStoredType()) {
                    case INT: {
                        forwardIndex.setInt(docId, ((Integer)value).intValue());
                        break;
                    }
                    case LONG: {
                        forwardIndex.setLong(docId, ((Long)value).longValue());
                        break;
                    }
                    case FLOAT: {
                        forwardIndex.setFloat(docId, ((Float)value).floatValue());
                        break;
                    }
                    case DOUBLE: {
                        forwardIndex.setDouble(docId, ((Double)value).doubleValue());
                        break;
                    }
                    case STRING: {
                        forwardIndex.setString(docId, (String)value);
                        break;
                    }
                    case BYTES: {
                        forwardIndex.setBytes(docId, (byte[])value);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Unsupported data type: " + dataType + " for no-dictionary column: " + column);
                    }
                }
                if (fieldSpec.getFieldType() == FieldSpec.FieldType.METRIC) continue;
                Comparable comparable = dataType == FieldSpec.DataType.BYTES ? new ByteArray((byte[])value) : (Comparable)value;
                if (indexContainer.getMinValue() == null) {
                    indexContainer.setMinValue(comparable);
                    indexContainer.setMaxValue(comparable);
                    continue;
                }
                if (comparable.compareTo(indexContainer.getMinValue()) < 0) {
                    indexContainer.setMinValue(comparable);
                }
                if (comparable.compareTo(indexContainer.getMaxValue()) <= 0) continue;
                indexContainer.setMaxValue(comparable);
                continue;
            }
            int[] dictIds = indexContainer.getDictIds();
            indexContainer.getNumValuesInfo().updateMVEntry(dictIds.length);
            indexContainer.getForwardIndex().setDictIdMV(docId, dictIds);
        }
    }

    private String buildAllocationContext(String segmentName, String columnName, String indexType) {
        return segmentName + ":" + columnName + indexType;
    }
}

