/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.customobject;

import com.google.common.base.Preconditions;
import org.apache.pinot.segment.local.customobject.QuantileDigest;
import org.apache.pinot.segment.local.utils.CustomSerDeUtils;
import org.apache.pinot.spi.utils.BytesUtils;

public class SerializedQuantileDigest
implements Comparable<SerializedQuantileDigest> {
    private final double _percentile;
    private final QuantileDigest _quantileDigest;

    public SerializedQuantileDigest(QuantileDigest quantileDigest, double percentile) {
        this._quantileDigest = quantileDigest;
        this._percentile = percentile / 100.0;
    }

    @Override
    public int compareTo(SerializedQuantileDigest other) {
        Preconditions.checkArgument((other._percentile == this._percentile ? 1 : 0) != 0, (Object)"Percentile number doesn't match!");
        return Long.compare(this._quantileDigest.getQuantile(this._percentile), other._quantileDigest.getQuantile(this._percentile));
    }

    public String toString() {
        return BytesUtils.toHexString((byte[])CustomSerDeUtils.QUANTILE_DIGEST_SER_DE.serialize(this._quantileDigest));
    }
}

