/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration;

import com.google.common.base.Preconditions;
import com.google.common.reflect.AbstractInvocationHandler;
import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.ConfigBinder;
import io.airlift.configuration.ConfigurationAwareModule;
import io.airlift.configuration.ConfigurationFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractConfigurationAwareModule
implements ConfigurationAwareModule {
    private ConfigurationFactory configurationFactory;
    private Binder binder;

    @Override
    public synchronized void setConfigurationFactory(ConfigurationFactory configurationFactory) {
        this.configurationFactory = Objects.requireNonNull(configurationFactory, "configurationFactory is null");
    }

    public final synchronized void configure(Binder binder) {
        Preconditions.checkState((this.configurationFactory != null ? 1 : 0) != 0, (Object)"configurationFactory was not set");
        Preconditions.checkState((this.binder == null ? 1 : 0) != 0, (Object)"re-entry not allowed");
        this.binder = Objects.requireNonNull(binder, "binder is null");
        try {
            this.setup(ForbidInstallBinder.proxy(binder));
        }
        finally {
            this.binder = null;
        }
    }

    protected void consumeProperty(String name) {
        this.configurationFactory.consumeProperty(name);
    }

    protected Map<String, String> getProperties() {
        return this.configurationFactory.getProperties();
    }

    protected Optional<String> getProperty(String name) {
        return Optional.ofNullable(this.configurationFactory.getProperties().get(name));
    }

    protected synchronized <T> T buildConfigObject(Class<T> configClass) {
        ConfigBinder.configBinder(this.binder).bindConfig(configClass);
        return this.configurationFactory.build(configClass);
    }

    protected synchronized <T> T buildConfigObject(Class<T> configClass, String prefix) {
        ConfigBinder.configBinder(this.binder).bindConfig(configClass, prefix);
        return this.configurationFactory.build(configClass, prefix);
    }

    protected synchronized void install(Module module) {
        if (module instanceof ConfigurationAwareModule) {
            ((ConfigurationAwareModule)module).setConfigurationFactory(this.configurationFactory);
        }
        this.binder.install(module);
    }

    protected abstract void setup(Binder var1);

    private static class ForbidInstallBinder
    extends AbstractInvocationHandler {
        private static final Method INSTALL_METHOD;
        private final Binder delegate;

        static Binder proxy(Binder binder) {
            return (Binder)Proxy.newProxyInstance(ForbidInstallBinder.class.getClassLoader(), new Class[]{Binder.class}, (InvocationHandler)((Object)new ForbidInstallBinder(binder)));
        }

        public ForbidInstallBinder(Binder delegate) {
            this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        }

        protected Object handleInvocation(Object proxy, Method method, Object[] args) throws Throwable {
            if (INSTALL_METHOD.equals(method) && args[0] instanceof ConfigurationAwareModule) {
                throw new IllegalStateException("Use super.install() for ConfigurationAwareModule, not binder.install()");
            }
            return method.invoke((Object)this.delegate, args);
        }

        static {
            try {
                INSTALL_METHOD = Binder.class.getMethod("install", Module.class);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

