/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst.builder;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.pinot.segment.local.utils.nativefst.FST;
import org.apache.pinot.segment.local.utils.nativefst.FSTFlags;
import org.apache.pinot.segment.local.utils.nativefst.FSTHeader;
import org.apache.pinot.segment.local.utils.nativefst.builder.FSTSerializer;
import org.apache.pinot.segment.local.utils.nativefst.builder.FSTUtils;

public final class FSTSerializerImpl
implements FSTSerializer {
    private static final int MAX_ARC_SIZE = 6;
    private static final int MAX_NODE_DATA_SIZE = 16;
    private static final int SIZEOF_FLAGS = 1;
    private static final boolean IS_TRACE_ACTIVATED = false;
    private static final EnumSet<FSTFlags> FST_FLAGS = EnumSet.of(FSTFlags.NUMBERS, FSTFlags.SEPARATORS, FSTFlags.FLEXIBLE, FSTFlags.STOPBIT, FSTFlags.NEXTBIT);
    public byte _fillerByte = (byte)95;
    public byte _annotationByte = (byte)43;
    private boolean _withNumbers;
    private Int2IntOpenHashMap _offsets = new Int2IntOpenHashMap();
    private Int2IntOpenHashMap _numbers = new Int2IntOpenHashMap();
    private Map<Integer, Integer> _outputSymbols = new HashMap<Integer, Integer>();

    @Override
    public FSTSerializerImpl withNumbers() {
        this._withNumbers = true;
        return this;
    }

    @Override
    public <T extends OutputStream> T serialize(FST fst, T os) throws IOException {
        int[] linearized = this.linearize(fst);
        int nodeDataLength = 0;
        if (this._withNumbers) {
            this._numbers = FSTUtils.rightLanguageForAllStates(fst);
            for (int maxNumber = this._numbers.get(fst.getRootNode()); maxNumber > 0; maxNumber >>>= 8) {
                ++nodeDataLength;
            }
        }
        int gtl = 1;
        while (true) {
            if (!this.emitArcs(fst, null, linearized, gtl, nodeDataLength)) {
                ++gtl;
                continue;
            }
            if (this.emitArcs(fst, null, linearized, gtl, nodeDataLength)) break;
            ++gtl;
        }
        FSTHeader.write(os, (byte)5);
        os.write(this._fillerByte);
        os.write(this._annotationByte);
        os.write(nodeDataLength << 4 | gtl);
        DataOutputStream dataOutputStream = new DataOutputStream(os);
        byte[] outputSymbolsSerialized = this._outputSymbols.toString().getBytes();
        dataOutputStream.writeInt(outputSymbolsSerialized.length);
        os.write(outputSymbolsSerialized);
        boolean gtlUnchanged = this.emitArcs(fst, os, linearized, gtl, nodeDataLength);
        assert (gtlUnchanged) : "gtl changed in the final pass.";
        return os;
    }

    @Override
    public Set<FSTFlags> getFlags() {
        return FST_FLAGS;
    }

    private int[] linearize(FST fst) {
        int[] linearized = new int[]{};
        int last = 0;
        BitSet visited = new BitSet();
        IntArrayList nodes = new IntArrayList();
        nodes.push(fst.getRootNode());
        while (!nodes.isEmpty()) {
            int node = nodes.pop();
            if (visited.get(node)) continue;
            if (last >= linearized.length) {
                linearized = Arrays.copyOf(linearized, linearized.length + 100000);
            }
            visited.set(node);
            linearized[last++] = node;
            int arc = fst.getFirstArc(node);
            while (arc != 0) {
                int target;
                if (!fst.isArcTerminal(arc) && !visited.get(target = fst.getEndNode(arc))) {
                    nodes.push(target);
                }
                arc = fst.getNextArc(arc);
            }
        }
        return Arrays.copyOf(linearized, last);
    }

    private boolean emitArcs(FST fst, OutputStream os, int[] linearized, int gtl, int nodeDataLength) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(Math.max(16, 6));
        int offset = 0;
        offset += this.emitNodeData(bb, os, nodeDataLength, 0);
        offset += this.emitArc(bb, os, gtl, 0, (byte)0, 0);
        offset += this.emitNodeData(bb, os, nodeDataLength, 0);
        offset = fst.getRootNode() != 0 ? (offset += this.emitArc(bb, os, gtl, 6, (byte)94, 0)) : (offset += this.emitArc(bb, os, gtl, 2, (byte)94, 0));
        int maxStates = linearized.length;
        for (int j = 0; j < maxStates; ++j) {
            int s = linearized[j];
            if (os == null) {
                this._offsets.put(s, offset);
            } else assert (this._offsets.get(s) == offset) : s + " " + this._offsets.get(s) + " " + offset;
            offset += this.emitNodeData(bb, os, nodeDataLength, this._withNumbers ? this._numbers.get(s) : 0);
            int arc = fst.getFirstArc(s);
            while (arc != 0) {
                int bytes;
                int target;
                int targetOffset;
                if (fst.isArcTerminal(arc)) {
                    targetOffset = 0;
                    target = 0;
                } else {
                    target = fst.getEndNode(arc);
                    targetOffset = this._offsets.get(target);
                }
                int flags = 0;
                if (fst.isArcFinal(arc)) {
                    flags |= 1;
                }
                if (fst.getNextArc(arc) == 0) {
                    flags |= 2;
                    if (j + 1 < maxStates && target == linearized[j + 1] && targetOffset != 0) {
                        flags |= 4;
                        targetOffset = 0;
                    }
                }
                if ((bytes = this.emitArc(bb, os, gtl, flags, fst.getArcLabel(arc), targetOffset)) < 0) {
                    return false;
                }
                if (fst.isArcFinal(arc)) {
                    this._outputSymbols.put(offset, fst.getOutputSymbol(arc));
                }
                offset += bytes;
                arc = fst.getNextArc(arc);
            }
        }
        return true;
    }

    private int emitArc(ByteBuffer bb, OutputStream os, int gtl, int flags, byte label, int targetOffset) throws IOException {
        int arcBytes = (flags & 4) != 0 ? 1 : gtl;
        flags |= targetOffset << 3;
        bb.put(label);
        for (int b = 0; b < arcBytes; ++b) {
            bb.put((byte)flags);
            flags >>>= 8;
        }
        if (flags != 0) {
            return -1;
        }
        bb.flip();
        int bytes = bb.remaining();
        if (os != null) {
            os.write(bb.array(), bb.position(), bb.remaining());
        }
        bb.clear();
        return bytes;
    }

    private int emitNodeData(ByteBuffer bb, OutputStream os, int nodeDataLength, int number) throws IOException {
        if (nodeDataLength > 0 && os != null) {
            for (int i = 0; i < nodeDataLength; ++i) {
                bb.put((byte)number);
                number >>>= 8;
            }
            bb.flip();
            os.write(bb.array(), bb.position(), bb.remaining());
            bb.clear();
        }
        return nodeDataLength;
    }
}

