/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.utils.nativefst;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.pinot.segment.local.utils.nativefst.FST;

public final class ByteSequenceIterator
implements Iterator<ByteBuffer> {
    private static final int EXPECTED_MAX_STATES = 15;
    private final FST _fst;
    private ByteBuffer _nextElement;
    private byte[] _buffer = new byte[15];
    private ByteBuffer _bufferWrapper = ByteBuffer.wrap(this._buffer);
    private int[] _arcs = new int[15];
    private int _position;

    public ByteSequenceIterator(FST fst, int node) {
        this._fst = fst;
        if (fst.getFirstArc(node) != 0) {
            this.restartFrom(node);
        }
    }

    public ByteSequenceIterator restartFrom(int node) {
        this._position = 0;
        this._bufferWrapper.clear();
        this._nextElement = null;
        this.pushNode(node);
        return this;
    }

    @Override
    public boolean hasNext() {
        if (this._nextElement == null) {
            this._nextElement = this.advance();
        }
        return this._nextElement != null;
    }

    @Override
    public ByteBuffer next() {
        if (this._nextElement != null) {
            ByteBuffer cache = this._nextElement;
            this._nextElement = null;
            return cache;
        }
        ByteBuffer cache = this.advance();
        if (cache == null) {
            throw new NoSuchElementException();
        }
        return cache;
    }

    private final ByteBuffer advance() {
        if (this._position == 0) {
            return null;
        }
        while (this._position > 0) {
            int lastIndex = this._position - 1;
            int arc = this._arcs[lastIndex];
            if (arc == 0) {
                --this._position;
                continue;
            }
            this._arcs[lastIndex] = this._fst.getNextArc(arc);
            int bufferLength = this._buffer.length;
            if (lastIndex >= bufferLength) {
                this._buffer = Arrays.copyOf(this._buffer, bufferLength + 15);
                this._bufferWrapper = ByteBuffer.wrap(this._buffer);
            }
            this._buffer[lastIndex] = this._fst.getArcLabel(arc);
            if (!this._fst.isArcTerminal(arc)) {
                this.pushNode(this._fst.getEndNode(arc));
            }
            if (!this._fst.isArcFinal(arc)) continue;
            this._bufferWrapper.clear();
            this._bufferWrapper.limit(lastIndex + 1);
            return this._bufferWrapper;
        }
        return null;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Read-only iterator.");
    }

    private void pushNode(int node) {
        if (this._position == this._arcs.length) {
            this._arcs = Arrays.copyOf(this._arcs, this._arcs.length + 15);
        }
        this._arcs[this._position++] = this._fst.getFirstArc(node);
    }
}

