/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.virtualcolumn;

import java.io.IOException;
import org.apache.pinot.segment.local.segment.index.column.BaseVirtualColumnProvider;
import org.apache.pinot.segment.local.segment.index.readers.DocIdDictionary;
import org.apache.pinot.segment.local.segment.virtualcolumn.VirtualColumnContext;
import org.apache.pinot.segment.spi.index.metadata.ColumnMetadataImpl;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReader;
import org.apache.pinot.segment.spi.index.reader.ForwardIndexReaderContext;
import org.apache.pinot.segment.spi.index.reader.InvertedIndexReader;
import org.apache.pinot.segment.spi.index.reader.SortedIndexReader;
import org.apache.pinot.spi.utils.Pairs;

public class DocIdVirtualColumnProvider
extends BaseVirtualColumnProvider {
    private static final DocIdSortedIndexReader DOC_ID_SORTED_INDEX_READER = new DocIdSortedIndexReader();

    @Override
    public ForwardIndexReader<?> buildForwardIndex(VirtualColumnContext context) {
        return DOC_ID_SORTED_INDEX_READER;
    }

    @Override
    public Dictionary buildDictionary(VirtualColumnContext context) {
        return new DocIdDictionary(context.getTotalDocCount());
    }

    public ColumnMetadataImpl buildMetadata(VirtualColumnContext context) {
        ColumnMetadataImpl.Builder columnMetadataBuilder = super.getColumnMetadataBuilder(context);
        columnMetadataBuilder.setCardinality(context.getTotalDocCount()).setSorted(true).setHasDictionary(true);
        return columnMetadataBuilder.build();
    }

    @Override
    public InvertedIndexReader<?> buildInvertedIndex(VirtualColumnContext context) {
        return DOC_ID_SORTED_INDEX_READER;
    }

    private static class DocIdSortedIndexReader
    implements SortedIndexReader<ForwardIndexReaderContext> {
        private DocIdSortedIndexReader() {
        }

        public int getDictId(int docId, ForwardIndexReaderContext context) {
            return docId;
        }

        public void readDictIds(int[] docIds, int length, int[] dictIdBuffer, ForwardIndexReaderContext context) {
            System.arraycopy(docIds, 0, dictIdBuffer, 0, length);
        }

        public Pairs.IntPair getDocIds(int dictId) {
            return new Pairs.IntPair(dictId, dictId);
        }

        public void close() throws IOException {
        }
    }
}

