/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.index.loader;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.apache.pinot.segment.local.segment.index.loader.IndexHandler;
import org.apache.pinot.segment.local.segment.index.loader.IndexLoadingConfig;
import org.apache.pinot.segment.local.segment.index.loader.InvertedIndexAndDictionaryBasedForwardIndexCreator;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.creator.IndexCreatorProvider;
import org.apache.pinot.segment.spi.store.ColumnIndexType;
import org.apache.pinot.segment.spi.store.SegmentDirectory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseIndexHandler
implements IndexHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseIndexHandler.class);
    protected final SegmentMetadata _segmentMetadata;
    protected final IndexLoadingConfig _indexLoadingConfig;
    protected final Set<String> _tmpForwardIndexColumns;

    public BaseIndexHandler(SegmentMetadata segmentMetadata, IndexLoadingConfig indexLoadingConfig) {
        this._segmentMetadata = segmentMetadata;
        this._indexLoadingConfig = indexLoadingConfig;
        this._tmpForwardIndexColumns = new HashSet<String>();
    }

    @Override
    public void postUpdateIndicesCleanup(SegmentDirectory.Writer segmentWriter) throws Exception {
        for (String column : this._tmpForwardIndexColumns) {
            segmentWriter.removeIndex(column, ColumnIndexType.FORWARD_INDEX);
        }
    }

    protected void createForwardIndexIfNeeded(SegmentDirectory.Writer segmentWriter, ColumnMetadata columnMetadata, IndexCreatorProvider indexCreatorProvider, boolean isTemporaryForwardIndex) throws IOException {
        String columnName = columnMetadata.getColumnName();
        if (segmentWriter.hasIndexFor(columnName, ColumnIndexType.FORWARD_INDEX)) {
            LOGGER.info("Forward index already exists for column: {}, skip trying to create it", (Object)columnName);
            return;
        }
        Preconditions.checkState((boolean)segmentWriter.hasIndexFor(columnName, ColumnIndexType.DICTIONARY), (Object)String.format("Forward index disabled column %s must have a dictionary", columnName));
        Preconditions.checkState((boolean)segmentWriter.hasIndexFor(columnName, ColumnIndexType.INVERTED_INDEX), (Object)String.format("Forward index disabled column %s must have an inverted index", columnName));
        LOGGER.info("Rebuilding the forward index for column: {}, is temporary: {}", (Object)columnName, (Object)isTemporaryForwardIndex);
        InvertedIndexAndDictionaryBasedForwardIndexCreator invertedIndexAndDictionaryBasedForwardIndexCreator = new InvertedIndexAndDictionaryBasedForwardIndexCreator(columnName, this._segmentMetadata, this._indexLoadingConfig, segmentWriter, indexCreatorProvider, isTemporaryForwardIndex);
        invertedIndexAndDictionaryBasedForwardIndexCreator.regenerateForwardIndex();
        if (!segmentWriter.hasIndexFor(columnName, ColumnIndexType.FORWARD_INDEX)) {
            throw new IOException(String.format("Forward index was not created for column: %s, is temporary: %s", columnName, isTemporaryForwardIndex ? "true" : "false"));
        }
        if (isTemporaryForwardIndex) {
            this._tmpForwardIndexColumns.add(columnName);
        }
        LOGGER.info("Rebuilt the forward index for column: {}, is temporary: {}", (Object)columnName, (Object)isTemporaryForwardIndex);
    }
}

