/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.segment.creator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.segment.local.recordtransformer.ComplexTypeTransformer;
import org.apache.pinot.segment.local.recordtransformer.CompositeTransformer;
import org.apache.pinot.segment.local.recordtransformer.RecordTransformer;
import org.apache.pinot.segment.local.utils.IngestionUtils;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;

public class TransformPipeline {
    private final RecordTransformer _recordTransformer;
    private final ComplexTypeTransformer _complexTypeTransformer;

    public TransformPipeline(RecordTransformer recordTransformer, @Nullable ComplexTypeTransformer complexTypeTransformer) {
        this._recordTransformer = recordTransformer;
        this._complexTypeTransformer = complexTypeTransformer;
    }

    public TransformPipeline(TableConfig tableConfig, Schema schema) {
        this._recordTransformer = CompositeTransformer.getDefaultTransformer(tableConfig, schema);
        this._complexTypeTransformer = ComplexTypeTransformer.getComplexTypeTransformer(tableConfig);
    }

    public static TransformPipeline getPassThroughPipeline() {
        return new TransformPipeline(CompositeTransformer.getPassThroughTransformer(), null);
    }

    public void processRow(GenericRow decodedRow, Result reusedResult) throws Exception {
        Collection rows;
        reusedResult.reset();
        if (this._complexTypeTransformer != null) {
            decodedRow = this._complexTypeTransformer.transform(decodedRow);
        }
        if ((rows = (Collection)decodedRow.getValue("$MULTIPLE_RECORDS_KEY$")) != null) {
            for (GenericRow row : rows) {
                this.processPlainRow(row, reusedResult);
            }
        } else {
            this.processPlainRow(decodedRow, reusedResult);
        }
    }

    private void processPlainRow(GenericRow plainRow, Result reusedResult) {
        GenericRow transformedRow = this._recordTransformer.transform(plainRow);
        if (transformedRow != null && IngestionUtils.shouldIngestRow(transformedRow)) {
            reusedResult.addTransformedRows(transformedRow);
            if (Boolean.TRUE.equals(transformedRow.getValue("$INCOMPLETE_RECORD_KEY$"))) {
                reusedResult.incIncompleteRowCount();
            }
        } else {
            reusedResult.incSkippedRowCount();
        }
    }

    public static class Result {
        private final List<GenericRow> _transformedRows = new ArrayList<GenericRow>();
        private int _skippedRowCount = 0;
        private int _incompleteRowCount = 0;

        public List<GenericRow> getTransformedRows() {
            return this._transformedRows;
        }

        public int getSkippedRowCount() {
            return this._skippedRowCount;
        }

        public int getIncompleteRowCount() {
            return this._incompleteRowCount;
        }

        public void addTransformedRows(GenericRow row) {
            this._transformedRows.add(row);
        }

        public void incSkippedRowCount() {
            ++this._skippedRowCount;
        }

        public void incIncompleteRowCount() {
            ++this._incompleteRowCount;
        }

        public void reset() {
            this._skippedRowCount = 0;
            this._incompleteRowCount = 0;
            this._transformedRows.clear();
        }
    }
}

