/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.recordtransformer;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.segment.local.recordtransformer.RecordTransformer;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.utils.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NullValueTransformer
implements RecordTransformer {
    private static final Logger LOGGER = LoggerFactory.getLogger(NullValueTransformer.class);
    private final Map<String, Object> _defaultNullValues = new HashMap<String, Object>();

    public NullValueTransformer(TableConfig tableConfig, Schema schema) {
        String timeColumnName = tableConfig.getValidationConfig().getTimeColumnName();
        for (FieldSpec fieldSpec : schema.getAllFieldSpecs()) {
            if (fieldSpec.isVirtualColumn() || fieldSpec.getName().equals(timeColumnName)) continue;
            String fieldName = fieldSpec.getName();
            Object defaultNullValue = fieldSpec.getDefaultNullValue();
            if (fieldSpec.isSingleValueField()) {
                this._defaultNullValues.put(fieldName, defaultNullValue);
                continue;
            }
            this._defaultNullValues.put(fieldName, new Object[]{defaultNullValue});
        }
        if (StringUtils.isNotEmpty((CharSequence)timeColumnName)) {
            DateTimeFieldSpec timeColumnSpec = schema.getSpecForTimeColumn(timeColumnName);
            Preconditions.checkState((timeColumnSpec != null ? 1 : 0) != 0, (String)"Failed to find time field: %s from schema: %s", (Object)timeColumnName, (Object)schema.getSchemaName());
            String defaultTimeString = timeColumnSpec.getDefaultNullValueString();
            DateTimeFormatSpec dateTimeFormatSpec = timeColumnSpec.getFormatSpec();
            try {
                long defaultTimeMs = dateTimeFormatSpec.fromFormatToMillis(defaultTimeString);
                if (TimeUtils.timeValueInValidRange((long)defaultTimeMs)) {
                    this._defaultNullValues.put(timeColumnName, timeColumnSpec.getDefaultNullValue());
                    return;
                }
            }
            catch (Exception defaultTimeMs) {
                // empty catch block
            }
            String currentTimeString = dateTimeFormatSpec.fromMillisToFormat(System.currentTimeMillis());
            Object currentTime = timeColumnSpec.getDataType().convert(currentTimeString);
            this._defaultNullValues.put(timeColumnName, currentTime);
            LOGGER.info("Default time: {} does not comply with format: {}, using current time: {} as the default time for table: {}", new Object[]{defaultTimeString, timeColumnSpec.getFormat(), currentTime, tableConfig.getTableName()});
        }
    }

    @Override
    public GenericRow transform(GenericRow record) {
        for (Map.Entry<String, Object> entry : this._defaultNullValues.entrySet()) {
            String fieldName = entry.getKey();
            Object value = record.getValue(fieldName);
            if (value != null) continue;
            record.putDefaultNullValue(fieldName, entry.getValue());
        }
        return record;
    }
}

