/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.invertedindex;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.pinot.segment.local.realtime.impl.invertedindex.RealtimeInvertedIndex;
import org.apache.pinot.segment.local.segment.creator.impl.text.LuceneTextIndexCreator;
import org.apache.pinot.segment.local.utils.nativefst.mutablefst.MutableFST;
import org.apache.pinot.segment.local.utils.nativefst.mutablefst.MutableFSTImpl;
import org.apache.pinot.segment.local.utils.nativefst.utils.RealTimeRegexpMatcher;
import org.apache.pinot.segment.spi.index.mutable.MutableTextIndex;
import org.roaringbitmap.buffer.ImmutableRoaringBitmap;
import org.roaringbitmap.buffer.MutableRoaringBitmap;

public class NativeMutableTextIndex
implements MutableTextIndex {
    private final String _column;
    private final MutableFST _mutableFST;
    private final RealtimeInvertedIndex _invertedIndex;
    private final Object2IntOpenHashMap<String> _termToDictIdMapping;
    private final ReentrantReadWriteLock.ReadLock _readLock;
    private final ReentrantReadWriteLock.WriteLock _writeLock;
    private final Analyzer _analyzer;
    private int _nextDocId = 0;
    private int _nextDictId = 0;

    public NativeMutableTextIndex(String column) {
        this._column = column;
        this._mutableFST = new MutableFSTImpl();
        this._termToDictIdMapping = new Object2IntOpenHashMap();
        this._invertedIndex = new RealtimeInvertedIndex();
        ReentrantReadWriteLock readWriteLock = new ReentrantReadWriteLock();
        this._readLock = readWriteLock.readLock();
        this._writeLock = readWriteLock.writeLock();
        this._analyzer = new StandardAnalyzer(LuceneTextIndexCreator.ENGLISH_STOP_WORDS_SET);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String document) {
        List<String> tokens = this.analyze(document);
        this._writeLock.lock();
        try {
            for (String token : tokens) {
                Integer currentDictId = this._termToDictIdMapping.computeIntIfAbsent((Object)token, k -> {
                    int localDictId = this._nextDictId++;
                    this._mutableFST.addPath(token, localDictId);
                    return localDictId;
                });
                this._invertedIndex.add(currentDictId, this._nextDocId);
            }
            ++this._nextDocId;
        }
        finally {
            this._writeLock.unlock();
        }
    }

    public ImmutableRoaringBitmap getDictIds(String searchQuery) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MutableRoaringBitmap getDocIds(String searchQuery) {
        MutableRoaringBitmap matchingDocIds = new MutableRoaringBitmap();
        this._readLock.lock();
        try {
            RealTimeRegexpMatcher.regexMatch(searchQuery, this._mutableFST, dictId -> matchingDocIds.or((ImmutableRoaringBitmap)this._invertedIndex.getDocIds(dictId)));
            MutableRoaringBitmap mutableRoaringBitmap = matchingDocIds;
            return mutableRoaringBitmap;
        }
        finally {
            this._readLock.unlock();
        }
    }

    public void close() throws IOException {
        this._analyzer.close();
    }

    private List<String> analyze(String document) {
        ArrayList<String> tokens = new ArrayList<String>();
        try (TokenStream tokenStream = this._analyzer.tokenStream(this._column, document);){
            tokenStream.reset();
            CharTermAttribute attribute = (CharTermAttribute)tokenStream.getAttribute(CharTermAttribute.class);
            while (tokenStream.incrementToken()) {
                tokens.add(attribute.toString());
            }
            tokenStream.end();
        }
        catch (IOException e) {
            throw new RuntimeException("Caught exception while tokenizing the document for column: " + this._column, e);
        }
        return tokens;
    }
}

