/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.dictionary;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.pinot.segment.local.io.writer.impl.MutableOffHeapByteArrayStore;
import org.apache.pinot.segment.local.realtime.impl.dictionary.BaseOffHeapMutableDictionary;
import org.apache.pinot.segment.spi.memory.PinotDataBufferMemoryManager;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BigDecimalUtils;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.BytesUtils;

public class BytesOffHeapMutableDictionary
extends BaseOffHeapMutableDictionary {
    private final MutableOffHeapByteArrayStore _byteStore;
    private volatile byte[] _min = null;
    private volatile byte[] _max = null;

    public BytesOffHeapMutableDictionary(int estimatedCardinality, int maxOverflowHashSize, PinotDataBufferMemoryManager memoryManager, String allocationContext, int avgLength) {
        super(estimatedCardinality, maxOverflowHashSize, memoryManager, allocationContext);
        this._byteStore = new MutableOffHeapByteArrayStore(memoryManager, allocationContext, estimatedCardinality, avgLength);
    }

    public int index(Object value) {
        byte[] bytesValue = (byte[])value;
        this.updateMinMax(bytesValue);
        return this.indexValue(new ByteArray(bytesValue), bytesValue);
    }

    public int[] index(Object[] values) {
        throw new UnsupportedOperationException();
    }

    public int compare(int dictId1, int dictId2) {
        return ByteArray.compare((byte[])this.getBytesValue(dictId1), (byte[])this.getBytesValue(dictId2));
    }

    public IntSet getDictIdsInRange(String lower, String upper, boolean includeLower, boolean includeUpper) {
        int upperCompareThreshold;
        int numValues = this.length();
        if (numValues == 0) {
            return IntSets.EMPTY_SET;
        }
        IntOpenHashSet dictIds = new IntOpenHashSet();
        int lowerCompareThreshold = includeLower ? 0 : 1;
        int n = upperCompareThreshold = includeUpper ? 0 : -1;
        if (lower.equals("*")) {
            byte[] upperValue = BytesUtils.toBytes((String)upper);
            for (int dictId = 0; dictId < numValues; ++dictId) {
                byte[] value = this.getBytesValue(dictId);
                if (ByteArray.compare((byte[])value, (byte[])upperValue) > upperCompareThreshold) continue;
                dictIds.add(dictId);
            }
        } else if (upper.equals("*")) {
            byte[] lowerValue = BytesUtils.toBytes((String)lower);
            for (int dictId = 0; dictId < numValues; ++dictId) {
                byte[] value = this.getBytesValue(dictId);
                if (ByteArray.compare((byte[])value, (byte[])lowerValue) < lowerCompareThreshold) continue;
                dictIds.add(dictId);
            }
        } else {
            byte[] lowerValue = BytesUtils.toBytes((String)lower);
            byte[] upperValue = BytesUtils.toBytes((String)upper);
            for (int dictId = 0; dictId < numValues; ++dictId) {
                byte[] value = this.getBytesValue(dictId);
                if (ByteArray.compare((byte[])value, (byte[])lowerValue) < lowerCompareThreshold || ByteArray.compare((byte[])value, (byte[])upperValue) > upperCompareThreshold) continue;
                dictIds.add(dictId);
            }
        }
        return dictIds;
    }

    public ByteArray getMinVal() {
        return new ByteArray(this._min);
    }

    public ByteArray getMaxVal() {
        return new ByteArray(this._max);
    }

    public ByteArray[] getSortedValues() {
        int numValues = this.length();
        Object[] sortedValues = new ByteArray[numValues];
        for (int dictId = 0; dictId < numValues; ++dictId) {
            sortedValues[dictId] = new ByteArray(this.getBytesValue(dictId));
        }
        Arrays.sort(sortedValues);
        return sortedValues;
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.BYTES;
    }

    public int indexOf(String stringValue) {
        byte[] bytesValue = BytesUtils.toBytes((String)stringValue);
        return this.getDictId(new ByteArray(bytesValue), bytesValue);
    }

    public int indexOf(ByteArray bytesValue) {
        return this.getDictId(bytesValue, bytesValue.getBytes());
    }

    public byte[] get(int dictId) {
        return this.getBytesValue(dictId);
    }

    public Object getInternal(int dictId) {
        return this.getByteArrayValue(dictId);
    }

    public int getIntValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    public long getLongValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    public float getFloatValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    public double getDoubleValue(int dictId) {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimalValue(int dictId) {
        return BigDecimalUtils.deserialize((byte[])this.getBytesValue(dictId));
    }

    public String getStringValue(int dictId) {
        return BytesUtils.toHexString((byte[])this.getBytesValue(dictId));
    }

    public byte[] getBytesValue(int dictId) {
        return this._byteStore.get(dictId);
    }

    @Override
    protected void setValue(int dictId, Object value, byte[] serializedValue) {
        this._byteStore.add(serializedValue);
    }

    @Override
    protected boolean equalsValueAt(int dictId, Object value, byte[] serializedValue) {
        return this._byteStore.equalsValueAt(serializedValue, dictId);
    }

    @Override
    public int getAvgValueSize() {
        return (int)this._byteStore.getAvgValueSize();
    }

    @Override
    public long getTotalOffHeapMemUsed() {
        return this.getOffHeapMemUsed() + this._byteStore.getTotalOffHeapMemUsed();
    }

    @Override
    public void doClose() throws IOException {
        this._byteStore.close();
    }

    private void updateMinMax(byte[] value) {
        if (this._min == null) {
            this._min = value;
            this._max = value;
        } else {
            if (ByteArray.compare((byte[])value, (byte[])this._min) < 0) {
                this._min = value;
            }
            if (ByteArray.compare((byte[])value, (byte[])this._max) > 0) {
                this._max = value;
            }
        }
    }
}

