/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.realtime.impl.dictionary;

import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.ints.IntSets;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Arrays;
import org.apache.pinot.segment.local.io.writer.impl.MutableOffHeapByteArrayStore;
import org.apache.pinot.segment.local.realtime.impl.dictionary.BaseOffHeapMutableDictionary;
import org.apache.pinot.segment.spi.memory.PinotDataBufferMemoryManager;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.BigDecimalUtils;

public class BigDecimalOffHeapMutableDictionary
extends BaseOffHeapMutableDictionary {
    private final MutableOffHeapByteArrayStore _byteStore;
    private volatile BigDecimal _min = null;
    private volatile BigDecimal _max = null;

    public BigDecimalOffHeapMutableDictionary(int estimatedCardinality, int maxOverflowHashSize, PinotDataBufferMemoryManager memoryManager, String allocationContext, int avgBigDecimalLen) {
        super(estimatedCardinality, maxOverflowHashSize, memoryManager, allocationContext);
        this._byteStore = new MutableOffHeapByteArrayStore(memoryManager, allocationContext, estimatedCardinality, avgBigDecimalLen);
    }

    public int index(Object value) {
        BigDecimal bigDecimalValue = (BigDecimal)value;
        this.updateMinMax(bigDecimalValue);
        return this.indexValue(bigDecimalValue, BigDecimalUtils.serialize((BigDecimal)bigDecimalValue));
    }

    public int[] index(Object[] values) {
        int numValues = values.length;
        int[] dictIds = new int[numValues];
        for (int i = 0; i < numValues; ++i) {
            BigDecimal bigDecimalValue = (BigDecimal)values[i];
            this.updateMinMax(bigDecimalValue);
            dictIds[i] = this.indexValue(bigDecimalValue, BigDecimalUtils.serialize((BigDecimal)bigDecimalValue));
        }
        return dictIds;
    }

    public int compare(int dictId1, int dictId2) {
        return this.getBigDecimalValue(dictId1).compareTo(this.getBigDecimalValue(dictId2));
    }

    public IntSet getDictIdsInRange(String lower, String upper, boolean includeLower, boolean includeUpper) {
        int numValues = this.length();
        if (numValues == 0) {
            return IntSets.EMPTY_SET;
        }
        IntOpenHashSet dictIds = new IntOpenHashSet();
        if (lower.equals("*")) {
            BigDecimal upperValue = new BigDecimal(upper);
            if (includeUpper) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    BigDecimal value = this.getBigDecimalValue(dictId);
                    if (value.compareTo(upperValue) > 0) continue;
                    dictIds.add(dictId);
                }
            } else {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    BigDecimal value = this.getBigDecimalValue(dictId);
                    if (value.compareTo(upperValue) >= 0) continue;
                    dictIds.add(dictId);
                }
            }
        } else if (upper.equals("*")) {
            BigDecimal lowerValue = new BigDecimal(lower);
            if (includeLower) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    BigDecimal value = this.getBigDecimalValue(dictId);
                    if (value.compareTo(lowerValue) < 0) continue;
                    dictIds.add(dictId);
                }
            } else {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    BigDecimal value = this.getBigDecimalValue(dictId);
                    if (value.compareTo(lowerValue) <= 0) continue;
                    dictIds.add(dictId);
                }
            }
        } else {
            BigDecimal lowerValue = new BigDecimal(lower);
            BigDecimal upperValue = new BigDecimal(upper);
            if (includeLower && includeUpper) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    BigDecimal value = this.getBigDecimalValue(dictId);
                    if (value.compareTo(lowerValue) < 0 || value.compareTo(upperValue) > 0) continue;
                    dictIds.add(dictId);
                }
            } else if (includeLower) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    BigDecimal value = this.getBigDecimalValue(dictId);
                    if (value.compareTo(lowerValue) < 0 || value.compareTo(upperValue) >= 0) continue;
                    dictIds.add(dictId);
                }
            } else if (includeUpper) {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    BigDecimal value = this.getBigDecimalValue(dictId);
                    if (value.compareTo(lowerValue) <= 0 || value.compareTo(upperValue) > 0) continue;
                    dictIds.add(dictId);
                }
            } else {
                for (int dictId = 0; dictId < numValues; ++dictId) {
                    BigDecimal value = this.getBigDecimalValue(dictId);
                    if (value.compareTo(lowerValue) <= 0 || value.compareTo(upperValue) >= 0) continue;
                    dictIds.add(dictId);
                }
            }
        }
        return dictIds;
    }

    public BigDecimal getMinVal() {
        return this._min;
    }

    public BigDecimal getMaxVal() {
        return this._max;
    }

    public BigDecimal[] getSortedValues() {
        int numValues = this.length();
        Object[] sortedValues = new BigDecimal[numValues];
        for (int dictId = 0; dictId < numValues; ++dictId) {
            sortedValues[dictId] = this.getBigDecimalValue(dictId);
        }
        Arrays.sort(sortedValues);
        return sortedValues;
    }

    public FieldSpec.DataType getValueType() {
        return FieldSpec.DataType.BIG_DECIMAL;
    }

    public int indexOf(String stringValue) {
        BigDecimal bigDecimalValue = new BigDecimal(stringValue);
        return this.getDictId(bigDecimalValue, BigDecimalUtils.serialize((BigDecimal)bigDecimalValue));
    }

    public int indexOf(BigDecimal bigDecimalValue) {
        return this.getDictId(bigDecimalValue, BigDecimalUtils.serialize((BigDecimal)bigDecimalValue));
    }

    public BigDecimal get(int dictId) {
        return this.getBigDecimalValue(dictId);
    }

    public int getIntValue(int dictId) {
        return this.getBigDecimalValue(dictId).intValue();
    }

    public long getLongValue(int dictId) {
        return this.getBigDecimalValue(dictId).longValue();
    }

    public float getFloatValue(int dictId) {
        return this.getBigDecimalValue(dictId).floatValue();
    }

    public double getDoubleValue(int dictId) {
        return this.getBigDecimalValue(dictId).doubleValue();
    }

    public BigDecimal getBigDecimalValue(int dictId) {
        return BigDecimalUtils.deserialize((byte[])this._byteStore.get(dictId));
    }

    public String getStringValue(int dictId) {
        return this.getBigDecimalValue(dictId).toPlainString();
    }

    @Override
    protected void setValue(int dictId, Object value, byte[] serializedValue) {
        this._byteStore.add(serializedValue);
    }

    @Override
    protected boolean equalsValueAt(int dictId, Object value, byte[] serializedValue) {
        return this._byteStore.equalsValueAt(serializedValue, dictId);
    }

    @Override
    public int getAvgValueSize() {
        return (int)this._byteStore.getAvgValueSize();
    }

    @Override
    public long getTotalOffHeapMemUsed() {
        return this.getOffHeapMemUsed() + this._byteStore.getTotalOffHeapMemUsed();
    }

    @Override
    public void doClose() throws IOException {
        this._byteStore.close();
    }

    private void updateMinMax(BigDecimal value) {
        if (this._min == null) {
            this._min = value;
            this._max = value;
        } else {
            if (value.compareTo(this._min) < 0) {
                this._min = value;
            }
            if (value.compareTo(this._max) > 0) {
                this._max = value;
            }
        }
    }
}

