/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.io.compression;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.jpountz.lz4.LZ4Factory;
import org.apache.pinot.segment.spi.compression.ChunkCompressionType;
import org.apache.pinot.segment.spi.compression.ChunkCompressor;

class LZ4Compressor
implements ChunkCompressor {
    static final LZ4Factory LZ4_FACTORY = LZ4Factory.fastestInstance();
    static final LZ4Compressor INSTANCE = new LZ4Compressor();

    private LZ4Compressor() {
    }

    public int compress(ByteBuffer inUncompressed, ByteBuffer outCompressed) throws IOException {
        LZ4_FACTORY.fastCompressor().compress(inUncompressed, outCompressed);
        outCompressed.flip();
        return outCompressed.limit();
    }

    public int maxCompressedSize(int uncompressedSize) {
        return LZ4_FACTORY.fastCompressor().maxCompressedLength(uncompressedSize);
    }

    public ChunkCompressionType compressionType() {
        return ChunkCompressionType.LZ4;
    }
}

