/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.customobject;

import java.nio.ByteBuffer;

public class VarianceTuple
implements Comparable<VarianceTuple> {
    private long _count;
    private double _sum;
    private double _m2;

    public VarianceTuple(long count, double sum, double m2) {
        this._count = count;
        this._sum = sum;
        this._m2 = m2;
    }

    public void apply(long count, double sum, double m2) {
        if (count == 0L) {
            return;
        }
        double currAvg = this._count == 0L ? 0.0 : this._sum / (double)this._count;
        double delta = sum / (double)count - currAvg;
        this._m2 += m2 + delta * delta * (double)count * (double)this._count / (double)(count + this._count);
        this._count += count;
        this._sum += sum;
    }

    public void apply(VarianceTuple varianceTuple) {
        if (varianceTuple._count == 0L) {
            return;
        }
        double currAvg = this._count == 0L ? 0.0 : this._sum / (double)this._count;
        double delta = varianceTuple._sum / (double)varianceTuple._count - currAvg;
        this._m2 += varianceTuple._m2 + delta * delta * (double)varianceTuple._count * (double)this._count / (double)(varianceTuple._count + this._count);
        this._count += varianceTuple._count;
        this._sum += varianceTuple._sum;
    }

    public long getCount() {
        return this._count;
    }

    public double getSum() {
        return this._sum;
    }

    public double getM2() {
        return this._m2;
    }

    public byte[] toBytes() {
        ByteBuffer byteBuffer = ByteBuffer.allocate(24);
        byteBuffer.putLong(this._count);
        byteBuffer.putDouble(this._sum);
        byteBuffer.putDouble(this._m2);
        return byteBuffer.array();
    }

    public static VarianceTuple fromBytes(byte[] bytes) {
        return VarianceTuple.fromByteBuffer(ByteBuffer.wrap(bytes));
    }

    public static VarianceTuple fromByteBuffer(ByteBuffer byteBuffer) {
        return new VarianceTuple(byteBuffer.getLong(), byteBuffer.getDouble(), byteBuffer.getDouble());
    }

    @Override
    public int compareTo(VarianceTuple varianceTuple) {
        if (this._count == 0L) {
            if (varianceTuple._count == 0L) {
                return 0;
            }
            return -1;
        }
        if (varianceTuple._count == 0L) {
            return 1;
        }
        if (this._m2 > varianceTuple._m2) {
            return 1;
        }
        if (this._m2 < varianceTuple._m2) {
            return -1;
        }
        return 0;
    }
}

