/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.local.aggregator;

import com.tdunning.math.stats.TDigest;
import org.apache.pinot.segment.local.aggregator.ValueAggregator;
import org.apache.pinot.segment.local.utils.CustomSerDeUtils;
import org.apache.pinot.segment.spi.AggregationFunctionType;
import org.apache.pinot.spi.data.FieldSpec;

public class PercentileTDigestValueAggregator
implements ValueAggregator<Object, TDigest> {
    public static final FieldSpec.DataType AGGREGATED_VALUE_TYPE = FieldSpec.DataType.BYTES;
    public static final int DEFAULT_TDIGEST_COMPRESSION = 100;
    private int _maxByteSize;

    @Override
    public AggregationFunctionType getAggregationType() {
        return AggregationFunctionType.PERCENTILETDIGEST;
    }

    @Override
    public FieldSpec.DataType getAggregatedValueType() {
        return AGGREGATED_VALUE_TYPE;
    }

    @Override
    public TDigest getInitialAggregatedValue(Object rawValue) {
        TDigest initialValue;
        if (rawValue instanceof byte[]) {
            byte[] bytes = (byte[])rawValue;
            initialValue = this.deserializeAggregatedValue(bytes);
            this._maxByteSize = Math.max(this._maxByteSize, bytes.length);
        } else {
            initialValue = TDigest.createMergingDigest((double)100.0);
            initialValue.add(((Number)rawValue).doubleValue());
            this._maxByteSize = Math.max(this._maxByteSize, initialValue.byteSize());
        }
        return initialValue;
    }

    @Override
    public TDigest applyRawValue(TDigest value, Object rawValue) {
        if (rawValue instanceof byte[]) {
            value.add(this.deserializeAggregatedValue((byte[])rawValue));
        } else {
            value.add(((Number)rawValue).doubleValue());
        }
        this._maxByteSize = Math.max(this._maxByteSize, value.byteSize());
        return value;
    }

    @Override
    public TDigest applyAggregatedValue(TDigest value, TDigest aggregatedValue) {
        value.add(aggregatedValue);
        this._maxByteSize = Math.max(this._maxByteSize, value.byteSize());
        return value;
    }

    @Override
    public TDigest cloneAggregatedValue(TDigest value) {
        return this.deserializeAggregatedValue(this.serializeAggregatedValue(value));
    }

    @Override
    public int getMaxAggregatedValueByteSize() {
        return this._maxByteSize;
    }

    @Override
    public byte[] serializeAggregatedValue(TDigest value) {
        return CustomSerDeUtils.TDIGEST_SER_DE.serialize(value);
    }

    @Override
    public TDigest deserializeAggregatedValue(byte[] bytes) {
        return CustomSerDeUtils.TDIGEST_SER_DE.deserialize(bytes);
    }
}

