/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import java.lang.reflect.Array;
import org.apache.datasketches.ResizeFactor;
import org.apache.datasketches.SketchesStateException;
import org.apache.datasketches.tuple.CompactSketch;
import org.apache.datasketches.tuple.QuickSelectSketch;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.SketchIterator;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummarySetOperations;

public class Intersection<S extends Summary> {
    private final SummarySetOperations<S> summarySetOps_;
    private QuickSelectSketch<S> sketch_;
    private boolean isEmpty_;
    private long theta_;
    private boolean isFirstCall_;

    public Intersection(SummarySetOperations<S> summarySetOps) {
        this.summarySetOps_ = summarySetOps;
        this.isEmpty_ = false;
        this.theta_ = Long.MAX_VALUE;
        this.isFirstCall_ = true;
    }

    public void update(Sketch<S> sketchIn) {
        boolean isFirstCall = this.isFirstCall_;
        this.isFirstCall_ = false;
        if (sketchIn == null) {
            this.isEmpty_ = true;
            this.sketch_ = null;
            return;
        }
        this.theta_ = Math.min(this.theta_, sketchIn.getThetaLong());
        this.isEmpty_ |= sketchIn.isEmpty();
        if (this.isEmpty_ || sketchIn.getRetainedEntries() == 0) {
            this.sketch_ = null;
            return;
        }
        if (isFirstCall) {
            this.sketch_ = new QuickSelectSketch(sketchIn.getRetainedEntries(), ResizeFactor.X1.lg(), null);
            SketchIterator<S> it = sketchIn.iterator();
            while (it.next()) {
                Summary summary = it.getSummary().copy();
                this.sketch_.insert(it.getKey(), summary);
            }
        } else {
            if (this.sketch_ == null) {
                return;
            }
            int matchSize = Math.min(this.sketch_.getRetainedEntries(), sketchIn.getRetainedEntries());
            long[] matchKeys = new long[matchSize];
            Summary[] matchSummaries = null;
            int matchCount = 0;
            SketchIterator<S> it = sketchIn.iterator();
            while (it.next()) {
                S summary = this.sketch_.find(it.getKey());
                if (summary == null) continue;
                matchKeys[matchCount] = it.getKey();
                if (matchSummaries == null) {
                    matchSummaries = (Summary[])Array.newInstance(summary.getClass(), matchSize);
                }
                matchSummaries[matchCount] = this.summarySetOps_.intersection(summary, it.getSummary());
                ++matchCount;
            }
            this.sketch_ = null;
            if (matchCount > 0) {
                this.sketch_ = new QuickSelectSketch(matchCount, ResizeFactor.X1.lg(), null);
                for (int i = 0; i < matchCount; ++i) {
                    this.sketch_.insert(matchKeys[i], matchSummaries[i]);
                }
            }
        }
        if (this.sketch_ != null) {
            this.sketch_.setThetaLong(this.theta_);
            this.sketch_.setNotEmpty();
        }
    }

    public CompactSketch<S> getResult() {
        if (this.isFirstCall_) {
            throw new SketchesStateException("getResult() with no intervening intersections is not a legal result.");
        }
        if (this.sketch_ == null) {
            return new CompactSketch(null, null, this.theta_, this.isEmpty_);
        }
        return this.sketch_.compact();
    }

    public void reset() {
        this.isEmpty_ = false;
        this.theta_ = Long.MAX_VALUE;
        this.sketch_ = null;
        this.isFirstCall_ = true;
    }
}

