/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import org.apache.datasketches.Util;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.WritableMemory;
import org.apache.datasketches.theta.DirectCompactSketch;

final class DirectCompactOrderedSketch
extends DirectCompactSketch {
    DirectCompactOrderedSketch(Memory mem) {
        super(mem);
    }

    static DirectCompactOrderedSketch wrapInstance(Memory srcMem, long seed) {
        short memSeedHash = srcMem.getShort(6L);
        short computedSeedHash = Util.computeSeedHash(seed);
        Util.checkSeedHashes(memSeedHash, computedSeedHash);
        return new DirectCompactOrderedSketch(srcMem);
    }

    static DirectCompactOrderedSketch compact(long[] cache, boolean empty, short seedHash, int curCount, long thetaLong, WritableMemory dstMem) {
        int preLongs = DirectCompactOrderedSketch.computeCompactPreLongs(thetaLong, empty, curCount);
        int requiredFlags = 26;
        byte flags = (byte)(0x1A | (empty ? 4 : 0));
        DirectCompactOrderedSketch.loadCompactMemory(cache, seedHash, curCount, thetaLong, dstMem, flags, preLongs);
        return new DirectCompactOrderedSketch((Memory)dstMem);
    }

    @Override
    public boolean isOrdered() {
        return true;
    }
}

