/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot.query;

import com.google.common.collect.ImmutableMap;
import io.trino.plugin.pinot.PinotColumnHandle;
import io.trino.plugin.pinot.PinotErrorCode;
import io.trino.plugin.pinot.PinotException;
import io.trino.plugin.pinot.PinotTypeConverter;
import io.trino.plugin.pinot.client.PinotClient;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnNotFoundException;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.Type;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.operator.transform.TransformResultMetadata;
import org.apache.pinot.core.operator.transform.function.LiteralTransformFunction;
import org.apache.pinot.core.operator.transform.function.TransformFunctionFactory;
import org.apache.pinot.segment.local.segment.index.datasource.EmptyDataSource;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.metadata.ColumnMetadataImpl;
import org.apache.pinot.spi.data.FieldSpec;

public class PinotTypeResolver {
    private final PinotTypeConverter typeConverter;
    private final Map<String, DataSource> datasourceMap;

    public PinotTypeResolver(PinotClient pinotClient, PinotTypeConverter typeConverter, String pinotTableName) {
        Objects.requireNonNull(pinotClient, "pinotClient is null");
        this.typeConverter = Objects.requireNonNull(typeConverter, "typeConverter is null");
        this.datasourceMap = PinotTypeResolver.getDataSourceMap(pinotClient, pinotTableName);
    }

    private static Map<String, DataSource> getDataSourceMap(PinotClient pinotClient, String pinotTableName) {
        try {
            return (Map)pinotClient.getTableSchema(pinotTableName).getFieldSpecMap().entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> new EmptyDataSource((ColumnMetadata)new ColumnMetadataImpl.Builder().setFieldSpec((FieldSpec)entry.getValue()).build())));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Type resolveExpressionType(ExpressionContext expression, SchemaTableName schemaTableName, Map<String, ColumnHandle> columnHandles) {
        switch (expression.getType()) {
            case IDENTIFIER: {
                PinotColumnHandle columnHandle = (PinotColumnHandle)columnHandles.get(expression.getIdentifier().toLowerCase(Locale.ENGLISH));
                if (columnHandle == null) {
                    throw new ColumnNotFoundException(schemaTableName, expression.getIdentifier());
                }
                return columnHandle.getDataType();
            }
            case FUNCTION: {
                return this.typeConverter.toTrinoType(TransformFunctionFactory.get((ExpressionContext)expression, this.datasourceMap).getResultMetadata());
            }
            case LITERAL: {
                FieldSpec.DataType literalDataType = new LiteralTransformFunction(expression.getLiteral()).getResultMetadata().getDataType();
                return this.typeConverter.toTrinoType(new TransformResultMetadata(literalDataType, true, false));
            }
        }
        throw new PinotException(PinotErrorCode.PINOT_INVALID_PQL_GENERATED, Optional.empty(), String.format("Unsupported expression: '%s'", expression));
    }
}

