/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.pinot;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.airlift.bootstrap.LifeCycleManager;
import io.trino.plugin.pinot.PinotMetadata;
import io.trino.plugin.pinot.PinotNodePartitioningProvider;
import io.trino.plugin.pinot.PinotPageSourceProvider;
import io.trino.plugin.pinot.PinotSessionProperties;
import io.trino.plugin.pinot.PinotSplitManager;
import io.trino.plugin.pinot.PinotTransactionHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.transaction.IsolationLevel;
import java.util.List;
import java.util.Objects;

public class PinotConnector
implements Connector {
    private final LifeCycleManager lifeCycleManager;
    private final PinotMetadata metadata;
    private final PinotSplitManager splitManager;
    private final PinotPageSourceProvider pageSourceProvider;
    private final PinotNodePartitioningProvider partitioningProvider;
    private final PinotSessionProperties sessionProperties;

    @Inject
    public PinotConnector(LifeCycleManager lifeCycleManager, PinotMetadata metadata, PinotSplitManager splitManager, PinotPageSourceProvider pageSourceProvider, PinotNodePartitioningProvider partitioningProvider, PinotSessionProperties pinotSessionProperties) {
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.partitioningProvider = Objects.requireNonNull(partitioningProvider, "partitioningProvider is null");
        this.sessionProperties = Objects.requireNonNull(pinotSessionProperties, "pinotSessionProperties is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        return PinotTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transactionHandle) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
        return this.partitioningProvider;
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return ImmutableList.copyOf(this.sessionProperties.getSessionProperties());
    }

    public final void shutdown() {
        this.lifeCycleManager.stop();
    }
}

