/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.pinot.spi.utils.JsonUtils;

public final class Obfuscator {
    private static final String DEFAULT_MASKED_VALUE = "*****";
    private static final List<Pattern> DEFAULT_PATTERNS = Stream.of("(?i).*secret$", "(?i).*secret[\\s_-]*key$", "(?i).*password$", "(?i).*keytab$", "(?i).*token$").map(Pattern::compile).collect(Collectors.toList());
    private final String _maskedValue;
    private final List<Pattern> _patterns;

    public Obfuscator() {
        this._maskedValue = DEFAULT_MASKED_VALUE;
        this._patterns = DEFAULT_PATTERNS;
    }

    public Obfuscator(String maskedValue, List<Pattern> patterns) {
        this._maskedValue = maskedValue;
        this._patterns = patterns;
    }

    public JsonNode toJson(Object object) {
        try {
            JsonNode node = object instanceof JsonNode ? (JsonNode)object : (object instanceof String ? JsonUtils.stringToJsonNode(String.valueOf(object)) : JsonUtils.objectToJsonNode(object));
            return this.toJsonRecursive(node);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String toJsonString(Object object) {
        return String.valueOf(this.toJson(object));
    }

    private JsonNode toJsonRecursive(JsonNode node) {
        if (node.isObject()) {
            node.fieldNames().forEachRemaining(field -> {
                if (this._patterns.stream().anyMatch(pattern -> pattern.matcher((CharSequence)field).matches())) {
                    ((ObjectNode)node).put(field, this._maskedValue);
                } else if (node.isArray()) {
                    IntStream.range(0, node.size()).forEach(i -> ((ArrayNode)node).set(i, this.toJsonRecursive(node.get(i))));
                } else if (node.isObject()) {
                    ((ObjectNode)node).put(field, this.toJsonRecursive(node.get(field)));
                }
            });
        }
        return node;
    }
}

