/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.net.UnknownHostException;

public class NetUtils {
    private static final String DUMMY_OUT_IP = "74.125.224.0";

    private NetUtils() {
    }

    public static String getHostAddress() throws SocketException, UnknownHostException {
        DatagramSocket ds = new DatagramSocket();
        ds.connect(InetAddress.getByName(DUMMY_OUT_IP), 80);
        InetAddress localAddress = ds.getLocalAddress();
        if (localAddress.getHostAddress().equals("0.0.0.0")) {
            localAddress = InetAddress.getLocalHost();
        }
        return localAddress.getHostAddress();
    }

    public static String getHostnameOrAddress() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException ignored) {
            try {
                return NetUtils.getHostAddress();
            }
            catch (Exception e) {
                return null;
            }
        }
    }

    public static int findOpenPort() throws IOException {
        try (ServerSocket socket = new ServerSocket(0);){
            int n = socket.getLocalPort();
            return n;
        }
    }

    public static int findOpenPort(int basePort) {
        while (!NetUtils.available(basePort)) {
            ++basePort;
        }
        return basePort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean available(int port) {
        ServerSocket ss = null;
        DatagramSocket ds = null;
        try {
            ss = new ServerSocket(port);
            ss.setReuseAddress(true);
            ds = new DatagramSocket(port);
            ds.setReuseAddress(true);
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (ds != null) {
                ds.close();
            }
            if (ss != null) {
                try {
                    ss.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

