/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.stream;

import java.util.Map;
import java.util.Set;
import org.apache.pinot.spi.plugin.PluginManager;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.stream.StreamMessageDecoder;

public class StreamDecoderProvider {
    private StreamDecoderProvider() {
    }

    public static StreamMessageDecoder create(StreamConfig streamConfig, Set<String> fieldsToRead) {
        String decoderClass = streamConfig.getDecoderClass();
        Map<String, String> decoderProperties = streamConfig.getDecoderProperties();
        try {
            StreamMessageDecoder decoder = (StreamMessageDecoder)PluginManager.get().createInstance(decoderClass);
            decoder.init(decoderProperties, fieldsToRead, streamConfig.getTopicName());
            return decoder;
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while creating StreamMessageDecoder from stream config: " + streamConfig, e);
        }
    }
}

