/*
 * Decompiled with CFR 0.152.
 */
package org.apache.helix.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.helix.HelixDefinedState;
import org.apache.helix.HelixProperty;
import org.apache.helix.model.Transition;
import org.apache.helix.model.builder.StateTransitionTableBuilder;
import org.apache.helix.model.util.StateModelDefinitionValidator;
import org.apache.helix.zookeeper.datamodel.ZNRecord;

public class StateModelDefinition
extends HelixProperty {
    public static final int TOP_STATE_PRIORITY = 1;
    private final String _initialState;
    private final List<String> _statesPriorityList;
    private final Map<String, String> _statesCountMap;
    private final List<String> _stateTransitionPriorityList;
    private Map<String, Integer> _statesPriorityMap = new HashMap<String, Integer>();
    private final Map<String, Map<String, String>> _stateTransitionTable;

    public StateModelDefinition(ZNRecord record) {
        super(record);
        this._initialState = record.getSimpleField(StateModelDefinitionProperty.INITIAL_STATE.toString());
        if (this._initialState == null) {
            throw new IllegalArgumentException("initial-state for " + record.getId() + " is null");
        }
        this._statesPriorityList = record.getListField(StateModelDefinitionProperty.STATE_PRIORITY_LIST.toString());
        this._stateTransitionPriorityList = record.getListField(StateModelDefinitionProperty.STATE_TRANSITION_PRIORITYLIST.toString());
        this._stateTransitionTable = new HashMap<String, Map<String, String>>();
        this._statesCountMap = new HashMap<String, String>();
        if (this._statesPriorityList != null) {
            int priority = 1;
            for (String state : this._statesPriorityList) {
                Map<String, String> metaData = record.getMapField(state + ".meta");
                if (metaData != null && metaData.get("count") != null) {
                    this._statesCountMap.put(state, metaData.get("count"));
                }
                Map<String, String> nextData = record.getMapField(state + ".next");
                this._stateTransitionTable.put(state, nextData);
                this._statesPriorityMap.put(state, priority++);
            }
        }
        for (HelixDefinedState state : HelixDefinedState.values()) {
            if (this._statesPriorityMap.containsKey(state.name())) continue;
            this._statesPriorityMap.put(state.name(), Integer.MAX_VALUE);
        }
        for (HelixDefinedState state : HelixDefinedState.values()) {
            if (this._statesPriorityList != null && this._statesPriorityList.contains(state.toString())) continue;
            this._statesCountMap.put(state.toString(), "-1");
        }
        this.addDefaultTransition(HelixDefinedState.ERROR.toString(), HelixDefinedState.DROPPED.toString(), HelixDefinedState.DROPPED.toString());
        this.addDefaultTransition(HelixDefinedState.ERROR.toString(), this._initialState, this._initialState);
        this.addDefaultTransition(this._initialState, HelixDefinedState.DROPPED.toString(), HelixDefinedState.DROPPED.toString());
    }

    void addDefaultTransition(String from, String to, String next) {
        if (!this._stateTransitionTable.containsKey(from)) {
            this._stateTransitionTable.put(from, new TreeMap());
        }
        if (!this._stateTransitionTable.get(from).containsKey(to)) {
            this._stateTransitionTable.get(from).put(to, next);
        }
    }

    public List<String> getStateTransitionPriorityList() {
        return this._stateTransitionPriorityList;
    }

    public Map<String, Integer> getStatePriorityMap() {
        return this._statesPriorityMap;
    }

    public List<String> getStatesPriorityList() {
        return this._statesPriorityList;
    }

    public String getNextStateForTransition(String fromState, String toState) {
        Map<String, String> map = this._stateTransitionTable.get(fromState);
        if (map != null) {
            return map.get(toState);
        }
        return null;
    }

    public String getInitialState() {
        return this._initialState;
    }

    public String getNumInstancesPerState(String state) {
        return this._statesCountMap.get(state);
    }

    public String getTopState() {
        return this._statesPriorityList.get(0);
    }

    public boolean isSingleTopStateModel() {
        int topStateCount = 0;
        try {
            topStateCount = Integer.valueOf(this._statesCountMap.get(this.getTopState()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return topStateCount == 1;
    }

    public Set<String> getSecondTopStates() {
        HashSet<String> secondTopStates = new HashSet<String>();
        if (this._statesPriorityList == null || this._statesPriorityList.isEmpty()) {
            return secondTopStates;
        }
        String topState = this._statesPriorityList.get(0);
        for (String state : this._stateTransitionTable.keySet()) {
            Map<String, String> transitionMap = this._stateTransitionTable.get(state);
            if (transitionMap == null || !transitionMap.containsKey(topState) || !transitionMap.get(topState).equals(topState)) continue;
            secondTopStates.add(state);
        }
        return secondTopStates;
    }

    @Override
    public boolean isValid() {
        return StateModelDefinitionValidator.isStateModelDefinitionValid(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof StateModelDefinition)) {
            return false;
        }
        StateModelDefinition stateModelDefinition = (StateModelDefinition)o;
        return this._initialState.equals(stateModelDefinition._initialState) && this._statesCountMap.equals(stateModelDefinition._statesCountMap) && this._statesPriorityList.equals(stateModelDefinition._statesPriorityList) && this._stateTransitionPriorityList.equals(stateModelDefinition._stateTransitionPriorityList) && this._stateTransitionTable.equals(stateModelDefinition._stateTransitionTable);
    }

    public LinkedHashMap<String, Integer> getStateCountMap(int candidateNodeNum, int totalReplicas) {
        String num;
        LinkedHashMap<String, Integer> stateCountMap = new LinkedHashMap<String, Integer>();
        List<String> statesPriorityList = this.getStatesPriorityList();
        int replicas = totalReplicas;
        for (String state : statesPriorityList) {
            num = this.getNumInstancesPerState(state);
            if (candidateNodeNum <= 0) break;
            if ("N".equals(num)) {
                stateCountMap.put(state, candidateNodeNum);
                replicas -= candidateNodeNum;
                break;
            }
            if ("R".equals(num)) continue;
            int stateCount = -1;
            try {
                stateCount = Integer.parseInt(num);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (stateCount <= 0) continue;
            int count = stateCount <= candidateNodeNum ? stateCount : candidateNodeNum;
            candidateNodeNum -= count;
            stateCountMap.put(state, count);
            replicas -= count;
        }
        for (String state : statesPriorityList) {
            num = this.getNumInstancesPerState(state);
            if (!"R".equals(num)) continue;
            if (candidateNodeNum <= 0 || replicas <= 0) break;
            stateCountMap.put(state, replicas < candidateNodeNum ? replicas : candidateNodeNum);
            break;
        }
        return stateCountMap;
    }

    public static Map<String, Integer> getStateCounts(Map<String, String> stateMap) {
        HashMap<String, Integer> stateCounts = new HashMap<String, Integer>();
        for (String state : stateMap.values()) {
            if (!stateCounts.containsKey(state)) {
                stateCounts.put(state, 0);
            }
            stateCounts.put(state, (Integer)stateCounts.get(state) + 1);
        }
        return stateCounts;
    }

    public static class Builder {
        private final String _statemodelName;
        private String initialState;
        Map<String, Integer> statesMap;
        Map<Transition, Integer> transitionMap;
        Map<String, String> stateConstraintMap;

        public Builder(String name) {
            this._statemodelName = name;
            this.statesMap = new HashMap<String, Integer>();
            this.transitionMap = new HashMap<Transition, Integer>();
            this.stateConstraintMap = new HashMap<String, String>();
        }

        public Builder initialState(String initialState) {
            this.initialState = initialState;
            return this;
        }

        public Builder addState(String state, int priority) {
            this.statesMap.put(state, priority);
            return this;
        }

        public Builder addState(String state) {
            this.addState(state, Integer.MAX_VALUE);
            return this;
        }

        public Builder addTransition(String fromState, String toState, int priority) {
            this.transitionMap.put(new Transition(fromState, toState), priority);
            return this;
        }

        public Builder addTransition(String fromState, String toState) {
            this.addTransition(fromState, toState, Integer.MAX_VALUE);
            return this;
        }

        public Builder upperBound(String state, int upperBound) {
            this.stateConstraintMap.put(state, String.valueOf(upperBound));
            return this;
        }

        public Builder dynamicUpperBound(String state, String bound) {
            this.stateConstraintMap.put(state, bound);
            return this;
        }

        public StateModelDefinition build() {
            ZNRecord record = new ZNRecord(this._statemodelName);
            ArrayList<String> statePriorityList = new ArrayList<String>(this.statesMap.keySet());
            Collections.sort(statePriorityList, Comparator.comparing(o -> this.statesMap.get(o)));
            ArrayList<Transition> transitionList = new ArrayList<Transition>(this.transitionMap.keySet());
            Collections.sort(transitionList, Comparator.comparing(o -> this.transitionMap.get(o)));
            List<String> transitionPriorityList = transitionList.stream().map(Transition::toString).collect(Collectors.toList());
            record.setSimpleField(StateModelDefinitionProperty.INITIAL_STATE.toString(), this.initialState);
            record.setListField(StateModelDefinitionProperty.STATE_PRIORITY_LIST.toString(), statePriorityList);
            record.setListField(StateModelDefinitionProperty.STATE_TRANSITION_PRIORITYLIST.toString(), transitionPriorityList);
            StateTransitionTableBuilder stateTransitionTableBuilder = new StateTransitionTableBuilder();
            Map<String, Map<String, String>> transitionTable = stateTransitionTableBuilder.buildTransitionTable(statePriorityList, new ArrayList<Transition>(this.transitionMap.keySet()));
            for (String state : transitionTable.keySet()) {
                record.setMapField(state + ".next", transitionTable.get(state));
            }
            for (String state : statePriorityList) {
                HashMap<String, String> metadata = new HashMap<String, String>();
                if (this.stateConstraintMap.get(state) != null) {
                    metadata.put("count", this.stateConstraintMap.get(state));
                } else {
                    metadata.put("count", "-1");
                }
                record.setMapField(state + ".meta", metadata);
            }
            return new StateModelDefinition(record);
        }
    }

    public static enum StateModelDefinitionProperty {
        INITIAL_STATE,
        STATE_TRANSITION_PRIORITYLIST,
        STATE_PRIORITY_LIST;

    }
}

