/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.sql.parsers.rewriter;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.apache.pinot.sql.parsers.CalciteSqlParser;
import org.apache.pinot.sql.parsers.rewriter.AliasApplier;
import org.apache.pinot.sql.parsers.rewriter.CompileTimeFunctionsInvoker;
import org.apache.pinot.sql.parsers.rewriter.NonAggregationGroupByToDistinctQueryRewriter;
import org.apache.pinot.sql.parsers.rewriter.OrdinalsUpdater;
import org.apache.pinot.sql.parsers.rewriter.PredicateComparisonRewriter;
import org.apache.pinot.sql.parsers.rewriter.QueryRewriter;
import org.apache.pinot.sql.parsers.rewriter.SelectionsRewriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRewriterFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryRewriterFactory.class);
    static final List<String> DEFAULT_QUERY_REWRITERS_CLASS_NAMES = ImmutableList.of((Object)CompileTimeFunctionsInvoker.class.getName(), (Object)SelectionsRewriter.class.getName(), (Object)PredicateComparisonRewriter.class.getName(), (Object)OrdinalsUpdater.class.getName(), (Object)AliasApplier.class.getName(), (Object)NonAggregationGroupByToDistinctQueryRewriter.class.getName());

    private QueryRewriterFactory() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String queryRewritersClassNamesStr) {
        List<String> queryRewritersClassNames = queryRewritersClassNamesStr != null ? Arrays.asList(queryRewritersClassNamesStr.split(",")) : DEFAULT_QUERY_REWRITERS_CLASS_NAMES;
        List<QueryRewriter> queryRewriters = QueryRewriterFactory.getQueryRewriters(queryRewritersClassNames);
        Class<CalciteSqlParser> clazz = CalciteSqlParser.class;
        synchronized (CalciteSqlParser.class) {
            CalciteSqlParser.QUERY_REWRITERS.clear();
            CalciteSqlParser.QUERY_REWRITERS.addAll(queryRewriters);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static List<QueryRewriter> getQueryRewriters() {
        return QueryRewriterFactory.getQueryRewriters(DEFAULT_QUERY_REWRITERS_CLASS_NAMES);
    }

    public static List<QueryRewriter> getQueryRewriters(List<String> queryRewriterClasses) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String queryRewriterClassName : queryRewriterClasses) {
            try {
                builder.add((Object)QueryRewriterFactory.getQueryRewriter(queryRewriterClassName));
            }
            catch (Exception e) {
                LOGGER.error("Failed to load QueryRewriter: {}", (Object)queryRewriterClassName, (Object)e);
            }
        }
        return builder.build();
    }

    private static QueryRewriter getQueryRewriter(String queryRewriterClassName) throws Exception {
        Class<?> queryRewriterClass = Class.forName(queryRewriterClassName);
        return (QueryRewriter)queryRewriterClass.getDeclaredConstructors()[0].newInstance(new Object[0]);
    }
}

