/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.grpc;

import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.pinot.common.proto.Server;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.thrift.TBase;
import org.apache.thrift.TException;
import org.apache.thrift.TSerializer;
import org.apache.thrift.protocol.TCompactProtocol;
import org.apache.thrift.protocol.TProtocolFactory;

public class GrpcRequestBuilder {
    private long _requestId;
    private String _brokerId = "unknown";
    private boolean _enableTrace;
    private boolean _enableStreaming;
    private String _payloadType;
    private String _sql;
    private BrokerRequest _brokerRequest;
    private List<String> _segments;

    public GrpcRequestBuilder setRequestId(long requestId) {
        this._requestId = requestId;
        return this;
    }

    public GrpcRequestBuilder setBrokerId(String brokerId) {
        this._brokerId = brokerId;
        return this;
    }

    public GrpcRequestBuilder setEnableTrace(boolean enableTrace) {
        this._enableTrace = enableTrace;
        return this;
    }

    public GrpcRequestBuilder setEnableStreaming(boolean enableStreaming) {
        this._enableStreaming = enableStreaming;
        return this;
    }

    public GrpcRequestBuilder setSql(String sql) {
        this._payloadType = "sql";
        this._sql = sql;
        return this;
    }

    public GrpcRequestBuilder setBrokerRequest(BrokerRequest brokerRequest) {
        this._payloadType = "brokerRequest";
        this._brokerRequest = brokerRequest;
        return this;
    }

    public GrpcRequestBuilder setSegments(List<String> segments) {
        this._segments = segments;
        return this;
    }

    public Server.ServerRequest build() {
        byte[] payLoad;
        Preconditions.checkState((this._payloadType != null && CollectionUtils.isNotEmpty(this._segments) ? 1 : 0) != 0, (Object)"Query and segmentsToQuery must be set");
        HashMap<String, String> metadata = new HashMap<String, String>();
        metadata.put("requestId", Long.toString(this._requestId));
        metadata.put("brokerId", this._brokerId);
        metadata.put("enableTrace", Boolean.toString(this._enableTrace));
        metadata.put("enableStreaming", Boolean.toString(this._enableStreaming));
        metadata.put("payloadType", this._payloadType);
        if (this._payloadType.equals("sql")) {
            return Server.ServerRequest.newBuilder().putAllMetadata(metadata).setSql(this._sql).addAllSegments(this._segments).build();
        }
        try {
            payLoad = new TSerializer((TProtocolFactory)new TCompactProtocol.Factory()).serialize((TBase)this._brokerRequest);
        }
        catch (TException e) {
            throw new RuntimeException("Caught exception while serializing broker request: " + this._brokerRequest, e);
        }
        return Server.ServerRequest.newBuilder().putAllMetadata(metadata).setPayload(ByteString.copyFrom((byte[])payLoad)).addAllSegments(this._segments).build();
    }
}

