/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.utils.config;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.helix.model.InstanceConfig;
import org.apache.helix.zookeeper.datamodel.ZNRecord;
import org.apache.pinot.common.helix.ExtraInstanceConfig;
import org.apache.pinot.spi.config.instance.Instance;
import org.apache.pinot.spi.utils.CommonConstants;

public class InstanceUtils {
    public static final String POOL_KEY = "pool";

    private InstanceUtils() {
    }

    public static String getHelixInstanceId(Instance instance) {
        String prefix;
        switch (instance.getType()) {
            case CONTROLLER: {
                prefix = "Controller_";
                break;
            }
            case BROKER: {
                prefix = "Broker_";
                break;
            }
            case SERVER: {
                prefix = "Server_";
                break;
            }
            case MINION: {
                prefix = "Minion_";
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return prefix + instance.getHost() + "_" + instance.getPort();
    }

    public static String getServerAdminEndpoint(InstanceConfig instanceConfig) {
        String hostname = instanceConfig.getHostName();
        if (hostname.startsWith("Server_")) {
            hostname = hostname.substring(CommonConstants.Helix.SERVER_INSTANCE_PREFIX_LENGTH);
        }
        return InstanceUtils.getServerAdminEndpoint(instanceConfig, hostname, "http");
    }

    public static String getServerAdminEndpoint(InstanceConfig instanceConfig, String hostname, String defaultProtocol) {
        String protocol = defaultProtocol;
        int port = 8097;
        int adminPort = instanceConfig.getRecord().getIntField("adminPort", -1);
        int adminHttpsPort = instanceConfig.getRecord().getIntField("adminHttpsPort", -1);
        if (adminPort > 0) {
            protocol = "http";
            port = adminPort;
        } else if (adminHttpsPort > 0) {
            protocol = "https";
            port = adminHttpsPort;
        }
        return String.format("%s://%s:%d", protocol, hostname, port);
    }

    public static InstanceConfig toHelixInstanceConfig(Instance instance) {
        InstanceConfig instanceConfig = new InstanceConfig(InstanceUtils.getHelixInstanceId(instance));
        instanceConfig.setInstanceEnabled(true);
        InstanceUtils.updateHelixInstanceConfig(instanceConfig, instance);
        return instanceConfig;
    }

    public static void updateHelixInstanceConfig(InstanceConfig instanceConfig, Instance instance) {
        ZNRecord znRecord = instanceConfig.getRecord();
        Map simpleFields = znRecord.getSimpleFields();
        simpleFields.put(InstanceConfig.InstanceConfigProperty.HELIX_HOST.name(), instance.getHost());
        simpleFields.put(InstanceConfig.InstanceConfigProperty.HELIX_PORT.name(), Integer.toString(instance.getPort()));
        int grpcPort = instance.getGrpcPort();
        if (grpcPort > 0) {
            simpleFields.put("grpcPort", Integer.toString(grpcPort));
        } else {
            simpleFields.remove("grpcPort");
        }
        int adminPort = instance.getAdminPort();
        if (adminPort > 0) {
            simpleFields.put("adminPort", Integer.toString(adminPort));
        } else {
            simpleFields.remove("adminPort");
        }
        int queryServicePort = instance.getQueryServicePort();
        if (queryServicePort > 0) {
            simpleFields.put("queryServerPort", Integer.toString(queryServicePort));
        } else {
            simpleFields.remove("queryServerPort");
        }
        int queryMailboxPort = instance.getQueryMailboxPort();
        if (queryMailboxPort > 0) {
            simpleFields.put("queryMailboxPort", Integer.toString(queryMailboxPort));
        } else {
            simpleFields.remove("queryMailboxPort");
        }
        boolean queriesDisabled = instance.isQueriesDisabled();
        if (queriesDisabled) {
            simpleFields.put("queriesDisabled", Boolean.toString(true));
        } else {
            simpleFields.remove("queriesDisabled");
        }
        Map listFields = znRecord.getListFields();
        List tags = instance.getTags();
        String tagsKey = InstanceConfig.InstanceConfigProperty.TAG_LIST.name();
        if (CollectionUtils.isNotEmpty((Collection)tags)) {
            listFields.put(tagsKey, tags);
        } else {
            listFields.remove(tagsKey);
        }
        Map mapFields = znRecord.getMapFields();
        Map pools = instance.getPools();
        if (MapUtils.isNotEmpty((Map)pools)) {
            TreeMap<String, String> mapValue = new TreeMap<String, String>();
            for (Map.Entry entry : pools.entrySet()) {
                mapValue.put((String)entry.getKey(), ((Integer)entry.getValue()).toString());
            }
            mapFields.put(POOL_KEY, mapValue);
        } else {
            mapFields.remove(POOL_KEY);
        }
    }

    public static String getInstanceBaseUri(InstanceConfig instanceConfig) {
        String scheme;
        String adminPort;
        Map fieldMap = instanceConfig.getRecord().getSimpleFields();
        String hostName = instanceConfig.getHostName();
        if (fieldMap.containsKey("adminHttpsPort")) {
            adminPort = (String)fieldMap.get("adminHttpsPort");
            scheme = "https";
        } else if (fieldMap.containsKey(ExtraInstanceConfig.PinotInstanceConfigProperty.PINOT_TLS_PORT.toString())) {
            adminPort = (String)fieldMap.get(ExtraInstanceConfig.PinotInstanceConfigProperty.PINOT_TLS_PORT.toString());
            scheme = "https";
        } else {
            adminPort = fieldMap.getOrDefault("adminPort", instanceConfig.getPort());
            scheme = "http";
        }
        return String.format("%s://%s:%s", scheme, hostName, adminPort);
    }
}

