/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar;

import inet.ipaddr.AddressStringException;
import inet.ipaddr.IPAddress;
import inet.ipaddr.IPAddressString;
import org.apache.pinot.spi.annotations.ScalarFunction;

public class IpAddressFunctions {
    private IpAddressFunctions() {
    }

    private static IPAddress getPrefix(String prefixStr) {
        IPAddress prefixAddr = IpAddressFunctions.getAddress(prefixStr);
        if (!prefixAddr.isPrefixed()) {
            throw new IllegalArgumentException("IP Address " + prefixStr + " should be prefixed.");
        }
        return prefixAddr.toPrefixBlock();
    }

    private static IPAddress getAddress(String ipString) {
        try {
            return new IPAddressString(ipString).toAddress();
        }
        catch (AddressStringException e) {
            throw new IllegalArgumentException("Invalid IP Address format for " + ipString);
        }
    }

    @ScalarFunction
    public static boolean isSubnetOf(String ipPrefix, String ipAddress) {
        IPAddress prefix = IpAddressFunctions.getPrefix(ipPrefix);
        IPAddress ip = IpAddressFunctions.getAddress(ipAddress);
        if (ip.isPrefixed()) {
            throw new IllegalArgumentException("IP Address " + ipAddress + " should not be prefixed.");
        }
        return prefix.contains(ip);
    }
}

