/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function.scalar;

import java.math.BigDecimal;
import java.math.RoundingMode;
import org.apache.pinot.spi.annotations.ScalarFunction;

public class ArithmeticFunctions {
    private ArithmeticFunctions() {
    }

    @ScalarFunction(names={"add", "plus"})
    public static double plus(double a, double b) {
        return a + b;
    }

    @ScalarFunction(names={"sub", "minus"})
    public static double minus(double a, double b) {
        return a - b;
    }

    @ScalarFunction(names={"mult", "times"})
    public static double times(double a, double b) {
        return a * b;
    }

    @ScalarFunction(names={"div", "divide"})
    public static double divide(double a, double b) {
        return a / b;
    }

    @ScalarFunction(names={"div", "divide"})
    public static double divide(double a, double b, double defaultValue) {
        return b == 0.0 ? defaultValue : a / b;
    }

    @ScalarFunction
    public static double mod(double a, double b) {
        return a % b;
    }

    @ScalarFunction
    public static double least(double a, double b) {
        return Double.min(a, b);
    }

    @ScalarFunction
    public static double greatest(double a, double b) {
        return Double.max(a, b);
    }

    @Deprecated
    @ScalarFunction
    public static double min(double a, double b) {
        return ArithmeticFunctions.least(a, b);
    }

    @Deprecated
    @ScalarFunction
    public static double max(double a, double b) {
        return ArithmeticFunctions.greatest(a, b);
    }

    @ScalarFunction
    public static double abs(double a) {
        return Math.abs(a);
    }

    @ScalarFunction(names={"ceil", "ceiling"})
    public static double ceil(double a) {
        return Math.ceil(a);
    }

    @ScalarFunction
    public static double floor(double a) {
        return Math.floor(a);
    }

    @ScalarFunction
    public static double exp(double a) {
        return Math.exp(a);
    }

    @ScalarFunction(names={"ln", "log"})
    public static double ln(double a) {
        return Math.log(a);
    }

    @ScalarFunction
    public static double log2(double a) {
        return Math.log(a) / Math.log(2.0);
    }

    @ScalarFunction
    public static double log10(double a) {
        return Math.log10(a);
    }

    @ScalarFunction
    public static double sqrt(double a) {
        return Math.sqrt(a);
    }

    @ScalarFunction
    public static double sign(double a) {
        return Math.signum(a);
    }

    @ScalarFunction(names={"pow", "power"})
    public static double power(double a, double exponent) {
        return Math.pow(a, exponent);
    }

    @ScalarFunction(names={"roundDecimal", "round_decimal"})
    public static double roundDecimal(double a, int scale) {
        return BigDecimal.valueOf(a).setScale(scale, RoundingMode.HALF_UP).doubleValue();
    }

    @ScalarFunction(names={"roundDecimal", "round_decimal"})
    public static double roundDecimal(double a) {
        return Math.round(a);
    }

    @ScalarFunction
    public static double truncate(double a, int scale) {
        return BigDecimal.valueOf(a).setScale(scale, RoundingMode.DOWN).doubleValue();
    }

    @ScalarFunction
    public static double truncate(double a) {
        return Math.signum(a) * Math.floor(Math.abs(a));
    }
}

