/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public enum TransformFunctionType {
    ADD("add", "plus"),
    SUB("sub", "minus"),
    MULT("mult", "times"),
    DIV("div", "divide"),
    MOD("mod", new String[0]),
    ABS("abs", new String[0]),
    CEIL("ceil", "ceiling"),
    EXP("exp", new String[0]),
    FLOOR("floor", new String[0]),
    LOG("log", "ln"),
    LOG2("log2", new String[0]),
    LOG10("log10", new String[0]),
    SIGN("sign", new String[0]),
    ROUND_DECIMAL("roundDecimal", new String[0]),
    TRUNCATE("truncate", new String[0]),
    POWER("power", "pow"),
    SQRT("sqrt", new String[0]),
    LEAST("least", new String[0]),
    GREATEST("greatest", new String[0]),
    EQUALS("equals", new String[0]),
    NOT_EQUALS("not_equals", new String[0]),
    GREATER_THAN("greater_than", new String[0]),
    GREATER_THAN_OR_EQUAL("greater_than_or_equal", new String[0]),
    LESS_THAN("less_than", new String[0]),
    LESS_THAN_OR_EQUAL("less_than_or_equal", new String[0]),
    IN("in", new String[0]),
    NOT_IN("not_in", new String[0]),
    IS_NULL("is_null", new String[0]),
    IS_NOT_NULL("is_not_null", new String[0]),
    COALESCE("coalesce", new String[0]),
    IS_DISTINCT_FROM("is_distinct_from", new String[0]),
    IS_NOT_DISTINCT_FROM("is_not_distinct_from", new String[0]),
    AND("and", new String[0]),
    OR("or", new String[0]),
    NOT("not", new String[0]),
    CASE("case", new String[0]),
    CAST("cast", new String[0]),
    JSONEXTRACTSCALAR("jsonExtractScalar", new String[0]),
    JSONEXTRACTKEY("jsonExtractKey", new String[0]),
    TIMECONVERT("timeConvert", new String[0]),
    DATETIMECONVERT("dateTimeConvert", new String[0]),
    DATETRUNC("dateTrunc", new String[0]),
    YEAR("year", new String[0]),
    YEAR_OF_WEEK("yearOfWeek", "yow"),
    QUARTER("quarter", new String[0]),
    MONTH_OF_YEAR("monthOfYear", "month"),
    WEEK_OF_YEAR("weekOfYear", "week"),
    DAY_OF_YEAR("dayOfYear", "doy"),
    DAY_OF_MONTH("dayOfMonth", "day"),
    DAY_OF_WEEK("dayOfWeek", "dow"),
    HOUR("hour", new String[0]),
    MINUTE("minute", new String[0]),
    SECOND("second", new String[0]),
    MILLISECOND("millisecond", new String[0]),
    EXTRACT("extract", new String[0]),
    ARRAYLENGTH("arrayLength", "cardinality"),
    ARRAYAVERAGE("arrayAverage", new String[0]),
    ARRAYMIN("arrayMin", new String[0]),
    ARRAYMAX("arrayMax", new String[0]),
    ARRAYSUM("arraySum", new String[0]),
    VALUEIN("valueIn", new String[0]),
    MAPVALUE("mapValue", new String[0]),
    INIDSET("inIdSet", new String[0]),
    LOOKUP("lookUp", new String[0]),
    GROOVY("groovy", new String[0]),
    REGEXP_EXTRACT("regexpExtract", new String[0]),
    SCALAR("scalar", new String[0]),
    ST_GEOG_FROM_TEXT("ST_GeogFromText", new String[0]),
    ST_GEOM_FROM_TEXT("ST_GeomFromText", new String[0]),
    ST_GEOG_FROM_WKB("ST_GeogFromWKB", new String[0]),
    ST_GEOM_FROM_WKB("ST_GeomFromWKB", new String[0]),
    ST_POINT("ST_Point", new String[0]),
    ST_POLYGON("ST_Polygon", new String[0]),
    ST_AREA("ST_Area", new String[0]),
    ST_DISTANCE("ST_Distance", new String[0]),
    ST_GEOMETRY_TYPE("ST_GeometryType", new String[0]),
    ST_AS_BINARY("ST_AsBinary", new String[0]),
    ST_AS_TEXT("ST_AsText", new String[0]),
    ST_CONTAINS("ST_Contains", new String[0]),
    ST_EQUALS("ST_Equals", new String[0]),
    ST_WITHIN("ST_Within", new String[0]),
    GEOTOH3("geoToH3", new String[0]),
    SIN("sin", new String[0]),
    COS("cos", new String[0]),
    TAN("tan", new String[0]),
    COT("cot", new String[0]),
    ASIN("asin", new String[0]),
    ACOS("acos", new String[0]),
    ATAN("atan", new String[0]),
    ATAN2("atan2", new String[0]),
    SINH("sinh", new String[0]),
    COSH("cosh", new String[0]),
    TANH("tanh", new String[0]),
    DEGREES("degrees", new String[0]),
    RADIANS("radians", new String[0]);

    private final String _name;
    private final List<String> _aliases;

    private TransformFunctionType(String name, String ... aliases) {
        this._name = name;
        ArrayList<String> all = new ArrayList<String>(aliases.length + 2);
        all.add(name);
        all.add(this.name());
        all.addAll(Arrays.asList(aliases));
        this._aliases = Collections.unmodifiableList(all);
    }

    public String getName() {
        return this._name;
    }

    public List<String> getAliases() {
        return this._aliases;
    }
}

