/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.common.datablock;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.datablock.ColumnarDataBlock;
import org.apache.pinot.common.datablock.DataBlock;
import org.apache.pinot.common.datablock.MetadataBlock;
import org.apache.pinot.common.datablock.RowDataBlock;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.common.utils.DataSchema;
import org.roaringbitmap.RoaringBitmap;

public final class DataBlockUtils {
    static final int VERSION_TYPE_SHIFT = 5;

    private DataBlockUtils() {
    }

    public static MetadataBlock getErrorDataBlock(Exception e) {
        if (e instanceof ProcessingException) {
            return DataBlockUtils.getErrorDataBlock(Collections.singletonMap(((ProcessingException)((Object)e)).getErrorCode(), DataBlockUtils.extractErrorMsg(e)));
        }
        return DataBlockUtils.getErrorDataBlock(Collections.singletonMap(1000, DataBlockUtils.extractErrorMsg(e)));
    }

    private static String extractErrorMsg(Throwable t) {
        while (t.getMessage() == null) {
            t = t.getCause();
        }
        return t.getMessage() + "\n" + QueryException.getTruncatedStackTrace(t);
    }

    public static MetadataBlock getErrorDataBlock(Map<Integer, String> exceptions) {
        MetadataBlock errorBlock = new MetadataBlock(MetadataBlock.MetadataBlockType.ERROR);
        for (Map.Entry<Integer, String> exception : exceptions.entrySet()) {
            errorBlock.addException(exception.getKey(), exception.getValue());
        }
        return errorBlock;
    }

    public static MetadataBlock getEndOfStreamDataBlock() {
        return new MetadataBlock(MetadataBlock.MetadataBlockType.EOS);
    }

    public static MetadataBlock getNoOpBlock() {
        return new MetadataBlock(MetadataBlock.MetadataBlockType.NOOP);
    }

    public static DataBlock getDataBlock(ByteBuffer byteBuffer) throws IOException {
        int versionType = byteBuffer.getInt();
        int version = versionType & 0x1F;
        DataBlock.Type type = DataBlock.Type.fromOrdinal(versionType >> 5);
        switch (type) {
            case COLUMNAR: {
                return new ColumnarDataBlock(byteBuffer);
            }
            case ROW: {
                return new RowDataBlock(byteBuffer);
            }
            case METADATA: {
                return new MetadataBlock(byteBuffer);
            }
        }
        throw new UnsupportedOperationException("Unsupported data table version: " + version + " with type: " + type);
    }

    public static List<Object[]> extractRows(DataBlock dataBlock) {
        DataSchema dataSchema = dataBlock.getDataSchema();
        DataSchema.ColumnDataType[] columnDataTypes = dataSchema.getColumnDataTypes();
        RoaringBitmap[] nullBitmaps = DataBlockUtils.extractNullBitmaps(dataBlock);
        int numRows = dataBlock.getNumberOfRows();
        ArrayList<Object[]> rows = new ArrayList<Object[]>(numRows);
        for (int rowId = 0; rowId < numRows; ++rowId) {
            rows.add(DataBlockUtils.extractRowFromDataBlock(dataBlock, rowId, columnDataTypes, nullBitmaps));
        }
        return rows;
    }

    public static int computeColumnOffsets(DataSchema dataSchema, int[] columnOffsets) {
        int numColumns = columnOffsets.length;
        assert (numColumns == dataSchema.size());
        DataSchema.ColumnDataType[] storedColumnDataTypes = dataSchema.getStoredColumnDataTypes();
        int rowSizeInBytes = 0;
        block7: for (int i = 0; i < numColumns; ++i) {
            columnOffsets[i] = rowSizeInBytes;
            switch (storedColumnDataTypes[i]) {
                case INT: {
                    rowSizeInBytes += 4;
                    continue block7;
                }
                case LONG: {
                    rowSizeInBytes += 8;
                    continue block7;
                }
                case FLOAT: {
                    rowSizeInBytes += 4;
                    continue block7;
                }
                case DOUBLE: {
                    rowSizeInBytes += 8;
                    continue block7;
                }
                case STRING: {
                    rowSizeInBytes += 4;
                    continue block7;
                }
                default: {
                    rowSizeInBytes += 8;
                }
            }
        }
        return rowSizeInBytes;
    }

    public static void computeColumnSizeInBytes(DataSchema dataSchema, int[] columnSizes) {
        int numColumns = columnSizes.length;
        assert (numColumns == dataSchema.size());
        DataSchema.ColumnDataType[] storedColumnDataTypes = dataSchema.getStoredColumnDataTypes();
        block7: for (int i = 0; i < numColumns; ++i) {
            switch (storedColumnDataTypes[i]) {
                case INT: {
                    columnSizes[i] = 4;
                    continue block7;
                }
                case LONG: {
                    columnSizes[i] = 8;
                    continue block7;
                }
                case FLOAT: {
                    columnSizes[i] = 4;
                    continue block7;
                }
                case DOUBLE: {
                    columnSizes[i] = 8;
                    continue block7;
                }
                case STRING: {
                    columnSizes[i] = 4;
                    continue block7;
                }
                default: {
                    columnSizes[i] = 8;
                }
            }
        }
    }

    public static RoaringBitmap[] extractNullBitmaps(DataBlock dataBlock) {
        DataSchema dataSchema = dataBlock.getDataSchema();
        DataSchema.ColumnDataType[] columnDataTypes = dataSchema.getColumnDataTypes();
        int numColumns = columnDataTypes.length;
        RoaringBitmap[] nullBitmaps = new RoaringBitmap[numColumns];
        for (int colId = 0; colId < numColumns; ++colId) {
            nullBitmaps[colId] = dataBlock.getNullRowIds(colId);
        }
        return nullBitmaps;
    }

    public static Object[] extractRowFromDataBlock(DataBlock dataBlock, int rowId, DataSchema.ColumnDataType[] dataTypes, RoaringBitmap[] nullBitmaps) {
        int numColumns = nullBitmaps.length;
        Object[] row = new Object[numColumns];
        block18: for (int colId = 0; colId < numColumns; ++colId) {
            RoaringBitmap nullBitmap = nullBitmaps[colId];
            if (nullBitmap != null && nullBitmap.contains(rowId)) {
                row[colId] = null;
                continue;
            }
            switch (dataTypes[colId]) {
                case INT: {
                    row[colId] = dataBlock.getInt(rowId, colId);
                    continue block18;
                }
                case LONG: {
                    row[colId] = dataBlock.getLong(rowId, colId);
                    continue block18;
                }
                case FLOAT: {
                    row[colId] = Float.valueOf(dataBlock.getFloat(rowId, colId));
                    continue block18;
                }
                case DOUBLE: {
                    row[colId] = dataBlock.getDouble(rowId, colId);
                    continue block18;
                }
                case BIG_DECIMAL: {
                    row[colId] = dataBlock.getBigDecimal(rowId, colId);
                    continue block18;
                }
                case BOOLEAN: {
                    row[colId] = DataSchema.ColumnDataType.BOOLEAN.convert(dataBlock.getInt(rowId, colId));
                    continue block18;
                }
                case TIMESTAMP: {
                    row[colId] = new Timestamp(dataBlock.getLong(rowId, colId));
                    continue block18;
                }
                case STRING: {
                    row[colId] = dataBlock.getString(rowId, colId);
                    continue block18;
                }
                case BYTES: {
                    row[colId] = dataBlock.getBytes(rowId, colId);
                    continue block18;
                }
                case INT_ARRAY: {
                    row[colId] = dataBlock.getIntArray(rowId, colId);
                    continue block18;
                }
                case LONG_ARRAY: {
                    row[colId] = dataBlock.getLongArray(rowId, colId);
                    continue block18;
                }
                case FLOAT_ARRAY: {
                    row[colId] = dataBlock.getFloatArray(rowId, colId);
                    continue block18;
                }
                case DOUBLE_ARRAY: {
                    row[colId] = dataBlock.getDoubleArray(rowId, colId);
                    continue block18;
                }
                case STRING_ARRAY: {
                    row[colId] = dataBlock.getStringArray(rowId, colId);
                    continue block18;
                }
                case BOOLEAN_ARRAY: {
                    row[colId] = DataSchema.ColumnDataType.BOOLEAN_ARRAY.convert(dataBlock.getIntArray(rowId, colId));
                    continue block18;
                }
                case TIMESTAMP_ARRAY: {
                    row[colId] = DataSchema.ColumnDataType.TIMESTAMP_ARRAY.convert(dataBlock.getLongArray(rowId, colId));
                    continue block18;
                }
                default: {
                    throw new IllegalStateException(String.format("Unsupported data type: %s for column: %s", new Object[]{dataTypes[colId], colId}));
                }
            }
        }
        return row;
    }
}

