/*
 * Decompiled with CFR 0.152.
 */
package okio;

import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import okio.SegmentPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B/\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0002\u0010\u000bJ\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u0004\u0018\u00010\u0000J\u000e\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000J\u0006\u0010\u0013\u001a\u00020\u0000J\u000e\u0010\u0014\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0006J\u0006\u0010\u0016\u001a\u00020\u0000J\u0016\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0015\u001a\u00020\u0006R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0007\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u0004\u0018\u00010\u00008\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u0004\u0018\u00010\u00008\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\b\u001a\u00020\t8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lokio/Segment;", "", "()V", "data", "", "pos", "", "limit", "shared", "", "owner", "([BIIZZ)V", "next", "prev", "compact", "", "pop", "push", "segment", "sharedCopy", "split", "byteCount", "unsharedCopy", "writeTo", "sink", "Companion", "okio"})
@SourceDebugExtension(value={"SMAP\nSegment.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Segment.kt\nokio/Segment\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,185:1\n1#2:186\n*E\n"})
public final class Segment {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final byte[] data;
    @JvmField
    public int pos;
    @JvmField
    public int limit;
    @JvmField
    public boolean shared;
    @JvmField
    public boolean owner;
    @JvmField
    @Nullable
    public Segment next;
    @JvmField
    @Nullable
    public Segment prev;
    public static final int SIZE = 8192;
    public static final int SHARE_MINIMUM = 1024;

    public Segment() {
        this.data = new byte[8192];
        this.owner = true;
        this.shared = false;
    }

    public Segment(@NotNull byte[] data, int pos, int limit, boolean shared, boolean owner) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.data = data;
        this.pos = pos;
        this.limit = limit;
        this.shared = shared;
        this.owner = owner;
    }

    @NotNull
    public final Segment sharedCopy() {
        this.shared = true;
        return new Segment(this.data, this.pos, this.limit, true, false);
    }

    @NotNull
    public final Segment unsharedCopy() {
        byte[] byArray = Arrays.copyOf(this.data, this.data.length);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"copyOf(this, size)");
        return new Segment(byArray, this.pos, this.limit, false, true);
    }

    @Nullable
    public final Segment pop() {
        Segment result = this.next != this ? this.next : null;
        Intrinsics.checkNotNull((Object)this.prev);
        this.prev.next = this.next;
        Intrinsics.checkNotNull((Object)this.next);
        this.next.prev = this.prev;
        this.next = null;
        this.prev = null;
        return result;
    }

    @NotNull
    public final Segment push(@NotNull Segment segment) {
        Intrinsics.checkNotNullParameter((Object)segment, (String)"segment");
        segment.prev = this;
        segment.next = this.next;
        Intrinsics.checkNotNull((Object)this.next);
        this.next.prev = segment;
        this.next = segment;
        return segment;
    }

    @NotNull
    public final Segment split(int byteCount) {
        if (!(byteCount > 0 && byteCount <= this.limit - this.pos)) {
            boolean bl = false;
            String string = "byteCount out of range";
            throw new IllegalArgumentException(string.toString());
        }
        Segment prefix = null;
        if (byteCount >= 1024) {
            prefix = this.sharedCopy();
        } else {
            prefix = SegmentPool.take();
            ArraysKt.copyInto$default((byte[])this.data, (byte[])prefix.data, (int)0, (int)this.pos, (int)(this.pos + byteCount), (int)2, null);
        }
        prefix.limit = prefix.pos + byteCount;
        this.pos += byteCount;
        Segment segment = this.prev;
        Intrinsics.checkNotNull((Object)segment);
        segment.push(prefix);
        return prefix;
    }

    public final void compact() {
        int n;
        if (!(this.prev != this)) {
            boolean $i$a$-check-Segment$compact$22 = false;
            String $i$a$-check-Segment$compact$22 = "cannot compact";
            throw new IllegalStateException($i$a$-check-Segment$compact$22.toString());
        }
        Segment segment = this.prev;
        Intrinsics.checkNotNull((Object)segment);
        if (!segment.owner) {
            return;
        }
        int byteCount = this.limit - this.pos;
        Segment segment2 = this.prev;
        Intrinsics.checkNotNull((Object)segment2);
        int n2 = 8192 - segment2.limit;
        Segment segment3 = this.prev;
        Intrinsics.checkNotNull((Object)segment3);
        if (segment3.shared) {
            n = 0;
        } else {
            Segment segment4 = this.prev;
            Intrinsics.checkNotNull((Object)segment4);
            n = segment4.pos;
        }
        int availableByteCount = n2 + n;
        if (byteCount > availableByteCount) {
            return;
        }
        Segment segment5 = this.prev;
        Intrinsics.checkNotNull((Object)segment5);
        this.writeTo(segment5, byteCount);
        this.pop();
        SegmentPool.recycle(this);
    }

    public final void writeTo(@NotNull Segment sink2, int byteCount) {
        Intrinsics.checkNotNullParameter((Object)sink2, (String)"sink");
        if (!sink2.owner) {
            boolean bl = false;
            String string = "only owner can write";
            throw new IllegalStateException(string.toString());
        }
        if (sink2.limit + byteCount > 8192) {
            if (sink2.shared) {
                throw new IllegalArgumentException();
            }
            if (sink2.limit + byteCount - sink2.pos > 8192) {
                throw new IllegalArgumentException();
            }
            ArraysKt.copyInto$default((byte[])sink2.data, (byte[])sink2.data, (int)0, (int)sink2.pos, (int)sink2.limit, (int)2, null);
            sink2.limit -= sink2.pos;
            sink2.pos = 0;
        }
        ArraysKt.copyInto((byte[])this.data, (byte[])sink2.data, (int)sink2.limit, (int)this.pos, (int)(this.pos + byteCount));
        sink2.limit += byteCount;
        this.pos += byteCount;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lokio/Segment$Companion;", "", "()V", "SHARE_MINIMUM", "", "SIZE", "okio"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

