/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.janino;

import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.codehaus.commons.compiler.InternalCompilerException;
import org.codehaus.commons.nullanalysis.Nullable;
import org.codehaus.janino.Descriptor;
import org.codehaus.janino.IClass;
import org.codehaus.janino.Java;
import org.codehaus.janino.StackMap;
import org.codehaus.janino.util.ClassFile;

public class CodeContext {
    private static final int INITIAL_SIZE = 128;
    private final ClassFile classFile;
    private int maxStack;
    private short maxLocals;
    private byte[] code;
    private final Offset beginning;
    private final Inserter end;
    private Inserter currentInserter;
    private final List<ExceptionTableEntry> exceptionTableEntries;
    private final List<Java.LocalVariableSlot> allLocalVars = new ArrayList<Java.LocalVariableSlot>();
    @Nullable
    private LocalScope currentLocalScope;
    private short nextLocalVariableSlot;
    private final List<Relocatable> relocatables = new ArrayList<Relocatable>();
    private static final Map<Integer, Integer> BRANCH_OPCODE_INVERSION = CodeContext.createBranchOpcodeInversion();

    public CodeContext(ClassFile classFile) {
        this.classFile = classFile;
        this.maxStack = 0;
        this.maxLocals = 0;
        this.code = new byte[128];
        this.exceptionTableEntries = new ArrayList<ExceptionTableEntry>();
        this.beginning = new Offset();
        this.beginning.offset = 0;
        this.currentInserter = new Inserter();
        this.currentInserter.offset = 0;
        this.currentInserter.setStackMap(new StackMap(new ClassFile.StackMapTableAttribute.VerificationTypeInfo[0], new ClassFile.StackMapTableAttribute.VerificationTypeInfo[0]));
        this.beginning.next = this.currentInserter;
        this.currentInserter.prev = this.beginning;
        this.end = this.currentInserter;
    }

    public ClassFile getClassFile() {
        return this.classFile;
    }

    public short allocateLocalVariable(short size) {
        return this.allocateLocalVariable(size, null, null).getSlotIndex();
    }

    public Java.LocalVariableSlot allocateLocalVariable(short size, @Nullable String name, @Nullable IClass type) {
        LocalScope currentScope = this.currentLocalScope;
        assert (currentScope != null) : "saveLocalVariables must be called first";
        List<Java.LocalVariableSlot> currentVars = currentScope.localVars;
        Java.LocalVariableSlot slot = new Java.LocalVariableSlot(name, this.nextLocalVariableSlot, type);
        if (name != null) {
            slot.setStart(this.newOffset());
        }
        this.nextLocalVariableSlot = (short)(this.nextLocalVariableSlot + size);
        currentVars.add(slot);
        this.allLocalVars.add(slot);
        if (this.nextLocalVariableSlot > this.maxLocals) {
            this.maxLocals = this.nextLocalVariableSlot;
        }
        return slot;
    }

    public List<Java.LocalVariableSlot> saveLocalVariables() {
        this.currentLocalScope = new LocalScope(this.currentLocalScope, this.nextLocalVariableSlot, this.currentInserter.getStackMap());
        return this.currentLocalScope.localVars;
    }

    public void restoreLocalVariables() {
        StackMap sm;
        LocalScope scopeToPop = this.currentLocalScope;
        assert (scopeToPop != null);
        for (Java.LocalVariableSlot slot : scopeToPop.localVars) {
            if (slot.getName() != null) {
                slot.setEnd(this.newOffset());
            }
            this.allLocalVars.remove(slot);
        }
        this.currentLocalScope = scopeToPop.parent;
        if (this.currentLocalScope != null && (sm = this.currentInserter.getStackMap()) != null) {
            int numLocalsInStackMap = 0;
            for (ClassFile.StackMapTableAttribute.VerificationTypeInfo slot : sm.locals()) {
                if (slot == ClassFile.StackMapTableAttribute.TOP_VARIABLE_INFO) continue;
                ++numLocalsInStackMap;
            }
            while (numLocalsInStackMap-- > this.allLocalVars.size()) {
                sm = sm.popLocal();
            }
            this.currentInserter.setStackMap(sm);
        }
        this.nextLocalVariableSlot = scopeToPop.startingLocalVariableSlot;
    }

    protected void storeCodeAttributeBody(DataOutputStream dos, short lineNumberTableAttributeNameIndex, short localVariableTableAttributeNameIndex, short stackMapTableAttributeNameIndex) throws IOException {
        ClassFile.AttributeInfo ai;
        dos.writeShort(this.maxStack);
        dos.writeShort(this.maxLocals);
        dos.writeInt(this.end.offset);
        dos.write(this.code, 0, this.end.offset);
        dos.writeShort(this.exceptionTableEntries.size());
        for (ExceptionTableEntry exceptionTableEntry : this.exceptionTableEntries) {
            dos.writeShort(exceptionTableEntry.startPc.offset);
            dos.writeShort(exceptionTableEntry.endPc.offset);
            dos.writeShort(exceptionTableEntry.handlerPc.offset);
            dos.writeShort(exceptionTableEntry.catchType);
        }
        ArrayList<ClassFile.AttributeInfo> attributes = new ArrayList<ClassFile.AttributeInfo>();
        if (lineNumberTableAttributeNameIndex != 0) {
            ArrayList<ClassFile.LineNumberTableAttribute.Entry> lnt = new ArrayList<ClassFile.LineNumberTableAttribute.Entry>();
            Offset o = this.beginning;
            while (o != null) {
                if (o instanceof LineNumberOffset) {
                    int offset = o.offset;
                    if (offset > 65535) {
                        throw new InternalCompilerException("LineNumberTable entry offset out of range");
                    }
                    short lineNumber = ((LineNumberOffset)o).lineNumber;
                    lnt.add(new ClassFile.LineNumberTableAttribute.Entry((short)offset, lineNumber));
                }
                o = o.next;
            }
            ClassFile.LineNumberTableAttribute.Entry[] lnte = lnt.toArray(new ClassFile.LineNumberTableAttribute.Entry[lnt.size()]);
            attributes.add(new ClassFile.LineNumberTableAttribute(lineNumberTableAttributeNameIndex, lnte));
        }
        if (localVariableTableAttributeNameIndex != 0 && (ai = this.storeLocalVariableTable(dos, localVariableTableAttributeNameIndex)) != null) {
            attributes.add(ai);
        }
        Offset frame = this.beginning;
        Offset previousFrame = null;
        while (frame.offset == 0) {
            previousFrame = frame;
            frame = frame.next;
            assert (frame != null);
        }
        assert (previousFrame != null);
        ArrayList<ClassFile.StackMapTableAttribute.StackMapFrame> smfs = new ArrayList<ClassFile.StackMapTableAttribute.StackMapFrame>();
        while (frame != null && frame.offset != this.end.offset) {
            Offset next;
            if (!(frame instanceof Java.Padder || frame instanceof FourByteOffset || (next = frame.next) != null && frame.offset == next.offset)) {
                int k;
                int offsetDelta = previousFrame.offset == 0 ? frame.offset : frame.offset - previousFrame.offset - 1;
                ClassFile.StackMapTableAttribute.VerificationTypeInfo[] frameOperands = frame.getStackMap().operands();
                int frameOperandsLength = frameOperands.length;
                Object[] frameLocals = frame.getStackMap().locals();
                int frameLocalsLength = frameLocals.length;
                Object[] previousFrameLocals = previousFrame.getStackMap().locals();
                int previousFrameLocalsLength = previousFrameLocals.length;
                if (frameOperandsLength == 0 && Arrays.equals(frameLocals, previousFrameLocals)) {
                    if (offsetDelta <= 63) {
                        smfs.add(new ClassFile.StackMapTableAttribute.SameFrame(offsetDelta));
                    } else {
                        smfs.add(new ClassFile.StackMapTableAttribute.SameFrameExtended(offsetDelta));
                    }
                } else if (frameOperandsLength == 1 && Arrays.equals(frameLocals, previousFrameLocals)) {
                    if (offsetDelta <= 63) {
                        smfs.add(new ClassFile.StackMapTableAttribute.SameLocals1StackItemFrame(offsetDelta, frameOperands[0]));
                    } else {
                        smfs.add(new ClassFile.StackMapTableAttribute.SameLocals1StackItemFrameExtended(offsetDelta, frameOperands[0]));
                    }
                } else if (frameOperandsLength == 0 && (k = previousFrameLocalsLength - frameLocalsLength) >= 1 && k <= 3 && Arrays.equals(frameLocals, Arrays.copyOf(previousFrameLocals, frameLocalsLength))) {
                    smfs.add(new ClassFile.StackMapTableAttribute.ChopFrame(offsetDelta, k));
                } else if (frameOperandsLength == 0 && (k = frameLocalsLength - previousFrameLocalsLength) >= 1 && k <= 3 && Arrays.equals(previousFrameLocals, Arrays.copyOf(frameLocals, previousFrameLocalsLength))) {
                    smfs.add(new ClassFile.StackMapTableAttribute.AppendFrame(offsetDelta, (ClassFile.StackMapTableAttribute.VerificationTypeInfo[])Arrays.copyOfRange(frameLocals, previousFrameLocalsLength, frameLocalsLength)));
                } else {
                    smfs.add(new ClassFile.StackMapTableAttribute.FullFrame(offsetDelta, (ClassFile.StackMapTableAttribute.VerificationTypeInfo[])frameLocals, frameOperands));
                }
                previousFrame = frame;
            }
            frame = frame.next;
        }
        attributes.add(new ClassFile.StackMapTableAttribute(stackMapTableAttributeNameIndex, smfs.toArray(new ClassFile.StackMapTableAttribute.StackMapFrame[smfs.size()])));
        dos.writeShort(attributes.size());
        for (ClassFile.AttributeInfo attribute : attributes) {
            attribute.store(dos);
        }
    }

    @Nullable
    protected ClassFile.AttributeInfo storeLocalVariableTable(DataOutputStream dos, short localVariableTableAttributeNameIndex) {
        ClassFile cf = this.getClassFile();
        ArrayList<ClassFile.LocalVariableTableAttribute.Entry> entryList = new ArrayList<ClassFile.LocalVariableTableAttribute.Entry>();
        for (Java.LocalVariableSlot slot : this.getAllLocalVars()) {
            String localVariableName = slot.getName();
            if (localVariableName == null) continue;
            String typeName = slot.getType().getDescriptor();
            short classSlot = cf.addConstantUtf8Info(typeName);
            short varNameSlot = cf.addConstantUtf8Info(localVariableName);
            Offset start = slot.getStart();
            Offset end2 = slot.getEnd();
            assert (start != null);
            assert (end2 != null);
            ClassFile.LocalVariableTableAttribute.Entry entry = new ClassFile.LocalVariableTableAttribute.Entry((short)start.offset, (short)(end2.offset - start.offset), varNameSlot, classSlot, slot.getSlotIndex());
            entryList.add(entry);
        }
        if (entryList.size() > 0) {
            ClassFile.LocalVariableTableAttribute.Entry[] entries = entryList.toArray(new ClassFile.LocalVariableTableAttribute.Entry[entryList.size()]);
            return new ClassFile.LocalVariableTableAttribute(localVariableTableAttributeNameIndex, entries);
        }
        return null;
    }

    public void fixUpAndRelocate() {
        this.maybeGrow();
        this.fixUp();
        this.relocate();
    }

    private void maybeGrow() {
        for (Relocatable relocatable : this.relocatables) {
            relocatable.grow();
        }
    }

    private void fixUp() {
        Offset o = this.beginning;
        while (o != this.end) {
            assert (o != null);
            if (o instanceof FixUp) {
                ((FixUp)((Object)o)).fixUp();
            }
            o = o.next;
        }
    }

    private void relocate() {
        for (Relocatable relocatable : this.relocatables) {
            relocatable.relocate();
        }
    }

    public void write(byte[] b) {
        if (b.length == 0) {
            return;
        }
        int o = this.makeSpace(b.length);
        System.arraycopy(b, 0, this.code, o, b.length);
    }

    public void write(byte b1) {
        int o = this.makeSpace(1);
        this.code[o] = b1;
    }

    public void write(byte b1, byte b2) {
        int o = this.makeSpace(2);
        this.code[o++] = b1;
        this.code[o] = b2;
    }

    public void write(byte b1, byte b2, byte b3) {
        int o = this.makeSpace(3);
        this.code[o++] = b1;
        this.code[o++] = b2;
        this.code[o] = b3;
    }

    public void write(byte b1, byte b2, byte b3, byte b4) {
        int o = this.makeSpace(4);
        this.code[o++] = b1;
        this.code[o++] = b2;
        this.code[o++] = b3;
        this.code[o] = b4;
    }

    public void addLineNumberOffset(int lineNumber) {
        if (lineNumber == -1) {
            return;
        }
        if (lineNumber > 65535) {
            lineNumber = 65535;
        }
        Offset o = this.currentInserter.prev;
        while (o != this.beginning) {
            assert (o != null);
            if (o instanceof LineNumberOffset) {
                if ((((LineNumberOffset)o).lineNumber & 0xFFFF) != lineNumber) break;
                return;
            }
            o = o.prev;
        }
        LineNumberOffset lno = new LineNumberOffset(this.currentInserter.offset, this.currentInserter.getStackMap(), (short)lineNumber);
        Offset cip = this.currentInserter.prev;
        assert (cip != null);
        lno.prev = cip;
        lno.next = this.currentInserter;
        cip.next = lno;
        this.currentInserter.prev = lno;
    }

    public int makeSpace(int size) {
        int cio = this.currentInserter.offset;
        if (size == 0) {
            return cio;
        }
        if (this.end.offset + size <= this.code.length) {
            if (cio != this.end.offset) {
                System.arraycopy(this.code, cio, this.code, cio + size, this.end.offset - cio);
            }
        } else {
            byte[] oldCode = this.code;
            int newSize = Math.max(Math.min(oldCode.length * 2, 65535), oldCode.length + size);
            if (newSize > 65535) {
                throw new InternalCompilerException("Code grows beyond 64 KB");
            }
            this.code = new byte[newSize];
            System.arraycopy(oldCode, 0, this.code, 0, cio);
            System.arraycopy(oldCode, cio, this.code, cio + size, this.end.offset - cio);
        }
        Arrays.fill(this.code, cio, cio + size, (byte)0);
        Offset o = this.currentInserter;
        while (o != null) {
            o.offset += size;
            o = o.next;
        }
        return cio;
    }

    public void writeShort(int v) {
        this.write((byte)(v >> 8), (byte)v);
    }

    public void writeBranch(int opcode, Offset dst) {
        if (dst.offset == -1 && dst.stackMap == null) {
            dst.stackMap = this.currentInserter.getStackMap();
        }
        this.relocatables.add(new Branch(opcode, dst));
        this.write((byte)opcode, (byte)-1, (byte)-1);
    }

    private static int invertBranchOpcode(int branchOpcode) {
        Integer result = BRANCH_OPCODE_INVERSION.get(branchOpcode);
        assert (result != null) : branchOpcode;
        return result;
    }

    private static Map<Integer, Integer> createBranchOpcodeInversion() {
        HashMap<Integer, Integer> m = new HashMap<Integer, Integer>();
        m.put(165, 166);
        m.put(166, 165);
        m.put(159, 160);
        m.put(160, 159);
        m.put(162, 161);
        m.put(161, 162);
        m.put(163, 164);
        m.put(164, 163);
        m.put(153, 154);
        m.put(154, 153);
        m.put(156, 155);
        m.put(155, 156);
        m.put(157, 158);
        m.put(158, 157);
        m.put(198, 199);
        m.put(199, 198);
        return Collections.unmodifiableMap(m);
    }

    public void writeOffset(Offset src, Offset dst) {
        FourByteOffset o = new FourByteOffset();
        o.set();
        this.relocatables.add(new OffsetBranch(o, src, dst));
        this.makeSpace(4);
    }

    public Offset newOffset() {
        Offset o = new Offset();
        o.set();
        return o;
    }

    public Inserter newInserter() {
        Inserter i = new Inserter();
        i.set();
        return i;
    }

    public Inserter currentInserter() {
        return this.currentInserter;
    }

    public void pushInserter(Inserter ins) {
        ins.getStackMap();
        if (ins.nextInserter != null) {
            throw new InternalCompilerException("An Inserter can only be pushed once at a time");
        }
        ins.nextInserter = this.currentInserter;
        this.currentInserter = ins;
    }

    public void popInserter() {
        Inserter ni = this.currentInserter.nextInserter;
        if (ni == null) {
            throw new InternalCompilerException("Code inserter stack underflow");
        }
        ni.getStackMap();
        this.currentInserter.nextInserter = null;
        this.currentInserter = ni;
    }

    @Nullable
    private static final StackMap mergeStackMaps(@Nullable StackMap sm1, @Nullable StackMap sm2) {
        if (sm1 == null) {
            return sm2;
        }
        if (sm2 == null) {
            return sm1;
        }
        if (sm1 == sm2) {
            return sm1;
        }
        if (sm1.equals(sm2)) {
            return sm1;
        }
        if (!Arrays.equals(sm1.operands(), sm2.operands())) {
            throw new InternalCompilerException("Inconsistent operand stack: " + sm1 + " vs. " + sm2);
        }
        ClassFile.StackMapTableAttribute.VerificationTypeInfo[] locals1 = sm1.locals();
        ClassFile.StackMapTableAttribute.VerificationTypeInfo[] locals2 = sm2.locals();
        ClassFile.StackMapTableAttribute.VerificationTypeInfo[] tmp = new ClassFile.StackMapTableAttribute.VerificationTypeInfo[Math.min(locals1.length, locals2.length)];
        for (int i = 0; i < tmp.length; ++i) {
            ClassFile.StackMapTableAttribute.VerificationTypeInfo local1 = locals1[i];
            ClassFile.StackMapTableAttribute.VerificationTypeInfo local2 = locals2[i];
            ClassFile.StackMapTableAttribute.VerificationTypeInfo tmpLocal = local1.equals(local2) ? local1 : (local1 == ClassFile.StackMapTableAttribute.TOP_VARIABLE_INFO || local2 == ClassFile.StackMapTableAttribute.TOP_VARIABLE_INFO ? ClassFile.StackMapTableAttribute.TOP_VARIABLE_INFO : ClassFile.StackMapTableAttribute.TOP_VARIABLE_INFO);
            tmp[i] = tmpLocal;
        }
        return new StackMap(tmp, sm1.operands());
    }

    public void addExceptionTableEntry(Offset startPc, Offset endPc, Offset handlerPc, @Nullable String catchTypeFd) {
        this.exceptionTableEntries.add(new ExceptionTableEntry(startPc, endPc, handlerPc, catchTypeFd == null ? (short)0 : this.classFile.addConstantClassInfo(catchTypeFd)));
    }

    public List<Java.LocalVariableSlot> getAllLocalVars() {
        return this.allLocalVars;
    }

    public void removeCode(Offset from, Offset to) {
        HashSet<Offset> invalidOffsets;
        block25: {
            if (from == to) {
                return;
            }
            int size = to.offset - from.offset;
            assert (size >= 0);
            if (size == 0) {
                return;
            }
            System.arraycopy(this.code, to.offset, this.code, from.offset, this.end.offset - to.offset);
            invalidOffsets = new HashSet<Offset>();
            Offset o = from.next;
            assert (o != null);
            while (o != to) {
                assert (o != null);
                invalidOffsets.add(o);
                Offset n = o.next;
                o.offset = -77;
                o.prev = null;
                o.next = null;
                o = n;
                assert (o != null);
            }
            while (true) {
                o.offset -= size;
                if (o == this.end) break block25;
                o = o.next;
                assert (o != null);
            }
        }
        Iterator<Object> it = this.relocatables.iterator();
        while (it.hasNext()) {
            Relocatable r = it.next();
            if (r instanceof Branch) {
                Branch b = (Branch)r;
                if (invalidOffsets.contains(b.source)) {
                    it.remove();
                } else assert (!invalidOffsets.contains(b.destination));
            }
            if (!(r instanceof OffsetBranch)) continue;
            OffsetBranch ob = (OffsetBranch)r;
            if (invalidOffsets.contains(ob.source)) {
                it.remove();
                continue;
            }
            assert (!invalidOffsets.contains(ob.destination));
        }
        it = this.exceptionTableEntries.iterator();
        while (it.hasNext()) {
            ExceptionTableEntry ete = (ExceptionTableEntry)it.next();
            if (invalidOffsets.contains(ete.startPc)) {
                assert (invalidOffsets.contains(ete.endPc));
                assert (invalidOffsets.contains(ete.handlerPc));
                it.remove();
                continue;
            }
            assert (!invalidOffsets.contains(ete.endPc));
            assert (!invalidOffsets.contains(ete.handlerPc));
        }
        it = this.allLocalVars.iterator();
        while (it.hasNext()) {
            Java.LocalVariableSlot var = (Java.LocalVariableSlot)it.next();
            if (invalidOffsets.contains(var.getStart())) {
                assert (invalidOffsets.contains(var.getEnd()));
                it.remove();
                continue;
            }
            assert (!invalidOffsets.contains(var.getEnd()));
        }
        from.next = to;
        to.prev = from;
    }

    public String toString() {
        return this.classFile.getThisClassName() + "/cio=" + this.currentInserter.offset;
    }

    public void pushOperand(String fieldDescriptor) {
        if (Descriptor.isReference(fieldDescriptor)) {
            this.pushObjectOperand(fieldDescriptor);
        } else if (fieldDescriptor.equals("B") || fieldDescriptor.equals("C") || fieldDescriptor.equals("I") || fieldDescriptor.equals("S") || fieldDescriptor.equals("Z")) {
            this.pushIntOperand();
        } else if (fieldDescriptor.equals("D")) {
            this.pushDoubleOperand();
        } else if (fieldDescriptor.equals("F")) {
            this.pushFloatOperand();
        } else if (fieldDescriptor.equals("J")) {
            this.pushLongOperand();
        } else {
            throw new AssertionError((Object)fieldDescriptor);
        }
    }

    public void pushTopOperand() {
        this.pushOperand(ClassFile.StackMapTableAttribute.TOP_VARIABLE_INFO);
    }

    public void pushIntOperand() {
        this.pushOperand(ClassFile.StackMapTableAttribute.INTEGER_VARIABLE_INFO);
    }

    public void pushLongOperand() {
        this.pushOperand(ClassFile.StackMapTableAttribute.LONG_VARIABLE_INFO);
    }

    public void pushFloatOperand() {
        this.pushOperand(ClassFile.StackMapTableAttribute.FLOAT_VARIABLE_INFO);
    }

    public void pushDoubleOperand() {
        this.pushOperand(ClassFile.StackMapTableAttribute.DOUBLE_VARIABLE_INFO);
    }

    public void pushNullOperand() {
        this.pushOperand(ClassFile.StackMapTableAttribute.NULL_VARIABLE_INFO);
    }

    public void pushUninitializedThisOperand() {
        this.pushOperand(ClassFile.StackMapTableAttribute.UNINITIALIZED_THIS_VARIABLE_INFO);
    }

    public void pushUninitializedOperand() {
        final Offset o = this.newOffset();
        final ClassFile.StackMapTableAttribute.UninitializedVariableInfo uvi = this.classFile.newUninitializedVariableInfo((short)o.offset);
        this.relocatables.add(new Relocatable(){

            @Override
            public void grow() {
            }

            @Override
            public void relocate() {
                uvi.offset = (short)o.offset;
            }
        });
        this.pushOperand(uvi);
    }

    public void pushObjectOperand(String fieldDescriptor) {
        this.pushOperand(this.classFile.newObjectVariableInfo(fieldDescriptor));
    }

    public void pushOperand(ClassFile.StackMapTableAttribute.VerificationTypeInfo topOperand) {
        Inserter ci = this.currentInserter();
        StackMap sm = ci.getStackMap();
        sm = sm.pushOperand(topOperand);
        ci.setStackMap(sm);
        int ss = 0;
        for (ClassFile.StackMapTableAttribute.VerificationTypeInfo vti : sm.operands()) {
            ss += vti.category();
        }
        if (ss > this.maxStack) {
            this.maxStack = ss;
        }
    }

    public boolean peekNullOperand() {
        return this.peekOperand() == ClassFile.StackMapTableAttribute.NULL_VARIABLE_INFO;
    }

    public boolean peekObjectOperand() {
        return this.peekOperand() instanceof ClassFile.StackMapTableAttribute.ObjectVariableInfo;
    }

    public ClassFile.StackMapTableAttribute.VerificationTypeInfo peekOperand() {
        return this.currentInserter().getStackMap().peekOperand();
    }

    public ClassFile.StackMapTableAttribute.VerificationTypeInfo popOperand() {
        ClassFile.StackMapTableAttribute.VerificationTypeInfo result;
        Inserter ci = this.currentInserter();
        StackMap sm = ci.getStackMap();
        do {
            result = sm.peekOperand();
            sm = sm.popOperand();
        } while (result == ClassFile.StackMapTableAttribute.TOP_VARIABLE_INFO);
        ci.setStackMap(sm);
        return result;
    }

    public void popOperand(ClassFile.StackMapTableAttribute.VerificationTypeInfo expected) {
        ClassFile.StackMapTableAttribute.VerificationTypeInfo actual = this.popOperand();
        assert (actual.equals(expected)) : actual;
    }

    public void popOperand(String expectedFd) {
        ClassFile.StackMapTableAttribute.VerificationTypeInfo vti = this.popOperand();
        if (vti == ClassFile.StackMapTableAttribute.INTEGER_VARIABLE_INFO) {
            assert (expectedFd.equals("Z") || expectedFd.equals("B") || expectedFd.equals("C") || expectedFd.equals("S") || expectedFd.equals("I")) : expectedFd;
        } else if (vti == ClassFile.StackMapTableAttribute.LONG_VARIABLE_INFO) {
            assert (expectedFd.equals("J")) : expectedFd;
        } else if (vti == ClassFile.StackMapTableAttribute.FLOAT_VARIABLE_INFO) {
            assert (expectedFd.equals("F")) : expectedFd;
        } else if (vti == ClassFile.StackMapTableAttribute.DOUBLE_VARIABLE_INFO) {
            assert (expectedFd.equals("D")) : expectedFd;
        } else if (vti == ClassFile.StackMapTableAttribute.NULL_VARIABLE_INFO) {
            assert (expectedFd.equals("V")) : expectedFd;
        } else if (vti instanceof ClassFile.StackMapTableAttribute.ObjectVariableInfo) {
            assert (Descriptor.isReference(expectedFd)) : expectedFd + " vs. " + vti;
            ClassFile.StackMapTableAttribute.ObjectVariableInfo ovi = (ClassFile.StackMapTableAttribute.ObjectVariableInfo)vti;
            ClassFile.ConstantClassInfo cci = this.classFile.getConstantClassInfo(ovi.getConstantClassInfoIndex());
            String computationalTypeFd = Descriptor.fromInternalForm(cci.getName(this.classFile));
            assert (expectedFd.equals(computationalTypeFd)) : expectedFd + " vs. " + computationalTypeFd;
        } else if (vti instanceof ClassFile.StackMapTableAttribute.UninitializedVariableInfo) {
            assert (Descriptor.isReference(expectedFd)) : expectedFd;
        } else {
            throw new AssertionError(vti);
        }
    }

    public void popOperandAssignableTo(String declaredFd) {
        if (Descriptor.isPrimitive(declaredFd)) {
            this.popOperand(declaredFd);
        } else {
            this.popObjectOrUninitializedOrUninitializedThisOperand();
        }
    }

    public void popIntOperand() {
        this.popOperand(ClassFile.StackMapTableAttribute.INTEGER_VARIABLE_INFO);
    }

    public void popLongOperand() {
        this.popOperand(ClassFile.StackMapTableAttribute.LONG_VARIABLE_INFO);
    }

    public void popUninitializedThisOperand() {
        this.popOperand(ClassFile.StackMapTableAttribute.UNINITIALIZED_THIS_VARIABLE_INFO);
    }

    public void popUninitializedVariableOperand() {
        ClassFile.StackMapTableAttribute.VerificationTypeInfo op = this.popOperand();
        assert (op instanceof ClassFile.StackMapTableAttribute.UninitializedVariableInfo) : String.valueOf(op);
    }

    public void popReferenceOperand() {
        assert (this.peekObjectOperand() || this.peekNullOperand()) : this.peekOperand();
        this.popOperand();
    }

    public String popObjectOperand() {
        ClassFile.StackMapTableAttribute.VerificationTypeInfo vti = this.popOperand();
        assert (vti instanceof ClassFile.StackMapTableAttribute.ObjectVariableInfo) : vti;
        ClassFile.StackMapTableAttribute.ObjectVariableInfo ovi = (ClassFile.StackMapTableAttribute.ObjectVariableInfo)vti;
        short ccii = ovi.getConstantClassInfoIndex();
        ClassFile.ConstantClassInfo cci = this.classFile.getConstantClassInfo(ccii);
        return Descriptor.fromInternalForm(cci.getName(this.classFile));
    }

    public ClassFile.StackMapTableAttribute.VerificationTypeInfo popObjectOrUninitializedOrUninitializedThisOperand() {
        ClassFile.StackMapTableAttribute.VerificationTypeInfo result = this.popOperand();
        assert (result instanceof ClassFile.StackMapTableAttribute.UninitializedVariableInfo || result instanceof ClassFile.StackMapTableAttribute.ObjectVariableInfo || result == ClassFile.StackMapTableAttribute.UNINITIALIZED_THIS_VARIABLE_INFO) : result;
        return result;
    }

    public ClassFile.StackMapTableAttribute.VerificationTypeInfo popIntOrLongOperand() {
        ClassFile.StackMapTableAttribute.VerificationTypeInfo result = this.popOperand();
        assert (result == ClassFile.StackMapTableAttribute.INTEGER_VARIABLE_INFO || result == ClassFile.StackMapTableAttribute.LONG_VARIABLE_INFO) : result;
        return result;
    }

    public static interface FixUp {
        public void fixUp();
    }

    private abstract class Relocatable {
        private Relocatable() {
        }

        public abstract void grow();

        public abstract void relocate();
    }

    public class LineNumberOffset
    extends Offset {
        private final short lineNumber;

        public LineNumberOffset(int offset, StackMap stackMap, short lineNumber) {
            this.lineNumber = lineNumber;
            this.offset = offset;
            this.setStackMap(stackMap);
        }
    }

    public class Inserter
    extends Offset {
        @Nullable
        private Inserter nextInserter;
    }

    private static class ExceptionTableEntry {
        final Offset startPc;
        final Offset endPc;
        final Offset handlerPc;
        final short catchType;

        ExceptionTableEntry(Offset startPc, Offset endPc, Offset handlerPc, short catchType) {
            this.startPc = startPc;
            this.endPc = endPc;
            this.handlerPc = handlerPc;
            this.catchType = catchType;
        }
    }

    public class Offset {
        int offset = -1;
        @Nullable
        Offset prev;
        @Nullable
        Offset next;
        static final int UNSET = -1;
        @Nullable
        private StackMap stackMap;

        public void set() {
            this.setOffset();
            this.setStackMap();
            Inserter ci = CodeContext.this.currentInserter;
            Offset cip = ci.prev;
            assert (cip != null);
            this.prev = cip;
            this.next = ci;
            cip.next = this;
            ci.prev = this;
        }

        void setStackMap() {
            Inserter ci = CodeContext.this.currentInserter;
            ci.stackMap = this.stackMap = CodeContext.mergeStackMaps(ci.stackMap, this.stackMap);
        }

        public void setOffset() {
            Inserter ci = CodeContext.this.currentInserter;
            if (this.offset != -1) {
                throw new InternalCompilerException("Offset already set");
            }
            this.offset = ci.offset;
        }

        public StackMap getStackMap() {
            return this.stackMap;
        }

        public void setStackMap(StackMap stackMap) {
            this.stackMap = stackMap;
        }

        public final CodeContext getCodeContext() {
            return CodeContext.this;
        }

        public String toString() {
            return CodeContext.this.classFile.getThisClassName() + ": " + this.offset;
        }
    }

    private class OffsetBranch
    extends Relocatable {
        private final Offset where;
        private final Offset source;
        private final Offset destination;

        OffsetBranch(Offset where, Offset source, Offset destination) {
            this.where = where;
            this.source = source;
            this.destination = destination;
        }

        @Override
        public void grow() {
        }

        @Override
        public void relocate() {
            if (this.source.offset == -1 || this.destination.offset == -1) {
                throw new InternalCompilerException("Cannot relocate offset branch to unset destination offset");
            }
            int offset = this.destination.offset - this.source.offset;
            byte[] ba = new byte[]{(byte)(offset >> 24), (byte)(offset >> 16), (byte)(offset >> 8), (byte)offset};
            System.arraycopy(ba, 0, CodeContext.this.code, this.where.offset, 4);
        }
    }

    private final class FourByteOffset
    extends Offset {
        private FourByteOffset() {
        }
    }

    private class Branch
    extends Relocatable {
        private boolean expanded;
        private final int opcode;
        private final Inserter source;
        private final Offset destination;

        Branch(int opcode, Offset destination) {
            this.opcode = opcode;
            this.source = CodeContext.this.newInserter();
            this.destination = destination;
            this.expanded = opcode == 201 || opcode == 200;
        }

        @Override
        public void grow() {
            if (this.destination.offset == -1) {
                throw new InternalCompilerException("Cannot relocate branch to unset destination offset");
            }
            int offset = this.destination.offset - this.source.offset;
            int opcodeJsr = 168;
            if (!(this.expanded || offset <= Short.MAX_VALUE && offset >= Short.MIN_VALUE)) {
                int pos = this.source.offset;
                CodeContext.this.pushInserter(this.source);
                CodeContext.this.makeSpace(this.opcode == 167 || this.opcode == 168 ? 2 : 5);
                CodeContext.this.popInserter();
                this.source.offset = pos;
                this.expanded = true;
            }
        }

        @Override
        public void relocate() {
            if (this.destination.offset == -1) {
                throw new InternalCompilerException("Cannot relocate branch to unset destination offset");
            }
            int offset = this.destination.offset - this.source.offset;
            int opcodeJsr = 168;
            byte[] ba = !this.expanded ? new byte[]{(byte)this.opcode, (byte)(offset >> 8), (byte)offset} : (this.opcode == 167 || this.opcode == 168 ? new byte[]{(byte)(this.opcode + 33), (byte)(offset >> 24), (byte)(offset >> 16), (byte)(offset >> 8), (byte)offset} : new byte[]{(byte)CodeContext.invertBranchOpcode(this.opcode), 0, 8, -56, (byte)((offset -= 3) >> 24), (byte)(offset >> 16), (byte)(offset >> 8), (byte)offset});
            System.arraycopy(ba, 0, CodeContext.this.code, this.source.offset, ba.length);
        }
    }

    static class LocalScope {
        @Nullable
        final LocalScope parent;
        final short startingLocalVariableSlot;
        final List<Java.LocalVariableSlot> localVars = new ArrayList<Java.LocalVariableSlot>();
        final StackMap startingStackMap;

        LocalScope(@Nullable LocalScope parent, short startingLocalSlot, StackMap startingStackMap) {
            this.parent = parent;
            this.startingLocalVariableSlot = startingLocalSlot;
            this.startingStackMap = startingStackMap;
        }
    }
}

