/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.index.metadata;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.pinot.segment.spi.ColumnMetadata;
import org.apache.pinot.segment.spi.SegmentMetadata;
import org.apache.pinot.segment.spi.creator.SegmentVersion;
import org.apache.pinot.segment.spi.index.metadata.ColumnMetadataImpl;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2Constants;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2Metadata;
import org.apache.pinot.segment.spi.store.ColumnIndexType;
import org.apache.pinot.segment.spi.store.ColumnIndexUtils;
import org.apache.pinot.segment.spi.store.SegmentDirectoryPaths;
import org.apache.pinot.segment.spi.utils.SegmentMetadataUtils;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.env.CommonsConfigurationUtils;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.TimeUtils;
import org.apache.pinot.spi.utils.TimestampIndexUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;
import org.joda.time.DateTimeZone;
import org.joda.time.Duration;
import org.joda.time.Interval;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentMetadataImpl
implements SegmentMetadata {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentMetadataImpl.class);
    private final File _indexDir;
    private final Map<String, ColumnMetadata> _columnMetadataMap;
    private String _segmentName;
    private final Schema _schema;
    private long _crc = Long.MIN_VALUE;
    private long _creationTime = Long.MIN_VALUE;
    private String _timeColumn;
    private TimeUnit _timeUnit;
    private Duration _timeGranularity;
    private long _segmentStartTime = Long.MAX_VALUE;
    private long _segmentEndTime = Long.MIN_VALUE;
    private Interval _timeInterval;
    private SegmentVersion _segmentVersion;
    private List<StarTreeV2Metadata> _starTreeV2MetadataList;
    private String _creatorName;
    private int _totalDocs;
    private final Map<String, String> _customMap = new HashMap<String, String>();
    private String _startOffset;
    private String _endOffset;
    @Deprecated
    private String _rawTableName;

    public SegmentMetadataImpl(InputStream metadataPropertiesInputStream, InputStream creationMetaInputStream) throws IOException {
        this._indexDir = null;
        this._columnMetadataMap = new HashMap<String, ColumnMetadata>();
        this._schema = new Schema();
        PropertiesConfiguration segmentMetadataPropertiesConfiguration = CommonsConfigurationUtils.fromInputStream((InputStream)metadataPropertiesInputStream);
        this.init(segmentMetadataPropertiesConfiguration);
        this.setTimeInfo(segmentMetadataPropertiesConfiguration);
        this._totalDocs = segmentMetadataPropertiesConfiguration.getInt("segment.total.docs");
        this.loadCreationMeta(creationMetaInputStream);
    }

    public SegmentMetadataImpl(File indexDir) throws IOException {
        this._indexDir = indexDir;
        this._columnMetadataMap = new HashMap<String, ColumnMetadata>();
        this._schema = new Schema();
        PropertiesConfiguration segmentMetadataPropertiesConfiguration = SegmentMetadataUtils.getPropertiesConfiguration(indexDir);
        this.init(segmentMetadataPropertiesConfiguration);
        this.setTimeInfo(segmentMetadataPropertiesConfiguration);
        this._totalDocs = segmentMetadataPropertiesConfiguration.getInt("segment.total.docs");
        File creationMetaFile = SegmentDirectoryPaths.findCreationMetaFile(indexDir);
        if (creationMetaFile != null) {
            this.loadCreationMeta(creationMetaFile);
        }
    }

    public SegmentMetadataImpl(String rawTableName, String segmentName, Schema schema, long creationTime) {
        this._indexDir = null;
        this._columnMetadataMap = null;
        this._rawTableName = rawTableName;
        this._segmentName = segmentName;
        this._schema = schema;
        this._creationTime = creationTime;
    }

    private void setTimeInfo(PropertiesConfiguration segmentMetadataPropertiesConfiguration) {
        this._timeColumn = segmentMetadataPropertiesConfiguration.getString("segment.time.column.name");
        if (segmentMetadataPropertiesConfiguration.containsKey("segment.start.time") && segmentMetadataPropertiesConfiguration.containsKey("segment.end.time") && segmentMetadataPropertiesConfiguration.containsKey("segment.time.unit")) {
            try {
                this._timeUnit = TimeUtils.timeUnitFromString((String)segmentMetadataPropertiesConfiguration.getString("segment.time.unit"));
                assert (this._timeUnit != null);
                this._timeGranularity = new Duration(this._timeUnit.toMillis(1L));
                String startTimeString = segmentMetadataPropertiesConfiguration.getString("segment.start.time");
                String endTimeString = segmentMetadataPropertiesConfiguration.getString("segment.end.time");
                this._segmentStartTime = Long.parseLong(startTimeString);
                this._segmentEndTime = Long.parseLong(endTimeString);
                this._timeInterval = new Interval(this._timeUnit.toMillis(this._segmentStartTime), this._timeUnit.toMillis(this._segmentEndTime), DateTimeZone.UTC);
            }
            catch (Exception e) {
                LOGGER.warn("Caught exception while setting time interval and granularity", (Throwable)e);
            }
        }
    }

    private void loadCreationMeta(File crcFile) throws IOException {
        if (crcFile.exists()) {
            DataInputStream ds = new DataInputStream(new FileInputStream(crcFile));
            this._crc = ds.readLong();
            this._creationTime = ds.readLong();
            ds.close();
        }
    }

    private void loadCreationMeta(InputStream crcFileInputStream) throws IOException {
        try (DataInputStream ds = new DataInputStream(crcFileInputStream);){
            this._crc = ds.readLong();
            this._creationTime = ds.readLong();
        }
    }

    private void init(PropertiesConfiguration segmentMetadataPropertiesConfiguration) {
        int starTreeV2Count;
        File indexMapFile;
        if (segmentMetadataPropertiesConfiguration.containsKey("creator.version")) {
            this._creatorName = segmentMetadataPropertiesConfiguration.getString("creator.version");
        }
        String versionString = segmentMetadataPropertiesConfiguration.getString("segment.index.version", SegmentVersion.v1.toString());
        this._segmentVersion = SegmentVersion.valueOf(versionString);
        HashSet<String> physicalColumns = new HashSet<String>();
        SegmentMetadataImpl.addPhysicalColumns(segmentMetadataPropertiesConfiguration.getList("segment.dimension.column.names"), physicalColumns);
        SegmentMetadataImpl.addPhysicalColumns(segmentMetadataPropertiesConfiguration.getList("segment.metric.column.names"), physicalColumns);
        SegmentMetadataImpl.addPhysicalColumns(segmentMetadataPropertiesConfiguration.getList("segment.time.column.name"), physicalColumns);
        SegmentMetadataImpl.addPhysicalColumns(segmentMetadataPropertiesConfiguration.getList("segment.datetime.column.names"), physicalColumns);
        String tableName = segmentMetadataPropertiesConfiguration.getString("segment.table.name");
        if (tableName != null) {
            this._rawTableName = TableNameBuilder.extractRawTableName((String)tableName);
        }
        this._segmentName = segmentMetadataPropertiesConfiguration.getString("segment.name");
        for (String column : physicalColumns) {
            ColumnMetadataImpl columnMetadata = ColumnMetadataImpl.fromPropertiesConfiguration(column, segmentMetadataPropertiesConfiguration);
            this._columnMetadataMap.put(column, columnMetadata);
            this._schema.addField(columnMetadata.getFieldSpec());
        }
        if (this._segmentVersion == SegmentVersion.v3 && (indexMapFile = new File(this._indexDir, "v3" + File.separator + "index_map")).exists()) {
            PropertiesConfiguration mapConfig = CommonsConfigurationUtils.fromFile((File)indexMapFile);
            for (String key : CommonsConfigurationUtils.getKeys((Configuration)mapConfig)) {
                try {
                    String[] parsedKeys = ColumnIndexUtils.parseIndexMapKeys(key, this._indexDir.getPath());
                    if (!parsedKeys[2].equals("size")) continue;
                    ColumnIndexType columnIndexType = ColumnIndexType.getValue(parsedKeys[1]);
                    this._columnMetadataMap.get(parsedKeys[0]).getIndexSizeMap().put(columnIndexType, mapConfig.getLong(key));
                }
                catch (Exception e) {
                    LOGGER.debug("Unable to load index metadata in {} for {}!", new Object[]{indexMapFile, key, e});
                }
            }
        }
        if ((starTreeV2Count = segmentMetadataPropertiesConfiguration.getInt("startree.v2.count", 0)) > 0) {
            this._starTreeV2MetadataList = new ArrayList<StarTreeV2Metadata>(starTreeV2Count);
            for (int i = 0; i < starTreeV2Count; ++i) {
                this._starTreeV2MetadataList.add(new StarTreeV2Metadata(segmentMetadataPropertiesConfiguration.subset(StarTreeV2Constants.MetadataKey.getStarTreePrefix(i))));
            }
        }
        this._startOffset = segmentMetadataPropertiesConfiguration.getString("segment.realtime.startOffset", null);
        this._endOffset = segmentMetadataPropertiesConfiguration.getString("segment.realtime.endOffset", null);
        SegmentMetadataImpl.setCustomConfigs((Configuration)segmentMetadataPropertiesConfiguration, this._customMap);
    }

    private static void setCustomConfigs(Configuration segmentMetadataPropertiesConfiguration, Map<String, String> customConfigsMap) {
        Configuration customConfigs = segmentMetadataPropertiesConfiguration.subset("custom");
        Iterator customKeysIter = customConfigs.getKeys();
        while (customKeysIter.hasNext()) {
            String key = (String)customKeysIter.next();
            customConfigsMap.put(key, customConfigs.getString(key));
        }
    }

    private static void addPhysicalColumns(List src, Collection<String> dest) {
        for (Object o : src) {
            String column = o.toString();
            if (column.isEmpty() || dest.contains(column) || column.charAt(0) == '$' && !TimestampIndexUtils.isValidColumnWithGranularity((String)column)) continue;
            dest.add(column);
        }
    }

    @Override
    public String getTableName() {
        return this._rawTableName;
    }

    @Override
    public String getName() {
        return this._segmentName;
    }

    @Override
    public String getTimeColumn() {
        return this._timeColumn;
    }

    @Override
    public long getStartTime() {
        return this._segmentStartTime;
    }

    @Override
    public long getEndTime() {
        return this._segmentEndTime;
    }

    @Override
    public TimeUnit getTimeUnit() {
        return this._timeUnit;
    }

    @Override
    public Duration getTimeGranularity() {
        return this._timeGranularity;
    }

    @Override
    public Interval getTimeInterval() {
        return this._timeInterval;
    }

    @Override
    public String getCrc() {
        return String.valueOf(this._crc);
    }

    @Override
    public SegmentVersion getVersion() {
        return this._segmentVersion;
    }

    @Override
    public Schema getSchema() {
        return this._schema;
    }

    @Override
    public int getTotalDocs() {
        return this._totalDocs;
    }

    @Override
    public File getIndexDir() {
        return this._indexDir;
    }

    @Override
    @Nullable
    public String getCreatorName() {
        return this._creatorName;
    }

    @Override
    public long getIndexCreationTime() {
        return this._creationTime;
    }

    @Override
    public long getLastIndexedTimestamp() {
        return Long.MIN_VALUE;
    }

    @Override
    public long getLatestIngestionTimestamp() {
        return Long.MIN_VALUE;
    }

    @Override
    public List<StarTreeV2Metadata> getStarTreeV2MetadataList() {
        return this._starTreeV2MetadataList;
    }

    @Override
    public Map<String, String> getCustomMap() {
        return this._customMap;
    }

    @Override
    public String getStartOffset() {
        return this._startOffset;
    }

    @Override
    public String getEndOffset() {
        return this._endOffset;
    }

    @Override
    public Map<String, ColumnMetadata> getColumnMetadataMap() {
        return this._columnMetadataMap;
    }

    @Override
    public void removeColumn(String column) {
        Preconditions.checkState((!column.equals(this._timeColumn) ? 1 : 0) != 0, (String)"Cannot remove time column: %s", (Object)this._timeColumn);
        this._columnMetadataMap.remove(column);
        this._schema.removeField(column);
    }

    @Override
    public JsonNode toJson(@Nullable Set<String> columnFilter) {
        ObjectNode segmentMetadata = JsonUtils.newObjectNode();
        segmentMetadata.put("segmentName", this._segmentName);
        segmentMetadata.put("schemaName", this._schema != null ? this._schema.getSchemaName() : null);
        segmentMetadata.put("crc", this._crc);
        segmentMetadata.put("creationTimeMillis", this._creationTime);
        TimeZone timeZone = TimeZone.getTimeZone("UTC");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss:SSS' UTC'");
        dateFormat.setTimeZone(timeZone);
        String creationTimeStr = this._creationTime != Long.MIN_VALUE ? dateFormat.format(new Date(this._creationTime)) : null;
        segmentMetadata.put("creationTimeReadable", creationTimeStr);
        segmentMetadata.put("timeColumn", this._timeColumn);
        segmentMetadata.put("timeUnit", this._timeUnit != null ? this._timeUnit.name() : null);
        segmentMetadata.put("timeGranularitySec", this._timeGranularity != null ? Long.valueOf(this._timeGranularity.getStandardSeconds()) : null);
        if (this._timeInterval == null) {
            segmentMetadata.set("startTimeMillis", null);
            segmentMetadata.set("startTimeReadable", null);
            segmentMetadata.set("endTimeMillis", null);
            segmentMetadata.set("endTimeReadable", null);
        } else {
            segmentMetadata.put("startTimeMillis", this._timeInterval.getStartMillis());
            segmentMetadata.put("startTimeReadable", this._timeInterval.getStart().toString());
            segmentMetadata.put("endTimeMillis", this._timeInterval.getEndMillis());
            segmentMetadata.put("endTimeReadable", this._timeInterval.getEnd().toString());
        }
        segmentMetadata.put("segmentVersion", this._segmentVersion != null ? this._segmentVersion.toString() : null);
        segmentMetadata.put("creatorName", this._creatorName);
        segmentMetadata.put("totalDocs", this._totalDocs);
        ObjectNode customConfigs = JsonUtils.newObjectNode();
        for (String key : this._customMap.keySet()) {
            customConfigs.put(key, this._customMap.get(key));
        }
        segmentMetadata.set("custom", (JsonNode)customConfigs);
        segmentMetadata.put("startOffset", this._startOffset);
        segmentMetadata.put("endOffset", this._endOffset);
        if (this._columnMetadataMap != null) {
            ArrayNode columnsMetadata = JsonUtils.newArrayNode();
            for (Map.Entry<String, ColumnMetadata> entry : this._columnMetadataMap.entrySet()) {
                if (columnFilter != null && !columnFilter.contains(entry.getKey())) continue;
                columnsMetadata.add(JsonUtils.objectToJsonNode((Object)entry.getValue()));
            }
            segmentMetadata.set("columns", (JsonNode)columnsMetadata);
        }
        return segmentMetadata;
    }

    public String toString() {
        return this.toJson(null).toString();
    }
}

