/*
 * Decompiled with CFR 0.152.
 */
package com.esri.core.geometry;

import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.OperatorExportToJson;
import com.esri.core.geometry.SpatialReference;
import java.io.Serializable;

public class MapGeometry
implements Serializable {
    private static final long serialVersionUID = 1L;
    Geometry m_geometry = null;
    SpatialReference sr = null;

    public MapGeometry(Geometry g, SpatialReference _sr) {
        this.m_geometry = g;
        this.sr = _sr;
    }

    public Geometry getGeometry() {
        return this.m_geometry;
    }

    public void setGeometry(Geometry geometry) {
        this.m_geometry = geometry;
    }

    public void setSpatialReference(SpatialReference sr) {
        this.sr = sr;
    }

    public SpatialReference getSpatialReference() {
        return this.sr;
    }

    public String toString() {
        String snippet = OperatorExportToJson.local().execute(this.getSpatialReference(), this.getGeometry());
        if (snippet.length() > 200) {
            return String.valueOf(snippet.substring(0, 197)) + "... (" + snippet.length() + " characters)";
        }
        return snippet;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != this.getClass()) {
            return false;
        }
        MapGeometry omg = (MapGeometry)other;
        SpatialReference sr = this.getSpatialReference();
        Geometry g = this.getGeometry();
        SpatialReference osr = omg.getSpatialReference();
        Geometry og = omg.getGeometry();
        if (!(sr == osr || sr != null && sr.equals(osr))) {
            return false;
        }
        return g == og || g != null && g.equals(og);
    }

    public long estimateMemorySize() {
        long sz = 24L;
        if (this.m_geometry != null) {
            sz += this.m_geometry.estimateMemorySize();
        }
        return sz;
    }

    public int hashCode() {
        SpatialReference sr = this.getSpatialReference();
        Geometry g = this.getGeometry();
        int hc = 43219218;
        if (sr != null) {
            hc ^= sr.hashCode();
        }
        if (g != null) {
            hc ^= g.hashCode();
        }
        return hc;
    }
}

