/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.pinot.spi.utils.Pairs;

public class SortedRangeIntersection {
    private SortedRangeIntersection() {
    }

    public static List<Pairs.IntPair> intersectSortedRangeSets(List<List<Pairs.IntPair>> sortedRangeSetList) {
        if (sortedRangeSetList == null || sortedRangeSetList.isEmpty()) {
            return Collections.emptyList();
        }
        if (sortedRangeSetList.size() == 1) {
            return sortedRangeSetList.get(0);
        }
        for (List<Pairs.IntPair> rangeSet : sortedRangeSetList) {
            if (!rangeSet.isEmpty()) continue;
            return Collections.emptyList();
        }
        int[] currentRangeSetIndex = new int[sortedRangeSetList.size()];
        Arrays.fill(currentRangeSetIndex, 0);
        int maxHead = -1;
        int maxHeadIndex = -1;
        boolean reachedEnd = false;
        ArrayList<Pairs.IntPair> result = new ArrayList<Pairs.IntPair>();
        block1: while (!reachedEnd) {
            Pairs.IntPair pair;
            int i;
            for (int i2 = 0; i2 < sortedRangeSetList.size(); ++i2) {
                int head = sortedRangeSetList.get(i2).get(currentRangeSetIndex[i2]).getLeft();
                if (head <= maxHead) continue;
                maxHead = head;
                maxHeadIndex = i2;
            }
            int j = -1;
            while (j++ < sortedRangeSetList.size() - 1) {
                if (j == maxHeadIndex) continue;
                boolean found = false;
                while (!found && currentRangeSetIndex[j] < sortedRangeSetList.get(j).size()) {
                    Pairs.IntPair range = sortedRangeSetList.get(j).get(currentRangeSetIndex[j]);
                    if (maxHead >= range.getLeft() && maxHead <= range.getRight()) {
                        found = true;
                        break;
                    }
                    if (range.getLeft() > maxHead) {
                        maxHead = range.getLeft();
                        maxHeadIndex = j;
                        j = -1;
                        break;
                    }
                    currentRangeSetIndex[j] = currentRangeSetIndex[j] + 1;
                }
                if (j == -1 || found) continue;
                reachedEnd = true;
                break;
            }
            if (reachedEnd) break;
            Pairs.IntPair intPair = sortedRangeSetList.get(0).get(currentRangeSetIndex[0]);
            Pairs.IntPair intersection = Pairs.intPair((int)intPair.getLeft(), (int)intPair.getRight());
            for (i = 1; i < sortedRangeSetList.size(); ++i) {
                pair = sortedRangeSetList.get(i).get(currentRangeSetIndex[i]);
                int start = Math.max(intersection.getLeft(), pair.getLeft());
                int end = Math.min(intersection.getRight(), pair.getRight());
                intersection.setLeft(start);
                intersection.setRight(end);
            }
            if (!result.isEmpty()) {
                Pairs.IntPair prevIntersection = (Pairs.IntPair)result.get(result.size() - 1);
                if (intersection.getLeft() == prevIntersection.getRight() + 1) {
                    prevIntersection.setRight(intersection.getRight());
                } else {
                    result.add(intersection);
                }
            } else {
                result.add(intersection);
            }
            for (i = 0; i < sortedRangeSetList.size(); ++i) {
                pair = sortedRangeSetList.get(i).get(currentRangeSetIndex[i]);
                if (pair.getRight() != intersection.getRight()) continue;
                currentRangeSetIndex[i] = currentRangeSetIndex[i] + 1;
                if (currentRangeSetIndex[i] != sortedRangeSetList.get(i).size()) continue;
                reachedEnd = true;
                continue block1;
            }
        }
        return result;
    }
}

