/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.transport;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import org.apache.commons.lang.StringUtils;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.common.utils.config.InstanceUtils;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.utils.CommonConstants;

public class ServerInstance {
    private static final char HOSTNAME_PORT_DELIMITER = '_';
    private static final int INVALID_PORT = -1;
    private final String _instanceId;
    private final String _hostname;
    private final int _port;
    private final int _grpcPort;
    private final int _nettyTlsPort;
    private final int _queryServicePort;
    private final int _queryMailboxPort;
    private final String _adminEndpoint;

    public ServerInstance(InstanceConfig instanceConfig) {
        this._instanceId = instanceConfig.getInstanceName();
        String hostname = instanceConfig.getHostName();
        if (hostname != null) {
            this._hostname = hostname.startsWith("Server_") ? hostname.substring(CommonConstants.Helix.SERVER_INSTANCE_PREFIX_LENGTH) : hostname;
            this._port = Integer.parseInt(instanceConfig.getPort());
        } else {
            String instanceName = instanceConfig.getInstanceName();
            if (instanceName.startsWith("Server_")) {
                instanceName = instanceName.substring(CommonConstants.Helix.SERVER_INSTANCE_PREFIX_LENGTH);
            }
            String[] hostnameAndPort = StringUtils.split((String)instanceName, (char)'_');
            this._hostname = hostnameAndPort[0];
            this._port = Integer.parseInt(hostnameAndPort[1]);
        }
        this._grpcPort = instanceConfig.getRecord().getIntField("grpcPort", -1);
        this._nettyTlsPort = instanceConfig.getRecord().getIntField("nettyTlsPort", -1);
        this._queryServicePort = instanceConfig.getRecord().getIntField("queryServerPort", -1);
        this._queryMailboxPort = instanceConfig.getRecord().getIntField("queryMailboxPort", -1);
        this._adminEndpoint = InstanceUtils.getServerAdminEndpoint((InstanceConfig)instanceConfig, (String)this._hostname, (String)"http");
    }

    @VisibleForTesting
    ServerInstance(String hostname, int port) {
        this._instanceId = "Server_" + hostname + "_" + port;
        this._hostname = hostname;
        this._port = port;
        this._grpcPort = -1;
        this._nettyTlsPort = -1;
        this._queryServicePort = -1;
        this._queryMailboxPort = -1;
        this._adminEndpoint = null;
    }

    public String getInstanceId() {
        return this._instanceId;
    }

    public String getHostname() {
        return this._hostname;
    }

    public int getPort() {
        return this._port;
    }

    public String getAdminEndpoint() {
        return this._adminEndpoint;
    }

    public int getGrpcPort() {
        return this._grpcPort;
    }

    public int getQueryServicePort() {
        return this._queryServicePort;
    }

    public int getQueryMailboxPort() {
        return this._queryMailboxPort;
    }

    public int getNettyTlsPort() {
        return this._nettyTlsPort;
    }

    @Deprecated
    public ServerRoutingInstance toServerRoutingInstance(TableType tableType, boolean preferNettyTls) {
        if (preferNettyTls && this._nettyTlsPort > 0) {
            return new ServerRoutingInstance(this._instanceId, this._hostname, this._nettyTlsPort, tableType, true);
        }
        return new ServerRoutingInstance(this._instanceId, this._hostname, this._port, tableType);
    }

    public ServerRoutingInstance toServerRoutingInstance(TableType tableType, RoutingType routingType) {
        switch (routingType) {
            case NETTY: {
                Preconditions.checkState((this._port > 0 ? 1 : 0) != 0, (String)"Netty port is not configured for server: %s", (Object)this._instanceId);
                return new ServerRoutingInstance(this._instanceId, this._hostname, this._port, tableType);
            }
            case GRPC: {
                Preconditions.checkState((this._grpcPort > 0 ? 1 : 0) != 0, (String)"GRPC port is not configured for server: %s", (Object)this._instanceId);
                return new ServerRoutingInstance(this._instanceId, this._hostname, this._grpcPort, tableType);
            }
            case NETTY_TLS: {
                Preconditions.checkState((this._nettyTlsPort > 0 ? 1 : 0) != 0, (String)"Netty TLS port is not configured for server: %s", (Object)this._instanceId);
                return new ServerRoutingInstance(this._instanceId, this._hostname, this._nettyTlsPort, tableType, true);
            }
        }
        throw new IllegalStateException("Unsupported routing type: " + routingType);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ServerInstance)) {
            return false;
        }
        ServerInstance that = (ServerInstance)o;
        return this._instanceId.equals(that._instanceId);
    }

    public int hashCode() {
        return this._instanceId.hashCode();
    }

    public String toString() {
        return this._instanceId;
    }

    public static enum RoutingType {
        NETTY,
        GRPC,
        NETTY_TLS;

    }
}

