/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.transformer;

import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.core.segment.processing.transformer.RecordTransformer;
import org.apache.pinot.segment.local.function.FunctionEvaluator;
import org.apache.pinot.segment.local.function.FunctionEvaluatorFactory;
import org.apache.pinot.spi.data.readers.GenericRow;

public class TransformFunctionRecordTransformer
implements RecordTransformer {
    private final Map<String, FunctionEvaluator> _functionEvaluatorMap = new HashMap<String, FunctionEvaluator>();

    public TransformFunctionRecordTransformer(Map<String, String> transformFunctionMap) {
        transformFunctionMap.forEach((key, value) -> this._functionEvaluatorMap.put((String)key, FunctionEvaluatorFactory.getExpressionEvaluator((String)value)));
    }

    @Override
    public GenericRow transformRecord(GenericRow row) {
        for (Map.Entry<String, FunctionEvaluator> entry : this._functionEvaluatorMap.entrySet()) {
            Object result = entry.getValue().evaluate(row);
            row.putValue(entry.getKey(), result);
        }
        return row;
    }
}

