/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.utils.idset;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.pinot.core.query.utils.idset.IdSet;
import org.roaringbitmap.RoaringBitmap;

public class RoaringBitmapIdSet
implements IdSet {
    private final RoaringBitmap _bitmap;

    RoaringBitmapIdSet() {
        this._bitmap = new RoaringBitmap();
    }

    private RoaringBitmapIdSet(RoaringBitmap bitmap) {
        this._bitmap = bitmap;
    }

    RoaringBitmap getBitmap() {
        return this._bitmap;
    }

    @Override
    public IdSet.Type getType() {
        return IdSet.Type.ROARING_BITMAP;
    }

    @Override
    public void add(int id) {
        this._bitmap.add(id);
    }

    @Override
    public boolean contains(int id) {
        return this._bitmap.contains(id);
    }

    @Override
    public int getSerializedSizeInBytes() {
        return 1 + this._bitmap.serializedSizeInBytes();
    }

    @Override
    public byte[] toBytes() {
        int numBytes = 1 + this._bitmap.serializedSizeInBytes();
        byte[] bytes = new byte[numBytes];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.put(IdSet.Type.ROARING_BITMAP.getId());
        this._bitmap.serialize(byteBuffer);
        return bytes;
    }

    static RoaringBitmapIdSet fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
        RoaringBitmap roaringBitmap = new RoaringBitmap();
        roaringBitmap.deserialize(byteBuffer);
        return new RoaringBitmapIdSet(roaringBitmap);
    }

    public int hashCode() {
        return this._bitmap.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoaringBitmapIdSet)) {
            return false;
        }
        RoaringBitmapIdSet that = (RoaringBitmapIdSet)o;
        return this._bitmap.equals((Object)that._bitmap);
    }
}

