/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.scheduler.tokenbucket;

import com.google.common.base.Preconditions;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.pinot.core.query.scheduler.AbstractSchedulerGroup;
import org.apache.pinot.core.query.scheduler.SchedulerGroup;
import org.apache.pinot.core.query.scheduler.SchedulerGroupAccountant;
import org.apache.pinot.core.query.scheduler.fcfs.FCFSSchedulerGroup;

public class TokenSchedulerGroup
extends AbstractSchedulerGroup {
    private static final double ALPHA = 0.8;
    private final int _tokenLifetimeMs;
    private final int _numTokensPerMs;
    private int _availableTokens;
    private long _lastUpdateTimeMs;
    private long _lastTokenTimeMs;
    private final Lock _tokenLock = new ReentrantLock();

    TokenSchedulerGroup(String schedGroupName, int numTokensPerMs, int tokenLifetimeMs) {
        super(schedGroupName);
        Preconditions.checkArgument((numTokensPerMs > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((tokenLifetimeMs > 0 ? 1 : 0) != 0);
        this._numTokensPerMs = numTokensPerMs;
        this._tokenLifetimeMs = tokenLifetimeMs;
        this._lastUpdateTimeMs = this.currentTimeMillis();
        this._availableTokens = numTokensPerMs * tokenLifetimeMs;
        this._lastTokenTimeMs = this._lastUpdateTimeMs;
    }

    int getAvailableTokens() {
        return this.consumeTokens();
    }

    @Override
    public void incrementThreads() {
        this.consumeTokens();
        super.incrementThreads();
    }

    @Override
    public void decrementThreads() {
        this.consumeTokens();
        super.decrementThreads();
    }

    @Override
    public void startQuery() {
        this.consumeTokens();
        super.startQuery();
    }

    @Override
    public void endQuery() {
        this.consumeTokens();
        super.endQuery();
    }

    @Override
    public int compareTo(SchedulerGroupAccountant rhs) {
        int rightTokens;
        if (rhs == null) {
            return 1;
        }
        if (this == rhs) {
            return 0;
        }
        int leftTokens = this.getAvailableTokens();
        if (leftTokens > (rightTokens = ((TokenSchedulerGroup)rhs).getAvailableTokens())) {
            return 1;
        }
        if (leftTokens < rightTokens) {
            return -1;
        }
        return FCFSSchedulerGroup.compare(this, (SchedulerGroup)rhs);
    }

    public String toString() {
        return String.format(" {%s:[%d,%d,%d,%d,%d]},", this.name(), this.getAvailableTokens(), this.numPending(), this.numRunning(), this.getThreadsInUse(), this.totalReservedThreads());
    }

    private int consumeTokens() {
        try (TokenLockManager lm = new TokenLockManager(this._tokenLock);){
            long currentTimeMs = this.currentTimeMillis();
            int diffMs = (int)(currentTimeMs - this._lastUpdateTimeMs);
            if (diffMs <= 0) {
                int n = this._availableTokens;
                return n;
            }
            int threads = this._threadsInUse.get();
            long nextTokenTime = this._lastTokenTimeMs + (long)this._tokenLifetimeMs;
            if (nextTokenTime > currentTimeMs) {
                this._availableTokens -= diffMs * threads;
            } else {
                this._availableTokens = (int)((long)this._availableTokens - (nextTokenTime - this._lastUpdateTimeMs) * (long)threads);
                while (nextTokenTime <= currentTimeMs) {
                    this._availableTokens = (int)(0.8 * (double)this._tokenLifetimeMs * (double)this._numTokensPerMs + 0.19999999999999996 * (double)(this._availableTokens - this._tokenLifetimeMs * threads));
                    nextTokenTime += (long)this._tokenLifetimeMs;
                }
                this._lastTokenTimeMs = nextTokenTime - (long)this._tokenLifetimeMs;
                this._availableTokens = (int)((long)this._availableTokens - (currentTimeMs - this._lastTokenTimeMs) * (long)threads);
            }
            this._lastUpdateTimeMs = currentTimeMs;
            int n = this._availableTokens;
            return n;
        }
    }

    protected long currentTimeMillis() {
        return System.currentTimeMillis();
    }

    private class TokenLockManager
    implements AutoCloseable {
        private final Lock _lock;

        TokenLockManager(Lock lock) {
            this._lock = lock;
            this._lock.lock();
        }

        @Override
        public void close() {
            this._lock.unlock();
        }
    }
}

