/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.request.context;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.request.context.RequestContextUtils;
import org.apache.pinot.common.utils.config.QueryOptionsUtils;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionFactory;
import org.apache.pinot.core.util.MemoizedClassAssociation;

public class QueryContext {
    private final String _tableName;
    private final QueryContext _subquery;
    private final List<ExpressionContext> _selectExpressions;
    private final List<String> _aliasList;
    private final FilterContext _filter;
    private final List<ExpressionContext> _groupByExpressions;
    private final FilterContext _havingFilter;
    private final List<OrderByExpressionContext> _orderByExpressions;
    private final int _limit;
    private final int _offset;
    private final Map<String, String> _queryOptions;
    private final Map<ExpressionContext, ExpressionContext> _expressionOverrideHints;
    private final boolean _explain;
    private final Function<Class<?>, Map<?, ?>> _sharedValues = MemoizedClassAssociation.of(ConcurrentHashMap::new);
    private AggregationFunction[] _aggregationFunctions;
    private Map<FunctionContext, Integer> _aggregationFunctionIndexMap;
    private boolean _hasFilteredAggregations;
    private List<Pair<AggregationFunction, FilterContext>> _filteredAggregationFunctions;
    private Map<Pair<FunctionContext, FilterContext>, Integer> _filteredAggregationsIndexMap;
    private Set<String> _columns;
    private long _endTimeMs;
    private boolean _enablePrefetch;
    private boolean _skipUpsert;
    private boolean _skipStarTree;
    private boolean _skipScanFilterReorder;
    private int _maxExecutionThreads = -1;
    private int _maxInitialResultHolderCapacity = 10000;
    private int _numGroupsLimit = 100000;
    private int _minSegmentGroupTrimSize = -1;
    private int _minServerGroupTrimSize = 5000;
    private int _groupTrimThreshold = 1000000;
    private boolean _nullHandlingEnabled;
    private boolean _serverReturnFinalResult;

    private QueryContext(@Nullable String tableName, @Nullable QueryContext subquery, List<ExpressionContext> selectExpressions, List<String> aliasList, @Nullable FilterContext filter, @Nullable List<ExpressionContext> groupByExpressions, @Nullable FilterContext havingFilter, @Nullable List<OrderByExpressionContext> orderByExpressions, int limit, int offset, Map<String, String> queryOptions, @Nullable Map<ExpressionContext, ExpressionContext> expressionOverrideHints, boolean explain) {
        this._tableName = tableName;
        this._subquery = subquery;
        this._selectExpressions = selectExpressions;
        this._aliasList = Collections.unmodifiableList(aliasList);
        this._filter = filter;
        this._groupByExpressions = groupByExpressions;
        this._havingFilter = havingFilter;
        this._orderByExpressions = orderByExpressions;
        this._limit = limit;
        this._offset = offset;
        this._queryOptions = queryOptions;
        this._expressionOverrideHints = expressionOverrideHints;
        this._explain = explain;
    }

    public String getTableName() {
        return this._tableName;
    }

    @Nullable
    public QueryContext getSubquery() {
        return this._subquery;
    }

    public List<ExpressionContext> getSelectExpressions() {
        return this._selectExpressions;
    }

    public List<String> getAliasList() {
        return this._aliasList;
    }

    @Nullable
    public FilterContext getFilter() {
        return this._filter;
    }

    @Nullable
    public List<ExpressionContext> getGroupByExpressions() {
        return this._groupByExpressions;
    }

    @Nullable
    public FilterContext getHavingFilter() {
        return this._havingFilter;
    }

    @Nullable
    public List<OrderByExpressionContext> getOrderByExpressions() {
        return this._orderByExpressions;
    }

    public int getLimit() {
        return this._limit;
    }

    public int getOffset() {
        return this._offset;
    }

    public Map<String, String> getQueryOptions() {
        return this._queryOptions;
    }

    public Map<ExpressionContext, ExpressionContext> getExpressionOverrideHints() {
        return this._expressionOverrideHints;
    }

    public boolean isExplain() {
        return this._explain;
    }

    @Nullable
    public AggregationFunction[] getAggregationFunctions() {
        return this._aggregationFunctions;
    }

    @Nullable
    public List<Pair<AggregationFunction, FilterContext>> getFilteredAggregationFunctions() {
        return this._filteredAggregationFunctions;
    }

    public boolean isHasFilteredAggregations() {
        return this._hasFilteredAggregations;
    }

    @Nullable
    public Map<FunctionContext, Integer> getAggregationFunctionIndexMap() {
        return this._aggregationFunctionIndexMap;
    }

    @Nullable
    public Map<Pair<FunctionContext, FilterContext>, Integer> getFilteredAggregationsIndexMap() {
        return this._filteredAggregationsIndexMap;
    }

    public Set<String> getColumns() {
        return this._columns;
    }

    public long getEndTimeMs() {
        return this._endTimeMs;
    }

    public void setEndTimeMs(long endTimeMs) {
        this._endTimeMs = endTimeMs;
    }

    public boolean isEnablePrefetch() {
        return this._enablePrefetch;
    }

    public void setEnablePrefetch(boolean enablePrefetch) {
        this._enablePrefetch = enablePrefetch;
    }

    public boolean isSkipUpsert() {
        return this._skipUpsert;
    }

    public void setSkipUpsert(boolean skipUpsert) {
        this._skipUpsert = skipUpsert;
    }

    public boolean isSkipStarTree() {
        return this._skipStarTree;
    }

    public void setSkipStarTree(boolean skipStarTree) {
        this._skipStarTree = skipStarTree;
    }

    public boolean isSkipScanFilterReorder() {
        return this._skipScanFilterReorder;
    }

    public void setSkipScanFilterReorder(boolean skipScanFilterReorder) {
        this._skipScanFilterReorder = skipScanFilterReorder;
    }

    public int getMaxExecutionThreads() {
        return this._maxExecutionThreads;
    }

    public void setMaxExecutionThreads(int maxExecutionThreads) {
        this._maxExecutionThreads = maxExecutionThreads;
    }

    public int getMaxInitialResultHolderCapacity() {
        return this._maxInitialResultHolderCapacity;
    }

    public void setMaxInitialResultHolderCapacity(int maxInitialResultHolderCapacity) {
        this._maxInitialResultHolderCapacity = maxInitialResultHolderCapacity;
    }

    public int getNumGroupsLimit() {
        return this._numGroupsLimit;
    }

    public void setNumGroupsLimit(int numGroupsLimit) {
        this._numGroupsLimit = numGroupsLimit;
    }

    public int getMinSegmentGroupTrimSize() {
        return this._minSegmentGroupTrimSize;
    }

    public void setMinSegmentGroupTrimSize(int minSegmentGroupTrimSize) {
        this._minSegmentGroupTrimSize = minSegmentGroupTrimSize;
    }

    public int getMinServerGroupTrimSize() {
        return this._minServerGroupTrimSize;
    }

    public void setMinServerGroupTrimSize(int minServerGroupTrimSize) {
        this._minServerGroupTrimSize = minServerGroupTrimSize;
    }

    public int getGroupTrimThreshold() {
        return this._groupTrimThreshold;
    }

    public void setGroupTrimThreshold(int groupTrimThreshold) {
        this._groupTrimThreshold = groupTrimThreshold;
    }

    public boolean isNullHandlingEnabled() {
        return this._nullHandlingEnabled;
    }

    public void setNullHandlingEnabled(boolean nullHandlingEnabled) {
        this._nullHandlingEnabled = nullHandlingEnabled;
    }

    public boolean isServerReturnFinalResult() {
        return this._serverReturnFinalResult;
    }

    public void setServerReturnFinalResult(boolean serverReturnFinalResult) {
        this._serverReturnFinalResult = serverReturnFinalResult;
    }

    public <K, V> V getOrComputeSharedValue(Class<V> type, K key, Function<K, V> mapper) {
        return ((ConcurrentHashMap)this._sharedValues.apply(type)).computeIfAbsent(key, mapper);
    }

    public String toString() {
        return "QueryContext{_tableName='" + this._tableName + "', _subquery=" + this._subquery + ", _selectExpressions=" + this._selectExpressions + ", _aliasList=" + this._aliasList + ", _filter=" + this._filter + ", _groupByExpressions=" + this._groupByExpressions + ", _havingFilter=" + this._havingFilter + ", _orderByExpressions=" + this._orderByExpressions + ", _limit=" + this._limit + ", _offset=" + this._offset + ", _queryOptions=" + this._queryOptions + ", _expressionOverrideHints=" + this._expressionOverrideHints + ", _explain=" + this._explain + "}";
    }

    public static class Builder {
        private String _tableName;
        private QueryContext _subquery;
        private List<ExpressionContext> _selectExpressions;
        private List<String> _aliasList;
        private FilterContext _filter;
        private List<ExpressionContext> _groupByExpressions;
        private FilterContext _havingFilter;
        private List<OrderByExpressionContext> _orderByExpressions;
        private int _limit;
        private int _offset;
        private Map<String, String> _queryOptions;
        private Map<String, String> _debugOptions;
        private Map<ExpressionContext, ExpressionContext> _expressionOverrideHints;
        private boolean _explain;

        public Builder setTableName(String tableName) {
            this._tableName = tableName;
            return this;
        }

        public Builder setSubquery(QueryContext subquery) {
            this._subquery = subquery;
            return this;
        }

        public Builder setSelectExpressions(List<ExpressionContext> selectExpressions) {
            this._selectExpressions = selectExpressions;
            return this;
        }

        public Builder setAliasList(List<String> aliasList) {
            this._aliasList = aliasList;
            return this;
        }

        public Builder setFilter(FilterContext filter) {
            this._filter = filter;
            return this;
        }

        public Builder setGroupByExpressions(List<ExpressionContext> groupByExpressions) {
            this._groupByExpressions = groupByExpressions;
            return this;
        }

        public Builder setHavingFilter(FilterContext havingFilter) {
            this._havingFilter = havingFilter;
            return this;
        }

        public Builder setOrderByExpressions(List<OrderByExpressionContext> orderByExpressions) {
            this._orderByExpressions = orderByExpressions;
            return this;
        }

        public Builder setLimit(int limit) {
            this._limit = limit;
            return this;
        }

        public Builder setOffset(int offset) {
            this._offset = offset;
            return this;
        }

        public Builder setQueryOptions(Map<String, String> queryOptions) {
            this._queryOptions = queryOptions;
            return this;
        }

        public Builder setExpressionOverrideHints(Map<ExpressionContext, ExpressionContext> expressionOverrideHints) {
            this._expressionOverrideHints = expressionOverrideHints;
            return this;
        }

        public Builder setExplain(boolean explain) {
            this._explain = explain;
            return this;
        }

        public QueryContext build() {
            if (this._queryOptions == null) {
                this._queryOptions = Collections.emptyMap();
            }
            QueryContext queryContext = new QueryContext(this._tableName, this._subquery, this._selectExpressions, this._aliasList, this._filter, this._groupByExpressions, this._havingFilter, this._orderByExpressions, this._limit, this._offset, this._queryOptions, this._expressionOverrideHints, this._explain);
            queryContext.setNullHandlingEnabled(QueryOptionsUtils.isNullHandlingEnabled(this._queryOptions));
            queryContext.setServerReturnFinalResult(QueryOptionsUtils.isServerReturnFinalResult(this._queryOptions));
            this.generateAggregationFunctions(queryContext);
            this.extractColumns(queryContext);
            return queryContext;
        }

        private void generateAggregationFunctions(QueryContext queryContext) {
            AggregationFunction aggregationFunction;
            int functionIndex;
            FilterContext filter;
            FunctionContext aggregation;
            ArrayList<Pair<AggregationFunction, FilterContext>> filteredAggregationFunctions = new ArrayList<Pair<AggregationFunction, FilterContext>>();
            HashMap<Pair<FunctionContext, FilterContext>, Integer> filteredAggregationsIndexMap = new HashMap<Pair<FunctionContext, FilterContext>, Integer>();
            ArrayList<Pair<FunctionContext, FilterContext>> filteredAggregations = new ArrayList<Pair<FunctionContext, FilterContext>>();
            for (ExpressionContext expressionContext : queryContext._selectExpressions) {
                Builder.getAggregations(expressionContext, filteredAggregations);
            }
            for (Pair pair : filteredAggregations) {
                aggregation = (FunctionContext)pair.getLeft();
                filter = (FilterContext)pair.getRight();
                if (filter != null) {
                    if (this._groupByExpressions != null) {
                        throw new IllegalStateException("GROUP BY with FILTER clauses is not supported");
                    }
                    queryContext._hasFilteredAggregations = true;
                }
                functionIndex = filteredAggregationFunctions.size();
                aggregationFunction = AggregationFunctionFactory.getAggregationFunction(aggregation, queryContext);
                filteredAggregationFunctions.add(Pair.of((Object)aggregationFunction, (Object)filter));
                filteredAggregationsIndexMap.put(Pair.of((Object)aggregation, (Object)filter), functionIndex);
            }
            filteredAggregations.clear();
            if (queryContext._havingFilter != null) {
                Builder.getAggregations(queryContext._havingFilter, filteredAggregations);
            }
            if (queryContext._orderByExpressions != null) {
                for (OrderByExpressionContext orderByExpressionContext : queryContext._orderByExpressions) {
                    Builder.getAggregations(orderByExpressionContext.getExpression(), filteredAggregations);
                }
            }
            for (Pair pair : filteredAggregations) {
                if (filteredAggregationsIndexMap.containsKey(pair)) continue;
                aggregation = (FunctionContext)pair.getLeft();
                filter = (FilterContext)pair.getRight();
                functionIndex = filteredAggregationFunctions.size();
                aggregationFunction = AggregationFunctionFactory.getAggregationFunction(aggregation, queryContext);
                filteredAggregationFunctions.add(Pair.of((Object)aggregationFunction, (Object)filter));
                filteredAggregationsIndexMap.put(Pair.of((Object)aggregation, (Object)filter), functionIndex);
            }
            if (!filteredAggregationFunctions.isEmpty()) {
                int numAggregations = filteredAggregationFunctions.size();
                AggregationFunction[] aggregationFunctionArray = new AggregationFunction[numAggregations];
                for (int i = 0; i < numAggregations; ++i) {
                    aggregationFunctionArray[i] = (AggregationFunction)((Pair)filteredAggregationFunctions.get(i)).getLeft();
                }
                HashMap<FunctionContext, Integer> aggregationFunctionIndexMap = new HashMap<FunctionContext, Integer>();
                for (Map.Entry entry : filteredAggregationsIndexMap.entrySet()) {
                    aggregationFunctionIndexMap.put((FunctionContext)((Pair)entry.getKey()).getLeft(), (Integer)entry.getValue());
                }
                queryContext._aggregationFunctions = aggregationFunctionArray;
                queryContext._aggregationFunctionIndexMap = aggregationFunctionIndexMap;
                queryContext._filteredAggregationFunctions = filteredAggregationFunctions;
                queryContext._filteredAggregationsIndexMap = filteredAggregationsIndexMap;
            }
        }

        private static void getAggregations(ExpressionContext expression, List<Pair<FunctionContext, FilterContext>> filteredAggregations) {
            FunctionContext function = expression.getFunction();
            if (function == null) {
                return;
            }
            if (function.getType() == FunctionContext.Type.AGGREGATION) {
                filteredAggregations.add((Pair<FunctionContext, FilterContext>)Pair.of((Object)function, null));
            } else {
                List arguments = function.getArguments();
                if (function.getFunctionName().equalsIgnoreCase("filter")) {
                    Preconditions.checkState((arguments.size() == 2 ? 1 : 0) != 0, (Object)"FILTER must contain 2 arguments");
                    FunctionContext aggregation = ((ExpressionContext)arguments.get(0)).getFunction();
                    Preconditions.checkState((aggregation != null && aggregation.getType() == FunctionContext.Type.AGGREGATION ? 1 : 0) != 0, (Object)"First argument of FILTER must be an aggregation function");
                    ExpressionContext filterExpression = (ExpressionContext)arguments.get(1);
                    FilterContext filter = RequestContextUtils.getFilter((ExpressionContext)filterExpression);
                    filteredAggregations.add((Pair<FunctionContext, FilterContext>)Pair.of((Object)aggregation, (Object)filter));
                } else {
                    for (ExpressionContext argument : arguments) {
                        Builder.getAggregations(argument, filteredAggregations);
                    }
                }
            }
        }

        private static void getAggregations(FilterContext filter, List<Pair<FunctionContext, FilterContext>> filteredAggregations) {
            List children = filter.getChildren();
            if (children != null) {
                for (FilterContext child : children) {
                    Builder.getAggregations(child, filteredAggregations);
                }
            } else {
                Builder.getAggregations(filter.getPredicate().getLhs(), filteredAggregations);
            }
        }

        private void extractColumns(QueryContext query) {
            HashSet<String> columns = new HashSet<String>();
            for (ExpressionContext expression : query._selectExpressions) {
                expression.getColumns(columns);
            }
            if (query._filter != null) {
                query._filter.getColumns(columns);
            }
            if (query._groupByExpressions != null) {
                for (ExpressionContext expression : query._groupByExpressions) {
                    expression.getColumns(columns);
                }
            }
            if (query._havingFilter != null) {
                query._havingFilter.getColumns(columns);
            }
            if (query._orderByExpressions != null) {
                for (OrderByExpressionContext orderByExpression : query._orderByExpressions) {
                    orderByExpression.getColumns(columns);
                }
            }
            if (query._aggregationFunctions != null) {
                for (AggregationFunction aggregationFunction : query._aggregationFunctions) {
                    List<ExpressionContext> inputExpressions = aggregationFunction.getInputExpressions();
                    for (ExpressionContext expression : inputExpressions) {
                        expression.getColumns(columns);
                    }
                }
            }
            query._columns = columns;
        }
    }
}

