/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.reduce;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FunctionContext;
import org.apache.pinot.common.response.broker.BrokerResponseNative;
import org.apache.pinot.common.response.broker.ResultTable;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.data.table.Key;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionFactory;
import org.apache.pinot.core.query.reduce.GapfillFilterHandler;
import org.apache.pinot.core.query.request.context.QueryContext;
import org.apache.pinot.core.util.GapfillUtils;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.DateTimeGranularitySpec;

abstract class BaseGapfillProcessor {
    protected final QueryContext _queryContext;
    protected final int _limitForAggregatedResult;
    protected final DateTimeGranularitySpec _gapfillDateTimeGranularity;
    protected final DateTimeGranularitySpec _postGapfillDateTimeGranularity;
    protected final DateTimeFormatSpec _dateTimeFormatter;
    protected final long _startMs;
    protected final long _endMs;
    protected final long _gapfillTimeBucketSize;
    protected final long _postGapfillTimeBucketSize;
    protected final int _numOfTimeBuckets;
    protected final List<Integer> _groupByKeyIndexes;
    protected final Map<Key, Object[]> _previousByGroupKey;
    protected long _count = 0L;
    protected final List<ExpressionContext> _timeSeries;
    protected final int _timeBucketColumnIndex;
    protected GapfillFilterHandler _postGapfillFilterHandler = null;
    protected GapfillFilterHandler _postAggregateHavingFilterHandler = null;
    protected final int _aggregationSize;
    protected final GapfillUtils.GapfillType _gapfillType;
    protected int _limitForGapfilledResult;
    protected boolean[] _isGroupBySelections;
    protected ExpressionContext _gapFillSelection;

    BaseGapfillProcessor(QueryContext queryContext, GapfillUtils.GapfillType gapfillType) {
        this._queryContext = queryContext;
        this._limitForAggregatedResult = queryContext.getLimit();
        this._gapfillType = gapfillType;
        this._limitForGapfilledResult = this._gapfillType == GapfillUtils.GapfillType.AGGREGATE_GAP_FILL || this._gapfillType == GapfillUtils.GapfillType.GAP_FILL ? queryContext.getLimit() : queryContext.getSubquery().getLimit();
        this._gapFillSelection = GapfillUtils.getGapfillExpressionContext(queryContext, gapfillType);
        this._timeBucketColumnIndex = GapfillUtils.findTimeBucketColumnIndex(queryContext, gapfillType);
        List args = this._gapFillSelection.getFunction().getArguments();
        this._dateTimeFormatter = new DateTimeFormatSpec(((ExpressionContext)args.get(1)).getLiteralString());
        this._gapfillDateTimeGranularity = new DateTimeGranularitySpec(((ExpressionContext)args.get(4)).getLiteralString());
        this._postGapfillDateTimeGranularity = ((ExpressionContext)args.get(5)).getLiteralString() == null ? this._gapfillDateTimeGranularity : new DateTimeGranularitySpec(((ExpressionContext)args.get(5)).getLiteralString());
        String start = ((ExpressionContext)args.get(2)).getLiteralString();
        this._startMs = this.truncate(this._dateTimeFormatter.fromFormatToMillis(start));
        String end = ((ExpressionContext)args.get(3)).getLiteralString();
        this._endMs = this.truncate(this._dateTimeFormatter.fromFormatToMillis(end));
        this._gapfillTimeBucketSize = this._gapfillDateTimeGranularity.granularityToMillis();
        this._postGapfillTimeBucketSize = this._postGapfillDateTimeGranularity.granularityToMillis();
        this._numOfTimeBuckets = (int)((this._endMs - this._startMs) / this._gapfillTimeBucketSize);
        this._aggregationSize = (int)(this._postGapfillTimeBucketSize / this._gapfillTimeBucketSize);
        this._previousByGroupKey = new HashMap<Key, Object[]>();
        this._groupByKeyIndexes = new ArrayList<Integer>();
        ExpressionContext timeseriesOn = GapfillUtils.getTimeSeriesOnExpressionContext(this._gapFillSelection);
        this._timeSeries = timeseriesOn.getFunction().getArguments();
    }

    protected int findGapfillBucketIndex(long time) {
        return (int)((time - this._startMs) / this._gapfillTimeBucketSize);
    }

    protected void replaceColumnNameWithAlias(DataSchema dataSchema) {
        int i;
        QueryContext queryContext = this._gapfillType == GapfillUtils.GapfillType.AGGREGATE_GAP_FILL_AGGREGATE ? this._queryContext.getSubquery().getSubquery() : (this._gapfillType == GapfillUtils.GapfillType.GAP_FILL ? this._queryContext : this._queryContext.getSubquery());
        List<String> aliasList = queryContext.getAliasList();
        HashMap<String, String> columnNameToAliasMap = new HashMap<String, String>();
        for (i = 0; i < aliasList.size(); ++i) {
            if (aliasList.get(i) == null) continue;
            ExpressionContext selection = queryContext.getSelectExpressions().get(i);
            if (GapfillUtils.isGapfill(selection)) {
                selection = (ExpressionContext)selection.getFunction().getArguments().get(0);
            }
            columnNameToAliasMap.put(selection.toString(), aliasList.get(i));
        }
        for (i = 0; i < dataSchema.getColumnNames().length; ++i) {
            if (!columnNameToAliasMap.containsKey(dataSchema.getColumnNames()[i])) continue;
            dataSchema.getColumnNames()[i] = (String)columnNameToAliasMap.get(dataSchema.getColumnNames()[i]);
        }
    }

    public void process(BrokerResponseNative brokerResponseNative) {
        DataSchema dataSchema = brokerResponseNative.getResultTable().getDataSchema();
        DataSchema resultTableSchema = this.getResultTableDataSchema(dataSchema);
        if (brokerResponseNative.getResultTable().getRows().isEmpty()) {
            brokerResponseNative.setResultTable(new ResultTable(resultTableSchema, Collections.emptyList()));
            return;
        }
        String[] columns = dataSchema.getColumnNames();
        HashMap<String, Integer> indexes = new HashMap<String, Integer>();
        for (int i = 0; i < columns.length; ++i) {
            indexes.put(columns[i], i);
        }
        this._isGroupBySelections = new boolean[dataSchema.getColumnDataTypes().length];
        for (ExpressionContext entityColum : this._timeSeries) {
            int index = (Integer)indexes.get(entityColum.getIdentifier());
            this._isGroupBySelections[index] = true;
        }
        for (int i = 0; i < this._isGroupBySelections.length; ++i) {
            if (!this._isGroupBySelections[i]) continue;
            this._groupByKeyIndexes.add(i);
        }
        List rows = brokerResponseNative.getResultTable().getRows();
        this.replaceColumnNameWithAlias(dataSchema);
        List<Object[]> resultRows = this.gapFillAndAggregate(rows, dataSchema, resultTableSchema);
        brokerResponseNative.setResultTable(new ResultTable(resultTableSchema, resultRows));
    }

    protected DataSchema getResultTableDataSchema(DataSchema dataSchema) {
        if (this._gapfillType == GapfillUtils.GapfillType.GAP_FILL) {
            return dataSchema;
        }
        int numOfColumns = this._queryContext.getSelectExpressions().size();
        String[] columnNames = new String[numOfColumns];
        DataSchema.ColumnDataType[] columnDataTypes = new DataSchema.ColumnDataType[numOfColumns];
        for (int i = 0; i < numOfColumns; ++i) {
            ExpressionContext expressionContext = this._queryContext.getSelectExpressions().get(i);
            if (GapfillUtils.isGapfill(expressionContext)) {
                expressionContext = (ExpressionContext)expressionContext.getFunction().getArguments().get(0);
            }
            if (expressionContext.getType() != ExpressionContext.Type.FUNCTION) {
                columnNames[i] = expressionContext.getIdentifier();
                columnDataTypes[i] = dataSchema.getColumnDataType(this._timeBucketColumnIndex);
                continue;
            }
            FunctionContext functionContext = expressionContext.getFunction();
            AggregationFunction aggregationFunction = AggregationFunctionFactory.getAggregationFunction(functionContext, this._queryContext);
            columnDataTypes[i] = aggregationFunction.getFinalResultColumnType();
            columnNames[i] = functionContext.toString();
        }
        return new DataSchema(columnNames, columnDataTypes);
    }

    protected Key constructGroupKeys(Object[] row) {
        Object[] groupKeys = new Object[this._groupByKeyIndexes.size()];
        for (int i = 0; i < this._groupByKeyIndexes.size(); ++i) {
            groupKeys[i] = row[this._groupByKeyIndexes.get(i)];
        }
        return new Key(groupKeys);
    }

    protected long truncate(long epoch) {
        int sz = this._gapfillDateTimeGranularity.getSize();
        return epoch / (long)sz * (long)sz;
    }

    protected List<Object[]> gapFillAndAggregate(List<Object[]> rows, DataSchema dataSchema, DataSchema resultTableSchema) {
        throw new UnsupportedOperationException("Not supported");
    }
}

