/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.optimizer.filter;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.common.request.Expression;
import org.apache.pinot.common.request.ExpressionType;
import org.apache.pinot.common.request.Function;
import org.apache.pinot.common.utils.request.RequestUtils;
import org.apache.pinot.core.query.optimizer.filter.FilterOptimizer;
import org.apache.pinot.core.query.optimizer.filter.Range;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeFormatSpec;
import org.apache.pinot.spi.data.DateTimeGranularitySpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.TimeUtils;
import org.apache.pinot.sql.FilterKind;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimePredicateFilterOptimizer
implements FilterOptimizer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimePredicateFilterOptimizer.class);

    @Override
    public Expression optimize(Expression filterExpression, @Nullable Schema schema) {
        return filterExpression.getType() == ExpressionType.FUNCTION ? this.optimize(filterExpression) : filterExpression;
    }

    @VisibleForTesting
    Expression optimize(Expression filterExpression) {
        Expression expression;
        Function filterFunction = filterExpression.getFunctionCall();
        FilterKind filterKind = FilterKind.valueOf((String)filterFunction.getOperator());
        List operands = filterFunction.getOperands();
        if (filterKind == FilterKind.AND || filterKind == FilterKind.OR || filterKind == FilterKind.NOT) {
            for (Expression operand : operands) {
                this.optimize(operand);
            }
        } else if ((filterKind.isRange() || filterKind == FilterKind.EQUALS) && (expression = (Expression)operands.get(0)).getType() == ExpressionType.FUNCTION) {
            Function expressionFunction = expression.getFunctionCall();
            String functionName = StringUtils.remove((String)expressionFunction.getOperator(), (char)'_');
            if (functionName.equalsIgnoreCase("timeConvert")) {
                this.optimizeTimeConvert(filterFunction, filterKind);
            } else if (functionName.equalsIgnoreCase("dateTimeConvert")) {
                this.optimizeDateTimeConvert(filterFunction, filterKind);
            }
        }
        return filterExpression;
    }

    private void optimizeTimeConvert(Function filterFunction, FilterKind filterKind) {
        List filterOperands = filterFunction.getOperands();
        List timeConvertOperands = ((Expression)filterOperands.get(0)).getFunctionCall().getOperands();
        Preconditions.checkArgument((timeConvertOperands.size() == 3 ? 1 : 0) != 0, (Object)"Exactly 3 arguments are required for TIME_CONVERT transform function");
        Preconditions.checkArgument((this.isStringLiteral((Expression)timeConvertOperands.get(1)) && this.isStringLiteral((Expression)timeConvertOperands.get(2)) ? 1 : 0) != 0, (Object)"The 2nd and 3rd argument for TIME_CONVERT transform function must be string literal");
        try {
            TimeUnit inputTimeUnit = TimeUnit.valueOf(((Expression)timeConvertOperands.get(1)).getLiteral().getStringValue().toUpperCase());
            TimeUnit outputTimeUnit = TimeUnit.valueOf(((Expression)timeConvertOperands.get(2)).getLiteral().getStringValue().toUpperCase());
            if (inputTimeUnit == outputTimeUnit) {
                filterOperands.set(0, (Expression)timeConvertOperands.get(0));
                return;
            }
            Long lowerMillis = null;
            Long upperMillis = null;
            switch (filterKind) {
                case GREATER_THAN: {
                    long lowerValue = Long.parseLong(((Expression)filterOperands.get(1)).getLiteral().getFieldValue().toString());
                    lowerMillis = outputTimeUnit.toMillis(lowerValue + 1L);
                    Preconditions.checkState((boolean)TimeUtils.timeValueInValidRange((long)lowerMillis), (String)"Invalid lower bound in millis: %s", (Object)lowerMillis);
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    long lowerValue = Long.parseLong(((Expression)filterOperands.get(1)).getLiteral().getFieldValue().toString());
                    lowerMillis = outputTimeUnit.toMillis(lowerValue);
                    Preconditions.checkState((boolean)TimeUtils.timeValueInValidRange((long)lowerMillis), (String)"Invalid lower bound in millis: %s", (Object)lowerMillis);
                    break;
                }
                case LESS_THAN: {
                    long upperValue = Long.parseLong(((Expression)filterOperands.get(1)).getLiteral().getFieldValue().toString());
                    upperMillis = outputTimeUnit.toMillis(upperValue);
                    Preconditions.checkState((boolean)TimeUtils.timeValueInValidRange((long)upperMillis), (String)"Invalid upper bound in millis: %s", (Object)upperMillis);
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    long upperValue = Long.parseLong(((Expression)filterOperands.get(1)).getLiteral().getFieldValue().toString());
                    upperMillis = outputTimeUnit.toMillis(upperValue + 1L);
                    Preconditions.checkState((boolean)TimeUtils.timeValueInValidRange((long)upperMillis), (String)"Invalid upper bound in millis: %s", (Object)upperMillis);
                    break;
                }
                case BETWEEN: {
                    long lowerValue = Long.parseLong(((Expression)filterOperands.get(1)).getLiteral().getFieldValue().toString());
                    lowerMillis = outputTimeUnit.toMillis(lowerValue);
                    Preconditions.checkState((boolean)TimeUtils.timeValueInValidRange((long)lowerMillis), (String)"Invalid lower bound in millis: %s", (Object)lowerMillis);
                    long upperValue = Long.parseLong(((Expression)filterOperands.get(2)).getLiteral().getFieldValue().toString());
                    upperMillis = outputTimeUnit.toMillis(upperValue + 1L);
                    Preconditions.checkState((boolean)TimeUtils.timeValueInValidRange((long)upperMillis), (String)"Invalid upper bound in millis: %s", (Object)upperMillis);
                    break;
                }
                case EQUALS: {
                    long value = Long.parseLong(((Expression)filterOperands.get(1)).getLiteral().getFieldValue().toString());
                    lowerMillis = outputTimeUnit.toMillis(value);
                    Preconditions.checkState((boolean)TimeUtils.timeValueInValidRange((long)lowerMillis), (String)"Invalid lower bound in millis: %s", (Object)lowerMillis);
                    upperMillis = outputTimeUnit.toMillis(value + 1L);
                    Preconditions.checkState((boolean)TimeUtils.timeValueInValidRange((long)upperMillis), (String)"Invalid upper bound in millis: %s", (Object)upperMillis);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            Long lowerValue = null;
            boolean lowerInclusive = false;
            if (lowerMillis != null) {
                lowerValue = inputTimeUnit.convert(lowerMillis, TimeUnit.MILLISECONDS);
                lowerInclusive = inputTimeUnit.toMillis(lowerValue) == lowerMillis.longValue();
            }
            Long upperValue = null;
            boolean upperInclusive = false;
            if (upperMillis != null) {
                upperValue = inputTimeUnit.convert(upperMillis, TimeUnit.MILLISECONDS);
                upperInclusive = inputTimeUnit.toMillis(upperValue) != upperMillis.longValue();
            }
            String rangeString = new Range(lowerValue, lowerInclusive, upperValue, upperInclusive).getRangeString();
            filterFunction.setOperator(FilterKind.RANGE.name());
            filterFunction.setOperands(Arrays.asList((Expression)timeConvertOperands.get(0), RequestUtils.getLiteralExpression((String)rangeString)));
        }
        catch (Exception e) {
            LOGGER.warn("Caught exception while optimizing TIME_CONVERT predicate: {}, skipping the optimization", (Object)filterFunction, (Object)e);
        }
    }

    private void optimizeDateTimeConvert(Function filterFunction, FilterKind filterKind) {
        List filterOperands = filterFunction.getOperands();
        List dateTimeConvertOperands = ((Expression)filterOperands.get(0)).getFunctionCall().getOperands();
        Preconditions.checkArgument((dateTimeConvertOperands.size() == 4 ? 1 : 0) != 0, (Object)"Exactly 4 arguments are required for DATE_TIME_CONVERT transform function");
        Preconditions.checkArgument((this.isStringLiteral((Expression)dateTimeConvertOperands.get(1)) && this.isStringLiteral((Expression)dateTimeConvertOperands.get(2)) && this.isStringLiteral((Expression)dateTimeConvertOperands.get(3)) ? 1 : 0) != 0, (Object)"The 2nd to 4th arguments for DATE_TIME_CONVERT transform function must be string literal");
        try {
            DateTimeFormatSpec inputFormat = new DateTimeFormatSpec(((Expression)dateTimeConvertOperands.get(1)).getLiteral().getStringValue());
            DateTimeFormatSpec outputFormat = new DateTimeFormatSpec(((Expression)dateTimeConvertOperands.get(2)).getLiteral().getStringValue());
            if (outputFormat.getTimeFormat() == DateTimeFieldSpec.TimeFormat.SIMPLE_DATE_FORMAT) {
                return;
            }
            long granularityMillis = new DateTimeGranularitySpec(((Expression)dateTimeConvertOperands.get(3)).getLiteral().getStringValue()).granularityToMillis();
            Long lowerMillis = null;
            Long upperMillis = null;
            switch (filterKind) {
                case GREATER_THAN: {
                    long lowerValue = Long.parseLong(((Expression)filterOperands.get(1)).getLiteral().getFieldValue().toString());
                    lowerMillis = this.ceil(outputFormat.fromFormatToMillis(Long.toString(lowerValue + 1L)), granularityMillis);
                    Preconditions.checkState((boolean)TimeUtils.timeValueInValidRange((long)lowerMillis), (String)"Invalid lower bound in millis: %s", (Object)lowerMillis);
                    break;
                }
                case GREATER_THAN_OR_EQUAL: {
                    String lowerValue = ((Expression)filterOperands.get(1)).getLiteral().getFieldValue().toString();
                    lowerMillis = this.ceil(outputFormat.fromFormatToMillis(lowerValue), granularityMillis);
                    Preconditions.checkState((boolean)TimeUtils.timeValueInValidRange((long)lowerMillis), (String)"Invalid lower bound in millis: %s", (Object)lowerMillis);
                    break;
                }
                case LESS_THAN: {
                    String upperValue = ((Expression)filterOperands.get(1)).getLiteral().getFieldValue().toString();
                    upperMillis = this.ceil(outputFormat.fromFormatToMillis(upperValue), granularityMillis);
                    Preconditions.checkState((boolean)TimeUtils.timeValueInValidRange((long)upperMillis), (String)"Invalid upper bound in millis: %s", (Object)upperMillis);
                    break;
                }
                case LESS_THAN_OR_EQUAL: {
                    long upperValue = Long.parseLong(((Expression)filterOperands.get(1)).getLiteral().getFieldValue().toString());
                    upperMillis = this.ceil(outputFormat.fromFormatToMillis(Long.toString(upperValue + 1L)), granularityMillis);
                    Preconditions.checkState((boolean)TimeUtils.timeValueInValidRange((long)upperMillis), (String)"Invalid upper bound in millis: %s", (Object)upperMillis);
                    break;
                }
                case BETWEEN: {
                    String lowerValue = ((Expression)filterOperands.get(1)).getLiteral().getFieldValue().toString();
                    lowerMillis = this.ceil(outputFormat.fromFormatToMillis(lowerValue), granularityMillis);
                    Preconditions.checkState((boolean)TimeUtils.timeValueInValidRange((long)lowerMillis), (String)"Invalid lower bound in millis: %s", (Object)lowerMillis);
                    long upperValue = Long.parseLong(((Expression)filterOperands.get(2)).getLiteral().getFieldValue().toString());
                    upperMillis = this.ceil(outputFormat.fromFormatToMillis(Long.toString(upperValue + 1L)), granularityMillis);
                    Preconditions.checkState((boolean)TimeUtils.timeValueInValidRange((long)upperMillis), (String)"Invalid upper bound in millis: %s", (Object)upperMillis);
                    break;
                }
                case EQUALS: {
                    String value = ((Expression)filterOperands.get(1)).getLiteral().getFieldValue().toString();
                    lowerMillis = this.ceil(outputFormat.fromFormatToMillis(value), granularityMillis);
                    Preconditions.checkState((boolean)TimeUtils.timeValueInValidRange((long)lowerMillis), (String)"Invalid lower bound in millis: %s", (Object)lowerMillis);
                    upperMillis = this.ceil(outputFormat.fromFormatToMillis(Long.toString(Long.parseLong(value) + 1L)), granularityMillis);
                    Preconditions.checkState((boolean)TimeUtils.timeValueInValidRange((long)upperMillis), (String)"Invalid upper bound in millis: %s", (Object)upperMillis);
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
            String lowerValue = null;
            boolean lowerInclusive = false;
            if (lowerMillis != null) {
                lowerValue = inputFormat.fromMillisToFormat(lowerMillis.longValue());
                lowerInclusive = inputFormat.fromFormatToMillis(lowerValue) == lowerMillis.longValue();
            }
            String upperValue = null;
            boolean upperInclusive = false;
            if (upperMillis != null) {
                upperValue = inputFormat.fromMillisToFormat(upperMillis.longValue());
                upperInclusive = inputFormat.fromFormatToMillis(upperValue) != upperMillis.longValue();
            }
            String rangeString = new Range((Comparable)((Object)lowerValue), lowerInclusive, (Comparable)((Object)upperValue), upperInclusive).getRangeString();
            filterFunction.setOperator(FilterKind.RANGE.name());
            filterFunction.setOperands(Arrays.asList((Expression)dateTimeConvertOperands.get(0), RequestUtils.getLiteralExpression((String)rangeString)));
        }
        catch (Exception e) {
            LOGGER.warn("Caught exception while optimizing DATE_TIME_CONVERT predicate: {}, skipping the optimization", (Object)filterFunction, (Object)e);
        }
    }

    private boolean isStringLiteral(Expression expression) {
        return expression.getType() == ExpressionType.LITERAL && expression.getLiteral().isSetStringValue();
    }

    private long ceil(long millisValue, long granularityMillis) {
        return (millisValue + granularityMillis - 1L) / granularityMillis * granularityMillis;
    }
}

