/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct.dictionary;

import java.util.List;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.operator.blocks.TransformBlock;
import org.apache.pinot.core.query.distinct.DistinctExecutorUtils;
import org.apache.pinot.core.query.distinct.dictionary.BaseDictionaryBasedMultiColumnDistinctExecutor;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.spi.data.FieldSpec;

public class DictionaryBasedMultiColumnDistinctOnlyExecutor
extends BaseDictionaryBasedMultiColumnDistinctExecutor {
    private final boolean _hasMVExpression;

    public DictionaryBasedMultiColumnDistinctOnlyExecutor(List<ExpressionContext> expressions, boolean hasMVExpression, List<Dictionary> dictionaries, List<FieldSpec.DataType> dataTypes, int limit) {
        super(expressions, dictionaries, dataTypes, limit);
        this._hasMVExpression = hasMVExpression;
    }

    @Override
    public boolean process(TransformBlock transformBlock) {
        int numDocs = transformBlock.getNumDocs();
        int numExpressions = this._expressions.size();
        if (!this._hasMVExpression) {
            int i;
            int[][] dictIdsArray = new int[numDocs][numExpressions];
            for (i = 0; i < numExpressions; ++i) {
                BlockValSet blockValueSet = transformBlock.getBlockValueSet((ExpressionContext)this._expressions.get(i));
                int[] dictIdsForExpression = blockValueSet.getDictionaryIdsSV();
                for (int j = 0; j < numDocs; ++j) {
                    dictIdsArray[j][i] = dictIdsForExpression[j];
                }
            }
            for (i = 0; i < numDocs; ++i) {
                this._dictIdsSet.add((Object)new BaseDictionaryBasedMultiColumnDistinctExecutor.DictIds(dictIdsArray[i]));
                if (this._dictIdsSet.size() < this._limit) continue;
                return true;
            }
        } else {
            int i;
            int[][] svDictIds = new int[numExpressions][];
            int[][][] mvDictIds = new int[numExpressions][][];
            for (i = 0; i < numExpressions; ++i) {
                BlockValSet blockValueSet = transformBlock.getBlockValueSet((ExpressionContext)this._expressions.get(i));
                if (blockValueSet.isSingleValue()) {
                    svDictIds[i] = blockValueSet.getDictionaryIdsSV();
                    continue;
                }
                mvDictIds[i] = blockValueSet.getDictionaryIdsMV();
            }
            for (i = 0; i < numDocs; ++i) {
                int[][] dictIdsArray;
                for (int[] dictIds : dictIdsArray = DistinctExecutorUtils.getDictIds(svDictIds, mvDictIds, i)) {
                    this._dictIdsSet.add((Object)new BaseDictionaryBasedMultiColumnDistinctExecutor.DictIds(dictIds));
                    if (this._dictIdsSet.size() < this._limit) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

