/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.distinct;

import com.google.common.annotations.VisibleForTesting;
import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.IOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.datatable.DataTableFactory;
import org.apache.pinot.common.request.context.OrderByExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.datatable.DataTableBuilder;
import org.apache.pinot.core.common.datatable.DataTableBuilderFactory;
import org.apache.pinot.core.data.table.Record;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.LoopUtils;
import org.roaringbitmap.RoaringBitmap;

public class DistinctTable {
    private final DataSchema _dataSchema;
    private final Collection<Record> _records;
    private final boolean _isMainTable;
    private final int _limit;
    private final boolean _nullHandlingEnabled;
    private final ObjectSet<Record> _recordSet;
    private final PriorityQueue<Record> _priorityQueue;

    public DistinctTable(DataSchema dataSchema, @Nullable List<OrderByExpressionContext> orderByExpressions, int limit, boolean nullHandlingEnabled) {
        this._dataSchema = dataSchema;
        this._isMainTable = true;
        this._limit = limit;
        this._nullHandlingEnabled = nullHandlingEnabled;
        int initialCapacity = Math.min(limit, 10000);
        this._recordSet = new ObjectOpenHashSet(initialCapacity);
        this._records = this._recordSet;
        if (orderByExpressions != null) {
            List<String> columnNames = Arrays.asList(dataSchema.getColumnNames());
            int numOrderByExpressions = orderByExpressions.size();
            int[] orderByExpressionIndices = new int[numOrderByExpressions];
            int[] comparisonFactors = new int[numOrderByExpressions];
            for (int i = 0; i < numOrderByExpressions; ++i) {
                OrderByExpressionContext orderByExpression = orderByExpressions.get(i);
                orderByExpressionIndices[i] = columnNames.indexOf(orderByExpression.getExpression().toString());
                comparisonFactors[i] = orderByExpression.isAsc() ? -1 : 1;
            }
            this._priorityQueue = this._nullHandlingEnabled ? new ObjectHeapPriorityQueue(initialCapacity, (r1, r2) -> {
                Object[] values1 = r1.getValues();
                Object[] values2 = r2.getValues();
                for (int i = 0; i < numOrderByExpressions; ++i) {
                    int index = orderByExpressionIndices[i];
                    Comparable value1 = (Comparable)values1[index];
                    Comparable value2 = (Comparable)values2[index];
                    if (value1 == null) {
                        if (value2 == null) continue;
                        return comparisonFactors[i];
                    }
                    if (value2 == null) {
                        return -comparisonFactors[i];
                    }
                    int result = value1.compareTo(value2) * comparisonFactors[i];
                    if (result == 0) continue;
                    return result;
                }
                return 0;
            }) : new ObjectHeapPriorityQueue(initialCapacity, (r1, r2) -> {
                Object[] values1 = r1.getValues();
                Object[] values2 = r2.getValues();
                for (int i = 0; i < numOrderByExpressions; ++i) {
                    int index = orderByExpressionIndices[i];
                    Comparable value1 = (Comparable)values1[index];
                    Comparable value2 = (Comparable)values2[index];
                    int result = value1.compareTo(value2) * comparisonFactors[i];
                    if (result == 0) continue;
                    return result;
                }
                return 0;
            });
        } else {
            this._priorityQueue = null;
        }
    }

    public DistinctTable(DataSchema dataSchema, Collection<Record> records, boolean nullHandlingEnabled) {
        this._dataSchema = dataSchema;
        this._records = records;
        this._nullHandlingEnabled = nullHandlingEnabled;
        this._isMainTable = false;
        this._limit = Integer.MIN_VALUE;
        this._recordSet = null;
        this._priorityQueue = null;
    }

    public DistinctTable(DataSchema dataSchema, Collection<Record> records) {
        this(dataSchema, records, false);
    }

    public DataSchema getDataSchema() {
        return this._dataSchema;
    }

    public boolean isMainTable() {
        return this._isMainTable;
    }

    public int size() {
        return this._records.size();
    }

    public boolean isEmpty() {
        return this._records.isEmpty();
    }

    @VisibleForTesting
    public Collection<Record> getRecords() {
        return this._records;
    }

    public boolean hasOrderBy() {
        assert (this._isMainTable);
        return this._priorityQueue != null;
    }

    public boolean addWithoutOrderBy(Record record) {
        assert (this._isMainTable && this._priorityQueue == null);
        this._recordSet.add((Object)record);
        return this._recordSet.size() >= this._limit;
    }

    public void addWithOrderBy(Record record) {
        assert (this._isMainTable && this._priorityQueue != null);
        if (!this._recordSet.contains((Object)record)) {
            if (this._priorityQueue.size() < this._limit) {
                this._recordSet.add((Object)record);
                this._priorityQueue.enqueue((Object)record);
            } else {
                Record firstRecord = (Record)this._priorityQueue.first();
                if (this._priorityQueue.comparator().compare(record, firstRecord) > 0) {
                    this._recordSet.remove((Object)firstRecord);
                    this._recordSet.add((Object)record);
                    this._priorityQueue.dequeue();
                    this._priorityQueue.enqueue((Object)record);
                }
            }
        }
    }

    public void mergeTable(DistinctTable distinctTable) {
        block5: {
            int mergedRecords;
            block4: {
                assert (this._isMainTable);
                mergedRecords = 0;
                if (!this.hasOrderBy()) break block4;
                for (Record record : distinctTable._records) {
                    this.addWithOrderBy(record);
                    LoopUtils.checkMergePhaseInterruption((int)(++mergedRecords));
                }
                break block5;
            }
            if (this._recordSet.size() >= this._limit) break block5;
            for (Record record : distinctTable._records) {
                if (this.addWithoutOrderBy(record)) {
                    return;
                }
                LoopUtils.checkMergePhaseInterruption((int)(++mergedRecords));
            }
        }
    }

    public Iterator<Record> getFinalResult() {
        assert (this._isMainTable);
        if (this._priorityQueue != null) {
            int numRecords = this._priorityQueue.size();
            Record[] sortedRecords = new Record[numRecords];
            for (int i = numRecords - 1; i >= 0; --i) {
                sortedRecords[i] = (Record)this._priorityQueue.dequeue();
            }
            return Arrays.asList(sortedRecords).iterator();
        }
        return this._recordSet.iterator();
    }

    public byte[] toBytes() throws IOException {
        DataTableBuilder dataTableBuilder = DataTableBuilderFactory.getDataTableBuilder(this._dataSchema);
        DataSchema.ColumnDataType[] storedColumnDataTypes = this._dataSchema.getStoredColumnDataTypes();
        int numColumns = storedColumnDataTypes.length;
        RoaringBitmap[] nullBitmaps = null;
        if (this._nullHandlingEnabled) {
            nullBitmaps = new RoaringBitmap[numColumns];
            Object[] nullPlaceholders = new Object[numColumns];
            for (int colId = 0; colId < numColumns; ++colId) {
                nullPlaceholders[colId] = storedColumnDataTypes[colId].getNullPlaceholder();
                nullBitmaps[colId] = new RoaringBitmap();
            }
            int rowId = 0;
            for (Record record : this._records) {
                Object[] values = record.getValues();
                for (int colId = 0; colId < numColumns; ++colId) {
                    if (values[colId] != null) continue;
                    values[colId] = nullPlaceholders[colId];
                    nullBitmaps[colId].add(rowId);
                }
                ++rowId;
            }
        }
        for (Record record : this._records) {
            dataTableBuilder.startRow();
            Object[] values = record.getValues();
            block13: for (int i = 0; i < numColumns; ++i) {
                switch (storedColumnDataTypes[i]) {
                    case INT: {
                        dataTableBuilder.setColumn(i, (Integer)values[i]);
                        continue block13;
                    }
                    case LONG: {
                        dataTableBuilder.setColumn(i, (Long)values[i]);
                        continue block13;
                    }
                    case FLOAT: {
                        dataTableBuilder.setColumn(i, ((Float)values[i]).floatValue());
                        continue block13;
                    }
                    case DOUBLE: {
                        dataTableBuilder.setColumn(i, (Double)values[i]);
                        continue block13;
                    }
                    case BIG_DECIMAL: {
                        dataTableBuilder.setColumn(i, (BigDecimal)values[i]);
                        continue block13;
                    }
                    case STRING: {
                        dataTableBuilder.setColumn(i, (String)values[i]);
                        continue block13;
                    }
                    case BYTES: {
                        dataTableBuilder.setColumn(i, (ByteArray)values[i]);
                        continue block13;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            dataTableBuilder.finishRow();
        }
        if (this._nullHandlingEnabled) {
            for (int colId = 0; colId < numColumns; ++colId) {
                dataTableBuilder.setNullRowIds(nullBitmaps[colId]);
            }
        }
        return dataTableBuilder.build().toBytes();
    }

    public static DistinctTable fromByteBuffer(ByteBuffer byteBuffer) throws IOException {
        int j;
        Object[] values;
        int i;
        DataTable dataTable = DataTableFactory.getDataTable((ByteBuffer)byteBuffer);
        DataSchema dataSchema = dataTable.getDataSchema();
        int numRecords = dataTable.getNumberOfRows();
        DataSchema.ColumnDataType[] storedColumnDataTypes = dataSchema.getStoredColumnDataTypes();
        int numColumns = storedColumnDataTypes.length;
        RoaringBitmap[] nullBitmaps = new RoaringBitmap[numColumns];
        boolean nullHandlingEnabled = false;
        for (int colId = 0; colId < numColumns; ++colId) {
            nullBitmaps[colId] = dataTable.getNullRowIds(colId);
            nullHandlingEnabled |= nullBitmaps[colId] != null;
        }
        ArrayList<Record> records = new ArrayList<Record>(numRecords);
        for (i = 0; i < numRecords; ++i) {
            values = new Object[numColumns];
            block11: for (j = 0; j < numColumns; ++j) {
                switch (storedColumnDataTypes[j]) {
                    case INT: {
                        values[j] = dataTable.getInt(i, j);
                        continue block11;
                    }
                    case LONG: {
                        values[j] = dataTable.getLong(i, j);
                        continue block11;
                    }
                    case FLOAT: {
                        values[j] = Float.valueOf(dataTable.getFloat(i, j));
                        continue block11;
                    }
                    case DOUBLE: {
                        values[j] = dataTable.getDouble(i, j);
                        continue block11;
                    }
                    case BIG_DECIMAL: {
                        values[j] = dataTable.getBigDecimal(i, j);
                        continue block11;
                    }
                    case STRING: {
                        values[j] = dataTable.getString(i, j);
                        continue block11;
                    }
                    case BYTES: {
                        values[j] = dataTable.getBytes(i, j);
                        continue block11;
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
            }
            records.add(new Record(values));
        }
        if (nullHandlingEnabled) {
            for (i = 0; i < records.size(); ++i) {
                values = ((Record)records.get(i)).getValues();
                for (j = 0; j < numColumns; ++j) {
                    if (nullBitmaps[j] == null || !nullBitmaps[j].contains(i)) continue;
                    values[j] = null;
                }
            }
        }
        return new DistinctTable(dataSchema, records);
    }
}

