/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.config;

import org.apache.commons.configuration.ConfigurationException;
import org.apache.pinot.core.query.config.QueryPlannerConfig;
import org.apache.pinot.core.query.config.SegmentPrunerConfig;
import org.apache.pinot.spi.env.PinotConfiguration;

public class QueryExecutorConfig {
    public static final String QUERY_PRUNER = "pruner";
    public static final String QUERY_PLANNER = "queryPlanner";
    public static final String TIME_OUT = "timeout";
    private static final String[] REQUIRED_KEYS = new String[0];
    private PinotConfiguration _queryExecutorConfig = null;
    private SegmentPrunerConfig _segmentPrunerConfig;
    private QueryPlannerConfig _queryPlannerConfig;
    private final long _timeOutMs;

    public QueryExecutorConfig(PinotConfiguration config) throws ConfigurationException {
        this._queryExecutorConfig = config;
        this.checkRequiredKeys();
        this._segmentPrunerConfig = new SegmentPrunerConfig(this._queryExecutorConfig.subset(QUERY_PRUNER));
        this._queryPlannerConfig = new QueryPlannerConfig(this._queryExecutorConfig.subset(QUERY_PLANNER));
        this._timeOutMs = this._queryExecutorConfig.getProperty(TIME_OUT, -1);
    }

    private void checkRequiredKeys() throws ConfigurationException {
        for (String keyString : REQUIRED_KEYS) {
            if (this._queryExecutorConfig.containsKey(keyString)) continue;
            throw new ConfigurationException("Cannot find required key : " + keyString);
        }
    }

    public PinotConfiguration getConfig() {
        return this._queryExecutorConfig;
    }

    public SegmentPrunerConfig getPrunerConfig() {
        return this._segmentPrunerConfig;
    }

    public QueryPlannerConfig getQueryPlannerConfig() {
        return this._queryPlannerConfig;
    }

    public long getTimeOut() {
        return this._timeOutMs;
    }
}

