/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.groupby.utils;

import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import org.apache.pinot.core.query.aggregation.groupby.utils.BaseValueToIdMap;
import org.apache.pinot.spi.utils.ByteArray;

public class BytesToIdMap
extends BaseValueToIdMap {
    Object2IntMap<ByteArray> _valueToIdMap = new Object2IntOpenHashMap();
    ObjectList<ByteArray> _idToValueMap;

    public BytesToIdMap() {
        this._valueToIdMap.defaultReturnValue(-1);
        this._idToValueMap = new ObjectArrayList();
    }

    @Override
    public int put(ByteArray value) {
        int id = this._valueToIdMap.getInt((Object)value);
        if (id == -1) {
            id = this._idToValueMap.size();
            this._valueToIdMap.put((Object)value, id);
            this._idToValueMap.add((Object)value);
        }
        return id;
    }

    @Override
    public String getString(int id) {
        return this.getBytes(id).toHexString();
    }

    @Override
    public ByteArray getBytes(int id) {
        assert (id < this._idToValueMap.size());
        return (ByteArray)this._idToValueMap.get(id);
    }

    @Override
    public Object get(int id) {
        return this.getBytes(id);
    }
}

