/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import java.util.Map;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.PercentileEstAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.segment.local.customobject.QuantileDigest;
import org.apache.pinot.segment.spi.AggregationFunctionType;

public class PercentileEstMVAggregationFunction
extends PercentileEstAggregationFunction {
    public PercentileEstMVAggregationFunction(ExpressionContext expression, int percentile) {
        super(expression, percentile);
    }

    public PercentileEstMVAggregationFunction(ExpressionContext expression, double percentile) {
        super(expression, percentile);
    }

    @Override
    public AggregationFunctionType getType() {
        return AggregationFunctionType.PERCENTILEESTMV;
    }

    @Override
    public String getColumnName() {
        return this._version == 0 ? AggregationFunctionType.PERCENTILEEST.getName() + (int)this._percentile + "MV_" + this._expression : AggregationFunctionType.PERCENTILEEST.getName() + this._percentile + "MV_" + this._expression;
    }

    @Override
    public String getResultColumnName() {
        return this._version == 0 ? AggregationFunctionType.PERCENTILEEST.getName().toLowerCase() + (int)this._percentile + "mv(" + this._expression + ")" : AggregationFunctionType.PERCENTILEEST.getName().toLowerCase() + "mv(" + this._expression + ", " + this._percentile + ")";
    }

    @Override
    public void aggregate(int length, AggregationResultHolder aggregationResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        long[][] valuesArray = blockValSetMap.get(this._expression).getLongValuesMV();
        QuantileDigest quantileDigest = PercentileEstMVAggregationFunction.getDefaultQuantileDigest(aggregationResultHolder);
        for (int i = 0; i < length; ++i) {
            for (long value : valuesArray[i]) {
                quantileDigest.add(value);
            }
        }
    }

    @Override
    public void aggregateGroupBySV(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        long[][] valuesArray = blockValSetMap.get(this._expression).getLongValuesMV();
        for (int i = 0; i < length; ++i) {
            QuantileDigest quantileDigest = PercentileEstMVAggregationFunction.getDefaultQuantileDigest(groupByResultHolder, groupKeyArray[i]);
            for (long value : valuesArray[i]) {
                quantileDigest.add(value);
            }
        }
    }

    @Override
    public void aggregateGroupByMV(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, Map<ExpressionContext, BlockValSet> blockValSetMap) {
        long[][] valuesArray = blockValSetMap.get(this._expression).getLongValuesMV();
        for (int i = 0; i < length; ++i) {
            long[] values = valuesArray[i];
            for (int groupKey : groupKeysArray[i]) {
                QuantileDigest quantileDigest = PercentileEstMVAggregationFunction.getDefaultQuantileDigest(groupByResultHolder, groupKey);
                for (long value : values) {
                    quantileDigest.add(value);
                }
            }
        }
    }
}

