/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.query.aggregation.function;

import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.utils.DataSchema;
import org.apache.pinot.core.common.BlockValSet;
import org.apache.pinot.core.common.ObjectSerDeUtils;
import org.apache.pinot.core.query.aggregation.AggregationResultHolder;
import org.apache.pinot.core.query.aggregation.function.LastWithTimeAggregationFunction;
import org.apache.pinot.core.query.aggregation.groupby.GroupByResultHolder;
import org.apache.pinot.segment.local.customobject.DoubleLongPair;
import org.apache.pinot.segment.local.customobject.ValueLongPair;

public class LastDoubleValueWithTimeAggregationFunction
extends LastWithTimeAggregationFunction<Double> {
    private static final ValueLongPair<Double> DEFAULT_VALUE_TIME_PAIR = new DoubleLongPair(Double.valueOf(Double.NaN), Long.MIN_VALUE);

    public LastDoubleValueWithTimeAggregationFunction(ExpressionContext dataCol, ExpressionContext timeCol) {
        super(dataCol, timeCol, ObjectSerDeUtils.DOUBLE_LONG_PAIR_SER_DE);
    }

    @Override
    public ValueLongPair<Double> constructValueLongPair(Double value, long time) {
        return new DoubleLongPair(value, time);
    }

    @Override
    public ValueLongPair<Double> getDefaultValueTimePair() {
        return DEFAULT_VALUE_TIME_PAIR;
    }

    @Override
    public void aggregateResultWithRawData(int length, AggregationResultHolder aggregationResultHolder, BlockValSet blockValSet, BlockValSet timeValSet) {
        ValueLongPair<Double> defaultValueLongPair = this.getDefaultValueTimePair();
        Double lastData = (Double)defaultValueLongPair.getValue();
        long lastTime = defaultValueLongPair.getTime();
        double[] doubleValues = blockValSet.getDoubleValuesSV();
        long[] timeValues = timeValSet.getLongValuesSV();
        for (int i = 0; i < length; ++i) {
            double data = doubleValues[i];
            long time = timeValues[i];
            if (time < lastTime) continue;
            lastTime = time;
            lastData = data;
        }
        this.setAggregationResult(aggregationResultHolder, lastData, lastTime);
    }

    @Override
    public void aggregateGroupResultWithRawDataSv(int length, int[] groupKeyArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet, BlockValSet timeValSet) {
        double[] doubleValues = blockValSet.getDoubleValuesSV();
        long[] timeValues = timeValSet.getLongValuesSV();
        for (int i = 0; i < length; ++i) {
            double data = doubleValues[i];
            long time = timeValues[i];
            this.setGroupByResult(groupKeyArray[i], groupByResultHolder, data, time);
        }
    }

    @Override
    public void aggregateGroupResultWithRawDataMv(int length, int[][] groupKeysArray, GroupByResultHolder groupByResultHolder, BlockValSet blockValSet, BlockValSet timeValSet) {
        double[] doubleValues = blockValSet.getDoubleValuesSV();
        long[] timeValues = timeValSet.getLongValuesSV();
        for (int i = 0; i < length; ++i) {
            double value = doubleValues[i];
            long time = timeValues[i];
            for (int groupKey : groupKeysArray[i]) {
                this.setGroupByResult(groupKey, groupByResultHolder, value, time);
            }
        }
    }

    @Override
    public String getResultColumnName() {
        return this.getType().getName().toLowerCase() + "(" + this._expression + "," + this._timeCol + ",'DOUBLE')";
    }

    @Override
    public String getColumnName() {
        return this.getType().getName() + "_" + this._expression + "_" + this._timeCol + "_DOUBLE";
    }

    @Override
    public DataSchema.ColumnDataType getFinalResultColumnType() {
        return DataSchema.ColumnDataType.DOUBLE;
    }
}

